/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzmj;
import com.google.android.gms.internal.firebase-auth-api.zzml;
import com.google.android.gms.internal.firebase-auth-api.zzmm;
import com.google.android.gms.internal.firebase-auth-api.zzmo;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import javax.annotation.Nullable;

public final class zzmk {
    @Nullable
    private Integer zza = null;
    @Nullable
    private Integer zzb = null;
    private zzml zzc = null;
    private zzmm zzd;

    public final zzmk zza(zzml zzml2) {
        this.zzc = zzml2;
        return this;
    }

    public final zzmk zzb(int n) throws GeneralSecurityException {
        this.zza = n;
        return this;
    }

    public final zzmk zzc(int n) throws GeneralSecurityException {
        this.zzb = n;
        return this;
    }

    public final zzmk zzd(zzmm zzmm2) {
        this.zzd = zzmm2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzmo zze() throws GeneralSecurityException {
        Object[] objectArray;
        Object[] objectArray2 = objectArray.zza;
        if (objectArray2 == null) {
            throw new GeneralSecurityException("key size is not set");
        }
        if (objectArray.zzb == null) {
            throw new GeneralSecurityException("tag size is not set");
        }
        if (objectArray.zzc == null) {
            throw new GeneralSecurityException("hash type is not set");
        }
        if (objectArray.zzd == null) {
            throw new GeneralSecurityException("variant is not set");
        }
        if (objectArray2.intValue() < 16) {
            objectArray2 = new Object[]{objectArray.zza};
            throw new InvalidAlgorithmParameterException(String.format("Invalid key size in bytes %d; must be at least 16 bytes", objectArray2));
        }
        int n = objectArray.zzb;
        zzml zzml2 = objectArray.zzc;
        if (n < 10) {
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; must be at least 10 bytes", objectArray));
        }
        if (zzml2 == zzml.zza) {
            if (n <= 20) return new zzmo(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 20 bytes for SHA1", objectArray));
        }
        if (zzml2 == zzml.zzb) {
            if (n <= 28) return new zzmo(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 28 bytes for SHA224", objectArray));
        }
        if (zzml2 == zzml.zzc) {
            if (n <= 32) return new zzmo(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 32 bytes for SHA256", objectArray));
        }
        if (zzml2 == zzml.zzd) {
            if (n <= 48) return new zzmo(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 48 bytes for SHA384", objectArray));
        }
        if (zzml2 != zzml.zze) {
            throw new GeneralSecurityException("unknown hash type; must be SHA256, SHA384 or SHA512");
        }
        if (n <= 64) {
            return new zzmo(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
        }
        objectArray = new Object[]{n};
        throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 64 bytes for SHA512", objectArray));
    }

    private zzmk() {
        throw null;
    }

    /* synthetic */ zzmk(zzmj zzmj2) {
        this.zzd = zzmm.zzd;
    }
}

