/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzhh;
import com.google.android.gms.internal.firebase-auth-api.zzna;
import com.google.android.gms.internal.firebase-auth-api.zzts;
import com.google.android.gms.internal.firebase-auth-api.zzuj;
import com.google.android.gms.internal.firebase-auth-api.zzuv;
import com.google.android.gms.internal.firebase-auth-api.zzvb;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zztr
implements zzbg {
    private static final Collection zza = Arrays.asList(64);
    private static final byte[] zzb = new byte[16];
    private final zzuv zzc;
    private final byte[] zzd;

    public zztr(byte[] byArray) throws GeneralSecurityException {
        if (!zzhh.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-SIV in FIPS-mode.");
        }
        int n = byArray.length;
        if (!zza.contains(n)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid key size: ");
            stringBuilder.append(n);
            stringBuilder.append(" bytes; key must have 64 bytes");
            throw new InvalidKeyException(stringBuilder.toString());
        }
        int n2 = n >> 1;
        byArray = Arrays.copyOfRange(byArray, 0, n2);
        this.zzd = Arrays.copyOfRange(byArray, n2, n);
        this.zzc = new zzuv(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        if (n < 16) {
            throw new GeneralSecurityException("Ciphertext too short.");
        }
        Cipher cipher = (Cipher)zzuj.zza.zza("AES/CTR/NoPadding");
        byte[] byArray3 = Arrays.copyOfRange(byArray, 0, 16);
        byte[] byArray4 = (byte[])byArray3.clone();
        byArray4[8] = (byte)(byArray4[8] & 0x7F);
        byArray4[12] = (byte)(byArray4[12] & 0x7F);
        cipher.init(2, (Key)new SecretKeySpec(this.zzd, "AES"), new IvParameterSpec(byArray4));
        byte[] byArray5 = Arrays.copyOfRange(byArray, 16, n);
        byArray = cipher.doFinal(byArray5);
        if (byArray5.length == 0 && byArray == null && zzvb.zza()) {
            byArray = new byte[]{};
        }
        byte[][] byArrayArray = new byte[][]{byArray2, byArray};
        byArray2 = this.zzc.zza(zzb, 16);
        for (n = 0; n <= 0; ++n) {
            byArray4 = byArrayArray[n];
            if (byArray4 == null) {
                byArray4 = new byte[]{};
            }
            byArray2 = zzts.zzc(zzna.zzb(byArray2), this.zzc.zza(byArray4, 16));
        }
        byte[] byArray6 = byArrayArray[1];
        int n2 = byArray6.length;
        if (n2 >= 16) {
            int n3 = byArray2.length;
            if (n2 < n3) {
                throw new IllegalArgumentException("xorEnd requires a.length >= b.length");
            }
            byte[] byArray7 = Arrays.copyOf(byArray6, n2);
            for (int i = 0; i < byArray2.length; ++i) {
                int n4 = n2 - n3 + i;
                byArray7[n4] = (byte)(byArray7[n4] ^ byArray2[i]);
            }
            byArray2 = byArray7;
        } else {
            byArray2 = zzts.zzc(zzna.zza(byArray6), zzna.zzb(byArray2));
        }
        if (MessageDigest.isEqual(byArray3, this.zzc.zza(byArray2, 16))) {
            return byArray;
        }
        throw new AEADBadTagException("Integrity check failed.");
    }
}

