/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzje;
import com.google.android.gms.internal.firebase-auth-api.zzuj;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public final class zzua {
    public static int zza(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        return (zzje.zza(ellipticCurve).subtract(BigInteger.ONE).bitLength() + 7) / 8;
    }

    /*
     * Unable to fully structure code
     */
    public static BigInteger zzb(BigInteger var0, boolean var1_1, EllipticCurve var2_2) throws GeneralSecurityException {
        block10: {
            block8: {
                block13: {
                    block11: {
                        block9: {
                            var5_5 = zzje.zza((EllipticCurve)var2_2);
                            var3_6 = var2_2.getA();
                            var2_2 = var2_2.getB();
                            v0 = var0;
                            var0 = v0.multiply(v0).add(var3_6).multiply(var0).add((BigInteger)var2_2).mod(var5_5);
                            if (var5_5.signum() != 1) {
                                throw new InvalidAlgorithmParameterException("p must be positive");
                            }
                            var6_7 = var0.mod(var5_5);
                            if (var6_7.equals(BigInteger.ZERO)) {
                                var0 = BigInteger.ZERO;
lbl11:
                                // 4 sources

                                while (true) {
                                    if (var1_1 != var0.testBit(0)) {
                                        return var5_5.subtract(var0).mod(var5_5);
                                    }
                                    return var0;
                                }
                            }
                            if (!var5_5.testBit(0) || !var5_5.testBit(1)) break block9;
                            var0 = var6_7.modPow(var5_5.add(BigInteger.ONE).shiftRight(2), var5_5);
lbl17:
                            // 4 sources

                            while (true) {
                                if (var0 == null) ** GOTO lbl11
                                v1 = var0;
                                if (v1.multiply(v1).mod(var5_5).compareTo(var6_7) == 0) ** GOTO lbl11
                                break block8;
                                break;
                            }
                        }
                        if (!var5_5.testBit(0)) break block10;
                        if (var5_5.testBit(1)) break block11;
                        var3_6 = var5_5.subtract(BigInteger.ONE).shiftRight(1);
                        var0 = BigInteger.ONE;
                        var2_3 = 0;
                        do {
                            block12: {
                                v2 = var0;
                                var7_10 = v2.multiply(v2).subtract(var6_7).mod(var5_5);
                                if (!var7_10.equals(BigInteger.ZERO)) ** break;
                                ** continue;
                                var4_8 = var7_10.modPow(var3_6, var5_5);
                                if (!var4_8.add(BigInteger.ONE).equals(var5_5)) break block12;
                                var8_11 = var5_5.add(BigInteger.ONE).shiftRight(1);
                                var3_6 = BigInteger.ONE;
                                var2_4 = var0;
                                for (var4_9 = var8_11.bitLength() + -2; var4_9 >= 0; --var4_9) {
                                    v3 = var2_4.multiply(var3_6);
                                    v4 = var2_4;
                                    v5 = var3_6;
                                    var2_4 = v4.multiply(v4).add(v5.multiply(v5).mod(var5_5).multiply(var7_10)).mod(var5_5);
                                    var3_6 = v3.add(v3).mod(var5_5);
                                    if (!var8_11.testBit(var4_9)) continue;
                                    var9_12 = var2_4.multiply(var0).add(var3_6.multiply(var7_10)).mod(var5_5);
                                    v6 = var0.multiply(var3_6).add(var2_4).mod(var5_5);
                                    var2_4 = var9_12;
                                    var3_6 = v6;
                                }
                                var0 = var2_4;
                                ** GOTO lbl17
                            }
                            if (!var4_8.equals(BigInteger.ONE)) {
                                throw new InvalidAlgorithmParameterException("p is not prime");
                            }
                            var0 = var0.add(BigInteger.ONE);
                        } while (++var2_3 != 128 || var5_5.isProbablePrime(80));
                        break block13;
                    }
                    var0 = null;
                    ** GOTO lbl17
                }
                throw new InvalidAlgorithmParameterException("p is not prime");
            }
            throw new GeneralSecurityException("Could not find a modular square root");
        }
        var0 = null;
        ** while (true)
    }

    public static KeyPair zzc(ECParameterSpec eCParameterSpec) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = (KeyPairGenerator)zzuj.zzf.zza("EC");
        keyPairGenerator.initialize(eCParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    public static void zzd(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws GeneralSecurityException {
        zzua.zze(eCPublicKey, eCPrivateKey);
        zzje.zzb(eCPublicKey.getW(), eCPrivateKey.getParams().getCurve());
    }

    static void zze(ECPublicKey object, ECPrivateKey object2) throws GeneralSecurityException {
        block7: {
            block6: {
                object = object.getParams();
                object2 = object2.getParams();
                boolean bl = ((ECParameterSpec)object).getCurve().equals(((ECParameterSpec)object2).getCurve());
                if (!bl) break block6;
                bl = ((ECParameterSpec)object).getGenerator().equals(((ECParameterSpec)object2).getGenerator());
                if (!bl) break block6;
                bl = ((ECParameterSpec)object).getOrder().equals(((ECParameterSpec)object2).getOrder());
                if (!bl) break block6;
                int n = ((ECParameterSpec)object).getCofactor();
                int n2 = ((ECParameterSpec)object2).getCofactor();
                if (n == n2) break block7;
            }
            try {
                throw new GeneralSecurityException("invalid public key spec");
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                throw new GeneralSecurityException(runtimeException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zzf(ECPrivateKey object, ECPublicKey object2) throws GeneralSecurityException {
        zzua.zze((ECPublicKey)object2, (ECPrivateKey)object);
        object2 = object2.getW();
        zzje.zzb((ECPoint)object2, object.getParams().getCurve());
        Object object3 = object.getParams();
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec((ECPoint)object2, (ECParameterSpec)object3);
        object2 = ((KeyFactory)zzuj.zzg.zza("EC")).generatePublic(eCPublicKeySpec);
        object3 = (KeyAgreement)zzuj.zze.zza("ECDH");
        ((KeyAgreement)object3).init((Key)object);
        try {
            ((KeyAgreement)object3).doPhase((Key)object2, true);
            object2 = ((KeyAgreement)object3).generateSecret();
            object = object.getParams().getCurve();
            object3 = new BigInteger(1, (byte[])object2);
            int n = ((BigInteger)object3).signum();
            if (n == -1) throw new GeneralSecurityException("shared secret is out of range");
            n = ((BigInteger)object3).compareTo(zzje.zza((EllipticCurve)object));
            if (n >= 0) {
                throw new GeneralSecurityException("shared secret is out of range");
            }
            zzua.zzb((BigInteger)object3, true, (EllipticCurve)object);
            return object2;
        }
        catch (IllegalStateException illegalStateException) {
            throw new GeneralSecurityException(illegalStateException);
        }
    }

    public static ECPrivateKey zzg(int n, byte[] object) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzua.zzi(n);
        BigInteger bigInteger = new BigInteger(1, (byte[])object);
        object = new ECPrivateKeySpec;
        object(bigInteger, eCParameterSpec);
        return (ECPrivateKey)((KeyFactory)zzuj.zzg.zza("EC")).generatePrivate((KeySpec)object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ECPublicKey zzh(ECParameterSpec eCParameterSpec, int n, byte[] object) throws GeneralSecurityException {
        Object object2;
        block11: {
            int n2;
            EllipticCurve ellipticCurve;
            block12: {
                ellipticCurve = eCParameterSpec.getCurve();
                n2 = zzua.zza(ellipticCurve);
                switch (n + -1) {
                    default: {
                        BigInteger bigInteger;
                        BigInteger bigInteger2 = zzje.zza(ellipticCurve);
                        int n3 = ((byte[])object).length;
                        if (n3 != n2 + 1) {
                            throw new GeneralSecurityException("compressed point has wrong length");
                        }
                        n = object[0];
                        if (n == 2) {
                            n = 0;
                        } else {
                            if (n != 3) break;
                            n = 1;
                        }
                        if ((bigInteger = new BigInteger(1, Arrays.copyOfRange(object, 1, n3))).signum() == -1 || bigInteger.compareTo(bigInteger2) >= 0) {
                            throw new GeneralSecurityException("x is out of range");
                        }
                        object2 = zzua.zzb(bigInteger, n != 0, ellipticCurve);
                        object2 = new ECPoint(bigInteger, (BigInteger)object2);
                        break block11;
                    }
                    case 2: {
                        n = ((byte[])object).length;
                        int n4 = n2;
                        if (n != n4 + n4) {
                            throw new GeneralSecurityException("invalid point size");
                        }
                        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(object, 0, n2));
                        BigInteger bigInteger3 = new BigInteger(1, Arrays.copyOfRange(object, n2, n));
                        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger3);
                        zzje.zzb(eCPoint, ellipticCurve);
                        object2 = eCPoint;
                        break block11;
                    }
                    case 0: {
                        n = ((byte[])object).length;
                        int n5 = n2++;
                        if (n != n5 + n5 + 1) {
                            throw new GeneralSecurityException("invalid point size");
                        }
                        if (object[0] != 4) {
                            throw new GeneralSecurityException("invalid point format");
                        }
                        break block12;
                    }
                }
                throw new GeneralSecurityException("invalid format");
            }
            BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(object, 1, n2));
            BigInteger bigInteger4 = new BigInteger(1, Arrays.copyOfRange(object, n2, n));
            ECPoint eCPoint = new ECPoint(bigInteger, bigInteger4);
            zzje.zzb(eCPoint, ellipticCurve);
            object2 = eCPoint;
        }
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec((ECPoint)object2, eCParameterSpec);
        return (ECPublicKey)((KeyFactory)zzuj.zzg.zza("EC")).generatePublic(eCPublicKeySpec);
    }

    public static ECParameterSpec zzi(int n) throws NoSuchAlgorithmException {
        switch (n + -1) {
            default: {
                return zzje.zzc;
            }
            case 0: {
                return zzje.zza;
            }
            case 1: 
        }
        return zzje.zzb;
    }
}

