/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-auth-api.zzaaf;
import com.google.android.gms.internal.firebase-auth-api.zzaaj;
import com.google.android.gms.internal.firebase-auth-api.zzaao;
import com.google.android.gms.internal.firebase-auth-api.zzaay;
import com.google.android.gms.internal.firebase-auth-api.zzabx;
import com.google.android.gms.internal.firebase-auth-api.zzach;
import com.google.android.gms.internal.firebase-auth-api.zzadg;
import com.google.android.gms.internal.firebase-auth-api.zzadp;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.android.recaptcha.RecaptchaAction;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuthMissingActivityForRecaptchaException;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorAssertion;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzai;
import com.google.firebase.auth.internal.zzbb;
import com.google.firebase.auth.internal.zzbq;
import com.google.firebase.auth.internal.zzbu;
import com.google.firebase.auth.internal.zzbw;
import com.google.firebase.auth.internal.zzbx;
import com.google.firebase.auth.internal.zzby;
import com.google.firebase.auth.internal.zzca;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzt;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.internal.zzz;
import com.google.firebase.auth.zzaa;
import com.google.firebase.auth.zzab;
import com.google.firebase.auth.zzac;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import com.google.firebase.auth.zzp;
import com.google.firebase.auth.zzq;
import com.google.firebase.auth.zzr;
import com.google.firebase.auth.zzs;
import com.google.firebase.auth.zzu;
import com.google.firebase.auth.zzv;
import com.google.firebase.auth.zzw;
import com.google.firebase.auth.zzx;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements InternalAuthProvider {
    private final FirebaseApp zzb;
    private final List zzc;
    private final List zzd;
    private final List zze;
    private final zzaaf zzf;
    @Nullable
    private FirebaseUser zzg;
    private final zzy zzh;
    private final Object zzi;
    private String zzj;
    private final Object zzk;
    private String zzl;
    private zzbq zzm;
    private final RecaptchaAction zzn;
    private final RecaptchaAction zzo;
    private final RecaptchaAction zzp;
    private final zzbu zzq;
    private final zzca zzr;
    private final zzh zzs;
    private final Provider zzt;
    private final Provider zzu;
    private zzbw zzv;
    private final zzbx zzw;
    public static final /* synthetic */ int zza;

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> applyActionCode(@NonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zzf.zza(this.zzb, (String)var1_1, this.zzl);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zzf.zzb(this.zzb, (String)var1_1, this.zzl);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String code, @NonNull String newPassword) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)code);
        Preconditions.checkNotEmpty((String)var2_2);
        return this.zzf.zzc(this.zzb, (String)var1_1, (String)var2_2, this.zzl);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String email, @NonNull String password) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotEmpty((String)var2_2);
        FirebaseAuth firebaseAuth = this;
        return new zzm(this, (String)var1_1, (String)var2_2).zzb(firebaseAuth, this.zzl, firebaseAuth.zzp);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String email) {
        void var1_1;
        Preconditions.checkNotEmpty((String)email);
        return this.zzf.zzf(this.zzb, (String)var1_1, this.zzl);
    }

    @NonNull
    public final Task getAccessToken(boolean bl) {
        FirebaseAuth firebaseAuth = this;
        return firebaseAuth.zzc(firebaseAuth.zzg, bl);
    }

    @Nullable
    public Task<AuthResult> getPendingAuthResult() {
        return this.zzr.zza();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String email) {
        void var1_1;
        Preconditions.checkNotEmpty((String)email);
        return this.sendPasswordResetEmail((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String email, @Nullable ActionCodeSettings actionCodeSettings) {
        void var1_1;
        String string;
        ActionCodeSettings actionCodeSettings2;
        Preconditions.checkNotEmpty((String)email);
        if (actionCodeSettings2 == null) {
            actionCodeSettings2 = ActionCodeSettings.zzb();
        }
        if ((string = this.zzj) != null) {
            actionCodeSettings2.zzf(string);
        }
        actionCodeSettings2.zzg(1);
        FirebaseAuth firebaseAuth = this;
        return new zzn(this, (String)var1_1, actionCodeSettings2).zzb(firebaseAuth, this.zzl, firebaseAuth.zzn);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendSignInLinkToEmail(@NonNull String email, @NonNull ActionCodeSettings actionCodeSettings) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotNull((Object)var2_2);
        if (!var2_2.canHandleCodeInApp()) {
            throw new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
        }
        String string = this.zzj;
        if (string != null) {
            var2_2.zzf(string);
        }
        FirebaseAuth firebaseAuth = this;
        return new zzo(this, (String)var1_1, (ActionCodeSettings)var2_2).zzb(firebaseAuth, this.zzl, firebaseAuth.zzn);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> setFirebaseUIVersion(@Nullable String firebaseUIVersion) {
        void var1_1;
        return this.zzf.zzy((String)var1_1);
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        FirebaseUser firebaseUser = ((FirebaseAuth)((Object)this_)).zzg;
        if (firebaseUser != null && firebaseUser.isAnonymous()) {
            zzz this_ = (zzz)((FirebaseAuth)((Object)this_)).zzg;
            this_.zzq(false);
            return Tasks.forResult((Object)new zzt(this_));
        }
        return ((FirebaseAuth)((Object)this_)).zzf.zzz(((FirebaseAuth)((Object)this_)).zzb, new zzaa((FirebaseAuth)((Object)this_)), ((FirebaseAuth)((Object)this_)).zzl);
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential credential) {
        AuthCredential authCredential;
        Preconditions.checkNotNull((Object)((Object)credential));
        authCredential = authCredential.zza();
        if (authCredential instanceof EmailAuthCredential) {
            if (!((EmailAuthCredential)(authCredential = (EmailAuthCredential)authCredential)).zzg()) {
                FirebaseAuth firebaseAuth = this;
                return firebaseAuth.zzV(((EmailAuthCredential)authCredential).zzd(), (String)Preconditions.checkNotNull((Object)((EmailAuthCredential)authCredential).zze()), firebaseAuth.zzl, null, false);
            }
            if (this.zzY(Preconditions.checkNotEmpty((String)((EmailAuthCredential)authCredential).zzf()))) {
                return Tasks.forException((Exception)zzaaj.zza(new Status(17072)));
            }
            return this.zzW((EmailAuthCredential)authCredential, null, false);
        }
        if (authCredential instanceof PhoneAuthCredential) {
            authCredential = (PhoneAuthCredential)authCredential;
            return this.zzf.zzE(this.zzb, (PhoneAuthCredential)authCredential, this.zzl, new zzaa(this));
        }
        return this.zzf.zzA(this.zzb, authCredential, this.zzl, new zzaa(this));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String token) {
        void var1_1;
        Preconditions.checkNotEmpty((String)token);
        return this.zzf.zzB(this.zzb, (String)var1_1, this.zzl, new zzaa(this));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String email, @NonNull String password) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotEmpty((String)var2_2);
        FirebaseAuth firebaseAuth = this;
        return firebaseAuth.zzV((String)var1_1, (String)var2_2, firebaseAuth.zzl, null, false);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String email, @NonNull String link) {
        void var2_2;
        void var1_1;
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> startActivityForSignInWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)var1_1);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzr.zzi((Activity)var1_1, taskCompletionSource, this)) {
            return Tasks.forException((Exception)zzaaj.zza(new Status(17057)));
        }
        this.zzr.zzg(var1_1.getApplicationContext(), this);
        var2_2.zzc((Activity)var1_1);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> updateCurrentUser(@NonNull FirebaseUser user) {
        String string;
        void var1_1;
        if (user == null) {
            throw new IllegalArgumentException("Cannot update current user with null user!");
        }
        String string2 = var1_1.getTenantId();
        if ((string2 == null || string2.equals(this.zzl)) && ((string = this.zzl) == null || string.equals(string2))) {
            string2 = var1_1.zza().getOptions().getApiKey();
            string = this.zzb.getOptions().getApiKey();
            if (var1_1.zzd().zzj() && string.equals(string2)) {
                FirebaseAuth firebaseAuth = this;
                firebaseAuth.zzM(zzz.zzk(firebaseAuth.zzb, (FirebaseUser)var1_1), var1_1.zzd(), true);
                return Tasks.forResult(null);
            }
            return this.zzi((FirebaseUser)var1_1, new zzac(this));
        }
        return Tasks.forException((Exception)zzaaj.zza(new Status(17072)));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zzf.zzO(this.zzb, (String)var1_1, this.zzl);
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zzb;
    }

    @Keep
    @NonNull
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @Keep
    @NonNull
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    @NonNull
    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzh;
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzg;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getLanguageCode() {
        Object object = ((FirebaseAuth)this_).zzi;
        synchronized (object) {
            return ((FirebaseAuth)this_).zzj;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getTenantId() {
        Object object = ((FirebaseAuth)this_).zzk;
        synchronized (object) {
            return ((FirebaseAuth)this_).zzl;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Nullable
    public final String getUid() {
        FirebaseUser firebaseUser = ((FirebaseAuth)((Object)firebaseUser)).zzg;
        if (firebaseUser == null) {
            return null;
        }
        return firebaseUser.getUid();
    }

    public FirebaseAuth(@NonNull FirebaseApp object, @NonNull Provider provider, @NonNull Provider provider2) {
        zzaaf zzaaf2 = new zzaaf((FirebaseApp)object);
        zzbu zzbu2 = new zzbu(object.getApplicationContext(), object.getPersistenceKey());
        zzca zzca2 = zzca.zzc();
        zzh zzh2 = com.google.firebase.auth.internal.zzh.zzb();
        this.zzc = new CopyOnWriteArrayList();
        this.zzd = new CopyOnWriteArrayList();
        this.zze = new CopyOnWriteArrayList();
        this.zzi = new Object();
        this.zzk = new Object();
        this.zzn = RecaptchaAction.custom((String)"getOobCode");
        this.zzo = RecaptchaAction.custom((String)"signInWithPassword");
        this.zzp = RecaptchaAction.custom((String)"signUpPassword");
        this.zzw = zzbx.zza();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzb = (FirebaseApp)Preconditions.checkNotNull((Object)object);
        firebaseAuth.zzf = (zzaaf)Preconditions.checkNotNull((Object)zzaaf2);
        firebaseAuth.zzq = (zzbu)Preconditions.checkNotNull((Object)zzbu2);
        FirebaseAuth firebaseAuth2 = this;
        firebaseAuth2.zzh = new zzy();
        firebaseAuth2.zzr = (zzca)Preconditions.checkNotNull((Object)zzca2);
        firebaseAuth2.zzs = (zzh)Preconditions.checkNotNull((Object)zzh2);
        this.zzt = provider;
        this.zzu = provider2;
        this.zzg = this.zzq.zza();
        object = this.zzg;
        if (object != null && (object = this.zzq.zzb((FirebaseUser)object)) != null) {
            FirebaseAuth firebaseAuth3 = this;
            FirebaseAuth.zzP(firebaseAuth3, firebaseAuth3.zzg, (zzadg)object, false, false);
        }
        this.zzr.zze(this);
    }

    /*
     * WARNING - void declaration
     */
    public void addAuthStateListener(@NonNull AuthStateListener listener) {
        void var1_1;
        this.zze.add(var1_1);
        this.zzw.execute(new zzs(this, (AuthStateListener)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addIdTokenListener(@NonNull IdTokenListener listener) {
        void var1_1;
        this.zzc.add(var1_1);
        ((zzbx)Preconditions.checkNotNull((Object)this.zzw)).execute(new zzr(this, (IdTokenListener)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener listener) {
        void var1_1;
        Preconditions.checkNotNull((Object)listener);
        this.zzd.add(var1_1);
        this.zzB().zzd(this.zzd.size());
    }

    /*
     * WARNING - void declaration
     */
    public void removeAuthStateListener(@NonNull AuthStateListener listener) {
        void var1_1;
        this.zze.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeIdTokenListener(@NonNull IdTokenListener listener) {
        void var1_1;
        this.zzc.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener listenerToRemove) {
        void var1_1;
        Preconditions.checkNotNull((Object)listenerToRemove);
        this.zzd.remove(var1_1);
        this.zzB().zzd(this.zzd.size());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLanguageCode(@NonNull String languageCode) {
        Preconditions.checkNotEmpty((String)languageCode);
        Object object = this.zzi;
        synchronized (object) {
            void var1_2;
            this.zzj = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTenantId(@NonNull String tenantId) {
        Preconditions.checkNotEmpty((String)tenantId);
        Object object = this.zzk;
        synchronized (object) {
            void var1_2;
            this.zzl = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public void signOut() {
        ((FirebaseAuth)((Object)this_)).zzK();
        zzbw this_ = ((FirebaseAuth)((Object)this_)).zzv;
        if (this_ != null) {
            this_.zzc();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void useAppLanguage() {
        Object object = this.zzi;
        synchronized (object) {
            this.zzj = zzaay.zza();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void useEmulator(@NonNull String host, int port) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)host);
        boolean bl = var2_2 >= 0 ? var2_2 <= 65535 : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Port number must be in the range 0-65535");
        zzach.zzf(this.zzb, (String)var1_1, (int)var2_2);
    }

    public boolean isSignInWithEmailLink(@NonNull String link) {
        return EmailAuthCredential.zzi(link);
    }

    @NonNull
    public final Task zza(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzf.zze(firebaseUser, new zzq(this, firebaseUser));
    }

    @NonNull
    public final Task zzb(@NonNull FirebaseUser firebaseUser, @NonNull MultiFactorAssertion multiFactorAssertion, @Nullable String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        if (multiFactorAssertion instanceof PhoneMultiFactorAssertion) {
            return this.zzf.zzg(this.zzb, (PhoneMultiFactorAssertion)multiFactorAssertion, firebaseUser, string, new zzaa(this));
        }
        return Tasks.forException((Exception)zzaaj.zza(new Status(17499)));
    }

    @NonNull
    public final Task zzc(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzaaj.zza(new Status(17495)));
        }
        zzadg zzadg2 = firebaseUser.zzd();
        if (zzadg2.zzj() && !bl) {
            return Tasks.forResult((Object)zzbb.zza(zzadg2.zze()));
        }
        return this.zzf.zzi(this.zzb, firebaseUser, zzadg2.zzf(), new zzv(this));
    }

    @NonNull
    public final Task zzd() {
        return this.zzf.zzj();
    }

    @NonNull
    public final Task zze(@NonNull String string) {
        return this.zzf.zzk(this.zzl, "RECAPTCHA_ENTERPRISE");
    }

    @NonNull
    public final Task zzf(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzf.zzl(this.zzb, firebaseUser, authCredential.zza(), new zzab(this));
    }

    @NonNull
    public final Task zzg(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        authCredential = authCredential.zza();
        if (authCredential instanceof EmailAuthCredential) {
            String string = ((EmailAuthCredential)(authCredential = (EmailAuthCredential)authCredential)).getSignInMethod();
            if ("password".equals(string)) {
                return this.zzU(firebaseUser, (EmailAuthCredential)authCredential, false);
            }
            if (this.zzY(Preconditions.checkNotEmpty((String)((EmailAuthCredential)authCredential).zzf()))) {
                return Tasks.forException((Exception)zzaaj.zza(new Status(17072)));
            }
            return this.zzU(firebaseUser, (EmailAuthCredential)authCredential, true);
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzf.zzs(this.zzb, firebaseUser, (PhoneAuthCredential)authCredential, this.zzl, new zzab(this));
        }
        FirebaseUser firebaseUser2 = firebaseUser;
        return this.zzf.zzm(this.zzb, firebaseUser2, authCredential, firebaseUser2.getTenantId(), new zzab(this));
    }

    @NonNull
    public final Task zzh(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        authCredential = authCredential.zza();
        if (authCredential instanceof EmailAuthCredential) {
            String string = ((EmailAuthCredential)(authCredential = (EmailAuthCredential)authCredential)).getSignInMethod();
            if ("password".equals(string)) {
                return this.zzV(((EmailAuthCredential)authCredential).zzd(), Preconditions.checkNotEmpty((String)((EmailAuthCredential)authCredential).zze()), firebaseUser.getTenantId(), firebaseUser, true);
            }
            if (this.zzY(Preconditions.checkNotEmpty((String)((EmailAuthCredential)authCredential).zzf()))) {
                return Tasks.forException((Exception)zzaaj.zza(new Status(17072)));
            }
            return this.zzW((EmailAuthCredential)authCredential, firebaseUser, true);
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzf.zzt(this.zzb, firebaseUser, (PhoneAuthCredential)authCredential, this.zzl, new zzab(this));
        }
        FirebaseUser firebaseUser2 = firebaseUser;
        return this.zzf.zzn(this.zzb, firebaseUser2, authCredential, firebaseUser2.getTenantId(), new zzab(this));
    }

    public final Task zzi(FirebaseUser firebaseUser, zzby zzby2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzf.zzu(this.zzb, firebaseUser, zzby2);
    }

    public final Task zzj(MultiFactorAssertion multiFactorAssertion, zzai zzai2, @Nullable FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        Preconditions.checkNotNull((Object)((Object)zzai2));
        return this.zzf.zzh(this.zzb, firebaseUser, (PhoneMultiFactorAssertion)multiFactorAssertion, Preconditions.checkNotEmpty((String)zzai2.zzd()), new zzaa(this));
    }

    @NonNull
    public final Task zzk(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzj != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zzb();
            }
            actionCodeSettings.zzf(this.zzj);
        }
        return this.zzf.zzv(this.zzb, actionCodeSettings, string);
    }

    @NonNull
    public final Task zzl(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzr.zzj(activity, taskCompletionSource, this, firebaseUser)) {
            return Tasks.forException((Exception)zzaaj.zza(new Status(17057)));
        }
        this.zzr.zzh(activity.getApplicationContext(), this, firebaseUser);
        federatedAuthProvider.zza(activity);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public final Task zzm(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzr.zzj(activity, taskCompletionSource, this, firebaseUser)) {
            return Tasks.forException((Exception)zzaaj.zza(new Status(17057)));
        }
        this.zzr.zzh(activity.getApplicationContext(), this, firebaseUser);
        federatedAuthProvider.zzb(activity);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public final Task zzn(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzf.zzH(this.zzb, firebaseUser, string, new zzab(this)).continueWithTask((Continuation)new zzp(this));
    }

    @NonNull
    public final Task zzo(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzf.zzI(this.zzb, firebaseUser, string, new zzab(this));
    }

    @NonNull
    public final Task zzp(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzf.zzJ(this.zzb, firebaseUser, string, new zzab(this));
    }

    @NonNull
    public final Task zzq(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzf.zzK(this.zzb, firebaseUser, string, new zzab(this));
    }

    @NonNull
    public final Task zzr(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        return this.zzf.zzL(this.zzb, firebaseUser, phoneAuthCredential.zzb(), new zzab(this));
    }

    @NonNull
    public final Task zzs(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzf.zzM(this.zzb, firebaseUser, userProfileChangeRequest, new zzab(this));
    }

    @NonNull
    public final Task zzt(@NonNull String string, @NonNull String string2, @Nullable ActionCodeSettings actionCodeSettings) {
        String string3;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zzb();
        }
        if ((string3 = this.zzj) != null) {
            actionCodeSettings.zzf(string3);
        }
        return this.zzf.zzN(string, string2, actionCodeSettings);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Task zzU(FirebaseUser firebaseUser, EmailAuthCredential object, boolean bl) {
        void var3_4;
        com.google.firebase.auth.zzy zzy2 = new com.google.firebase.auth.zzy(this, (boolean)var3_4, firebaseUser, (EmailAuthCredential)((Object)object));
        String string = this.zzl;
        if (var3_4 != false) {
            firebaseUser = this.zzn;
            return zzy2.zzb(this, string, (RecaptchaAction)firebaseUser);
        }
        firebaseUser = this.zzo;
        return zzy2.zzb(this, string, (RecaptchaAction)firebaseUser);
    }

    private final Task zzV(String string, String string2, @Nullable String string3, @Nullable FirebaseUser firebaseUser, boolean bl) {
        FirebaseAuth firebaseAuth = this;
        return new zzw(this, string, bl, firebaseUser, string2, string3).zzb(firebaseAuth, string3, firebaseAuth.zzo);
    }

    private final Task zzW(EmailAuthCredential emailAuthCredential, @Nullable FirebaseUser firebaseUser, boolean bl) {
        zzx zzx2 = new zzx(this, bl, firebaseUser, emailAuthCredential);
        emailAuthCredential = this.zzn;
        FirebaseAuth firebaseAuth = this;
        return zzx2.zzb(firebaseAuth, firebaseAuth.zzl, (RecaptchaAction)emailAuthCredential);
    }

    static /* bridge */ /* synthetic */ FirebaseApp zzu(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzb;
    }

    static /* bridge */ /* synthetic */ FirebaseUser zzv(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzg;
    }

    static /* bridge */ /* synthetic */ PhoneAuthProvider.OnVerificationStateChangedCallbacks zzw(FirebaseAuth firebaseAuth, String string, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        return firebaseAuth.zzX(string, onVerificationStateChangedCallbacks);
    }

    @VisibleForTesting
    final PhoneAuthProvider.OnVerificationStateChangedCallbacks zzx(PhoneAuthOptions phoneAuthOptions, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        if (phoneAuthOptions.zzk()) {
            return onVerificationStateChangedCallbacks;
        }
        return new zzl(this, phoneAuthOptions, onVerificationStateChangedCallbacks);
    }

    private final PhoneAuthProvider.OnVerificationStateChangedCallbacks zzX(@Nullable String string, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        zzy zzy2 = this.zzh;
        if (zzy2.zzd() && string != null && string.equals(zzy2.zza())) {
            return new zzk(this, onVerificationStateChangedCallbacks);
        }
        return onVerificationStateChangedCallbacks;
    }

    static /* bridge */ /* synthetic */ zzaaf zzy(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzf;
    }

    static /* bridge */ /* synthetic */ zzy zzz(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzh;
    }

    public final synchronized zzbq zzA() {
        return this.zzm;
    }

    @VisibleForTesting
    public final synchronized zzbw zzB() {
        return FirebaseAuth.zzC(this);
    }

    public static zzbw zzC(FirebaseAuth firebaseAuth) {
        if (firebaseAuth.zzv == null) {
            FirebaseApp firebaseApp = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseAuth.zzb);
            firebaseAuth.zzv = new zzbw(firebaseApp);
        }
        return firebaseAuth.zzv;
    }

    @NonNull
    public final Provider zzD() {
        return this.zzt;
    }

    @NonNull
    public final Provider zzE() {
        return this.zzu;
    }

    static /* bridge */ /* synthetic */ String zzF(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzj;
    }

    static /* bridge */ /* synthetic */ String zzG(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzl;
    }

    static /* bridge */ /* synthetic */ List zzH(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zze;
    }

    static /* bridge */ /* synthetic */ List zzI(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzc;
    }

    static /* bridge */ /* synthetic */ List zzJ(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzd;
    }

    public final void zzK() {
        Preconditions.checkNotNull((Object)this.zzq);
        FirebaseUser firebaseUser = this.zzg;
        if (firebaseUser != null) {
            Preconditions.checkNotNull((Object)firebaseUser);
            Object[] objectArray = new Object[]{firebaseUser.getUid()};
            this.zzq.zzc(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", objectArray));
            this.zzg = null;
        }
        this.zzq.zzc("com.google.firebase.auth.FIREBASE_USER");
        FirebaseAuth.zzO(this, null);
        FirebaseAuth.zzN(this, null);
    }

    public final synchronized void zzL(zzbq zzbq2) {
        this.zzm = zzbq2;
    }

    public final void zzM(FirebaseUser firebaseUser, zzadg zzadg2, boolean bl) {
        FirebaseAuth.zzP(this, firebaseUser, zzadg2, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzN(@NonNull FirebaseAuth firebaseAuth, @Nullable FirebaseUser object) {
        if (object != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Notifying auth state listeners about user ( ");
            stringBuilder.append(((FirebaseUser)object).getUid());
            stringBuilder.append(" ).");
            object = stringBuilder.toString();
            Log.d((String)"FirebaseAuth", (String)object);
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        firebaseAuth.zzw.execute(new zzu(firebaseAuth));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzO(@NonNull FirebaseAuth firebaseAuth, @Nullable FirebaseUser object) {
        if (object != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Notifying id token listeners about user ( ");
            stringBuilder.append(((FirebaseUser)object).getUid());
            stringBuilder.append(" ).");
            String string = stringBuilder.toString();
            Log.d((String)"FirebaseAuth", (String)string);
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        object = object != null ? ((FirebaseUser)object).zze() : null;
        InternalTokenResult internalTokenResult = new InternalTokenResult((String)object);
        firebaseAuth.zzw.execute(new com.google.firebase.auth.zzt(firebaseAuth, internalTokenResult));
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static void zzP(FirebaseAuth firebaseAuth, FirebaseUser firebaseUser, zzadg zzadg2, boolean bl, boolean bl2) {
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzadg2);
        boolean bl4 = firebaseAuth.zzg != null ? firebaseUser.getUid().equals(firebaseAuth.zzg.getUid()) : false;
        if (!bl4 && bl2) {
            return;
        }
        FirebaseUser firebaseUser2 = firebaseAuth.zzg;
        if (firebaseUser2 == null) {
            bl3 = true;
            bl4 = true;
        } else {
            bl3 = firebaseUser2.zzd().zze().equals(zzadg2.zze()) ^ true;
            bl3 = bl4 ? bl3 : true;
            bl4 ^= true;
        }
        Preconditions.checkNotNull((Object)firebaseUser);
        Object object = firebaseAuth.zzg;
        if (object == null) {
            firebaseAuth.zzg = firebaseUser;
        } else {
            ((FirebaseUser)object).zzc(firebaseUser.getProviderData());
            if (!firebaseUser.isAnonymous()) {
                firebaseAuth.zzg.zzb();
            }
            object = firebaseUser.getMultiFactor().getEnrolledFactors();
            firebaseAuth.zzg.zzi((List)object);
        }
        if (bl) {
            firebaseAuth.zzq.zzd(firebaseAuth.zzg);
        }
        if (bl3) {
            FirebaseUser firebaseUser3 = firebaseAuth.zzg;
            if (firebaseUser3 != null) {
                firebaseUser3.zzh(zzadg2);
            }
            FirebaseAuth firebaseAuth2 = firebaseAuth;
            FirebaseAuth.zzO(firebaseAuth2, firebaseAuth2.zzg);
        }
        if (bl4) {
            FirebaseAuth firebaseAuth3 = firebaseAuth;
            FirebaseAuth.zzN(firebaseAuth3, firebaseAuth3.zzg);
        }
        if (bl) {
            firebaseAuth.zzq.zze(firebaseUser, zzadg2);
        }
        if ((firebaseUser = firebaseAuth.zzg) != null) {
            FirebaseAuth.zzC(firebaseAuth).zze(firebaseUser.zzd());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzQ(@NonNull PhoneAuthOptions phoneAuthOptions) {
        Object object;
        if (phoneAuthOptions.zzm()) {
            String string;
            FirebaseAuth firebaseAuth = phoneAuthOptions.zzb();
            if (((zzai)((Object)Preconditions.checkNotNull((Object)((Object)phoneAuthOptions.zzc())))).zze()) {
                object = Preconditions.checkNotEmpty((String)phoneAuthOptions.zzh());
                string = object;
            } else {
                PhoneMultiFactorInfo phoneMultiFactorInfo = (PhoneMultiFactorInfo)((Object)Preconditions.checkNotNull((Object)((Object)phoneAuthOptions.zzf())));
                object = Preconditions.checkNotEmpty((String)phoneMultiFactorInfo.getUid());
                string = phoneMultiFactorInfo.getPhoneNumber();
            }
            if (phoneAuthOptions.zzd() != null && zzabx.zzd((String)object, phoneAuthOptions.zze(), phoneAuthOptions.zza(), phoneAuthOptions.zzi())) {
                return;
            }
            FirebaseAuth firebaseAuth2 = firebaseAuth;
            firebaseAuth.zzs.zza(firebaseAuth2, string, phoneAuthOptions.zza(), firebaseAuth2.zzS(), phoneAuthOptions.zzk()).addOnCompleteListener((OnCompleteListener)new zzj(firebaseAuth, phoneAuthOptions, (String)object));
            return;
        }
        object = phoneAuthOptions.zzb();
        String string = Preconditions.checkNotEmpty((String)phoneAuthOptions.zzh());
        if (phoneAuthOptions.zzd() != null || !zzabx.zzd(string, phoneAuthOptions.zze(), phoneAuthOptions.zza(), phoneAuthOptions.zzi())) {
            Object object2 = object;
            ((FirebaseAuth)object).zzs.zza((FirebaseAuth)object2, string, phoneAuthOptions.zza(), ((FirebaseAuth)object2).zzS(), phoneAuthOptions.zzk()).addOnCompleteListener((OnCompleteListener)new com.google.firebase.auth.zzz((FirebaseAuth)object, phoneAuthOptions, string));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzR(@NonNull PhoneAuthOptions phoneAuthOptions, @Nullable String object, @Nullable String object2, @Nullable String string) {
        long l = phoneAuthOptions.zzg();
        if (l < 0L || l > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        String string2 = Preconditions.checkNotEmpty((String)phoneAuthOptions.zzh());
        boolean bl = phoneAuthOptions.zzd() != null;
        zzadp zzadp2 = new zzadp(string2, l, bl, this.zzj, this.zzl, (String)object, (String)object2, string, this.zzS());
        object2 = this.zzX(string2, phoneAuthOptions.zze());
        object = TextUtils.isEmpty((CharSequence)object) ? this.zzx(phoneAuthOptions, (PhoneAuthProvider.OnVerificationStateChangedCallbacks)object2) : object2;
        this.zzf.zzQ(this.zzb, zzadp2, (PhoneAuthProvider.OnVerificationStateChangedCallbacks)object, phoneAuthOptions.zza(), phoneAuthOptions.zzi());
    }

    @VisibleForTesting
    final boolean zzS() {
        return zzaao.zza(this.getApp().getApplicationContext());
    }

    private final boolean zzY(String object) {
        return (object = ActionCodeUrl.parseLink((String)object)) != null && !TextUtils.equals((CharSequence)this.zzl, (CharSequence)((ActionCodeUrl)object).zza());
    }

    public static final void zzT(@NonNull FirebaseAuthMissingActivityForRecaptchaException firebaseAuthMissingActivityForRecaptchaException, @NonNull PhoneAuthOptions phoneAuthOptions, @NonNull String object) {
        String string = "Invoking verification failure callback with MissingActivity exception for phone number/uid - ";
        String string2 = String.valueOf(object);
        Log.e((String)"FirebaseAuth", (String)string.concat(string2));
        object = zzabx.zza((String)object, phoneAuthOptions.zze(), null);
        phoneAuthOptions.zzi().execute(new zzi((PhoneAuthProvider.OnVerificationStateChangedCallbacks)object, firebaseAuthMissingActivityForRecaptchaException));
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

