/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase-auth-api.zzaal;
import com.google.android.gms.internal.firebase-auth-api.zzaam;
import com.google.android.gms.internal.firebase-auth-api.zzaan;
import com.google.android.gms.internal.firebase-auth-api.zzach;
import com.google.android.gms.internal.firebase-auth-api.zzaec;
import com.google.android.gms.internal.firebase-auth-api.zzf;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.zzak;
import com.google.firebase.auth.internal.zzba;
import com.google.firebase.auth.internal.zzbz;
import com.google.firebase.auth.internal.zzca;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzl;
import com.google.firebase.auth.internal.zzm;
import com.google.firebase.inject.Provider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

@KeepName
public class GenericIdpActivity
extends FragmentActivity
implements zzaan {
    private static long zzb = 0L;
    private static final zzca zzc = zzca.zzc();
    @SuppressLint(value={"ThreadPoolCreation"})
    private final Executor zzd = zzf.zza().zza(1);
    private boolean zze = false;

    protected final void onCreate(@NonNull Bundle object) {
        super.onCreate(object);
        String string = this.getIntent().getAction();
        if ("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN".equals(string) || "com.google.firebase.auth.internal.NONGMSCORE_LINK".equals(string) || "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE".equals(string) || "android.intent.action.VIEW".equals(string)) {
            long l = DefaultClock.getInstance().currentTimeMillis();
            if (l - zzb < 30000L) {
                Log.e((String)"GenericIdpActivity", (String)"Could not start operation - already in progress");
                return;
            }
            zzb = l;
            if (object != null) {
                this.zze = object.getBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN");
                return;
            }
            return;
        }
        object = String.valueOf(string);
        string = "Could not do operation - unknown action: ";
        Log.e((String)"GenericIdpActivity", (String)string.concat((String)object));
        this.zzh();
    }

    public final void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void onResume() {
        block12: {
            String string;
            super.onResume();
            String string2 = this.getIntent().getAction();
            if ("android.intent.action.VIEW".equals(string2)) {
                string2 = this.getIntent();
                if (string2.hasExtra("firebaseError")) {
                    this.zzi(zzbz.zzb(string2.getStringExtra("firebaseError")));
                    return;
                }
                if (string2.hasExtra("link") && string2.hasExtra("eventId")) {
                    Object object = string2.getStringExtra("link");
                    Object object2 = string2.getStringExtra("eventId");
                    String string3 = this.getPackageName();
                    boolean bl = string2.getBooleanExtra("encryptionEnabled", true);
                    object2 = zzl.zzb().zza((Context)this, string3, (String)object2);
                    if (object2 == null) {
                        this.zzh();
                    }
                    Object object3 = bl ? zzm.zza(this.getApplicationContext(), FirebaseApp.getInstance((String)((zzk)object2).zza()).getPersistenceKey()).zzb((String)object) : object;
                    object = new zzaec((zzk)object2, (String)object3);
                    object3 = ((zzk)object2).zze();
                    object2 = ((zzk)object2).zzb();
                    ((zzaec)object).zzf((String)object3);
                    if (!("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN".equals(object2) || "com.google.firebase.auth.internal.NONGMSCORE_LINK".equals(object2) || "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE".equals(object2))) {
                        object3 = "unsupported operation: ".concat((String)object2);
                        Log.e((String)"GenericIdpActivity", (String)object3);
                        this.zzh();
                        return;
                    }
                    zzb = 0L;
                    this.zze = false;
                    string3 = new Intent();
                    SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)object, (Intent)string3, (String)"com.google.firebase.auth.internal.VERIFY_ASSERTION_REQUEST");
                    string3.putExtra("com.google.firebase.auth.internal.OPERATION", (String)object2);
                    string3.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                    if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast((Intent)string3)) {
                        SharedPreferences.Editor editor = this.getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
                        object = SafeParcelableSerializer.serializeToString((SafeParcelable)object);
                        editor.putString("verifyAssertionRequest", (String)object);
                        editor.putString("operation", (String)object2);
                        editor.putString("tenantId", (String)object3);
                        long l = DefaultClock.getInstance().currentTimeMillis();
                        editor.putLong("timestamp", l);
                        editor.commit();
                    } else {
                        zzc.zzd((Context)this);
                    }
                    this.finish();
                    return;
                }
                this.zzh();
                return;
            }
            if (this.zze) {
                this.zzh();
                return;
            }
            string2 = this.getPackageName();
            try {
                string = Hex.bytesToStringUppercase((byte[])AndroidUtilsLight.getPackageCertificateHashBytes((Context)this, (String)string2)).toLowerCase(Locale.US);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string4 = ((Object)((Object)nameNotFoundException)).toString();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not get package signature: ");
                stringBuilder.append(string2);
                stringBuilder.append(" ");
                stringBuilder.append(string4);
                String string5 = stringBuilder.toString();
                Log.e((String)"GenericIdpActivity", (String)string5);
                this.zze(string2, null);
                break block12;
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)this.getIntent().getStringExtra("com.google.firebase.auth.KEY_FIREBASE_APP_NAME"));
            if (!zzach.zzg(firebaseApp)) {
                new zzaal(string2, string, this.getIntent(), firebaseApp, this).executeOnExecutor(this.zzd, new Void[0]);
            } else {
                GenericIdpActivity genericIdpActivity = this;
                genericIdpActivity.zzf(genericIdpActivity.zzg(Uri.parse((String)zzach.zza(firebaseApp.getOptions().getApiKey())).buildUpon(), genericIdpActivity.getIntent(), string2, string).build(), string2, FirebaseAuth.getInstance(firebaseApp).zzD());
            }
        }
        this.zze = true;
    }

    protected final void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN", this.zze);
    }

    @Override
    @NonNull
    public final Context zza() {
        return this.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Uri.Builder zzg(@NonNull Uri.Builder builder, @NonNull Intent object, @NonNull String string, @NonNull String string2) {
        void var6_12;
        Object object2;
        Object object3 = object;
        Object object4 = object;
        String string3 = object4.getStringExtra("com.google.firebase.auth.KEY_API_KEY");
        String string4 = object4.getStringExtra("com.google.firebase.auth.KEY_PROVIDER_ID");
        String string5 = object4.getStringExtra("com.google.firebase.auth.KEY_TENANT_ID");
        String string6 = object3.getStringExtra("com.google.firebase.auth.KEY_FIREBASE_APP_NAME");
        Object object5 = object3.getStringArrayListExtra("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
        object5 = object5 != null ? (!((ArrayList)object5).isEmpty() ? TextUtils.join((CharSequence)",", (Iterable)object5) : null) : null;
        Bundle bundle = object.getBundleExtra("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS");
        if (bundle == null) {
            Object var6_11 = null;
        } else {
            JSONObject jSONObject = new JSONObject();
            try {
                boolean bl;
                object2 = bundle.keySet().iterator();
                while (bl = object2.hasNext()) {
                    String string7 = (String)object2.next();
                    String string8 = bundle.getString(string7);
                    boolean bl2 = TextUtils.isEmpty((CharSequence)string8);
                    if (bl2) continue;
                    jSONObject.put(string7, (Object)string8);
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)"GenericIdpActivity", (String)"Unexpected JSON exception when serializing developer specified custom params");
            }
            String string9 = jSONObject.toString();
        }
        String string10 = UUID.randomUUID().toString();
        object2 = zzaam.zza((zzaan)((Object)string12), UUID.randomUUID().toString());
        String string11 = object.getAction();
        object = object.getStringExtra("com.google.firebase.auth.internal.CLIENT_VERSION");
        zzl.zzb().zzd(string12.getApplicationContext(), string, string10, (String)object2, string11, string4, string5, string6);
        string6 = FirebaseApp.getInstance((String)string6);
        string6 = zzm.zza(string12.getApplicationContext(), string6.getPersistenceKey()).zzc();
        if (TextUtils.isEmpty((CharSequence)string6)) {
            Log.e((String)"GenericIdpActivity", (String)"Could not generate an encryption key for Generic IDP - cancelling flow.");
            ((GenericIdpActivity)((Object)string12)).zzi(zzak.zza("Failed to generate/retrieve public encryption key for Generic IDP flow."));
            return null;
        }
        if (object2 == null) {
            return null;
        }
        String string12 = String.valueOf(object);
        object = "X";
        builder.appendQueryParameter("eid", "p").appendQueryParameter("v", ((String)object).concat(string12)).appendQueryParameter("authType", "signInWithRedirect").appendQueryParameter("apiKey", string3).appendQueryParameter("providerId", string4).appendQueryParameter("sessionId", (String)object2).appendQueryParameter("eventId", string10).appendQueryParameter("apn", string).appendQueryParameter("sha1Cert", string2).appendQueryParameter("publicKey", string6);
        if (!TextUtils.isEmpty((CharSequence)object5)) {
            builder.appendQueryParameter("scopes", (String)object5);
        }
        if (!TextUtils.isEmpty((CharSequence)var6_12)) {
            builder.appendQueryParameter("customParameters", (String)var6_12);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            builder.appendQueryParameter("tid", string5);
        }
        return builder;
    }

    @Override
    @Nullable
    public final Uri.Builder zzb(@NonNull Intent intent, @NonNull String string, @NonNull String string2) {
        return this.zzg(new Uri.Builder().scheme("https").appendPath("__").appendPath("auth").appendPath("handler"), intent, string, string2);
    }

    @Override
    @NonNull
    public final String zzc(@NonNull String string) {
        return zzach.zzb(string);
    }

    @Override
    @Nullable
    public final HttpURLConnection zzd(@NonNull URL uRL) {
        try {
            Object object = uRL.openConnection();
            object = (HttpURLConnection)object;
            return object;
        }
        catch (IOException iOException) {
            Log.e((String)"GenericIdpActivity", (String)"Error generating URL connection");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        zzb = 0L;
        this.zze = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent)) {
            String string = "WEB_CONTEXT_CANCELED";
            zzc.zzf((Context)this, zzak.zza(string));
        } else {
            zzc.zzd((Context)this);
        }
        this.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzi(Status status) {
        zzb = 0L;
        this.zze = false;
        Intent intent = new Intent();
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)status, (Intent)intent, (String)"com.google.firebase.auth.internal.STATUS");
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent)) {
            zzc.zzf(this.getApplicationContext(), status);
        } else {
            zzc.zzd((Context)this);
        }
        this.finish();
    }

    @Override
    public final void zze(@NonNull String string, @Nullable Status status) {
        if (status == null) {
            this.zzh();
            return;
        }
        this.zzi(status);
    }

    @Override
    public final void zzf(@NonNull Uri uri, @NonNull String string, @NonNull Provider provider) {
        Tasks.forResult((Object)uri).addOnCompleteListener((OnCompleteListener)new zzba(this, string));
    }
}

