/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase-auth-api.zzaal;
import com.google.android.gms.internal.firebase-auth-api.zzaan;
import com.google.android.gms.internal.firebase-auth-api.zzaay;
import com.google.android.gms.internal.firebase-auth-api.zzach;
import com.google.android.gms.internal.firebase-auth-api.zzf;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.zzak;
import com.google.firebase.auth.internal.zzbh;
import com.google.firebase.auth.internal.zzbz;
import com.google.firebase.auth.internal.zzca;
import com.google.firebase.auth.internal.zzl;
import com.google.firebase.auth.internal.zzm;
import com.google.firebase.inject.Provider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutorService;

public class RecaptchaActivity
extends FragmentActivity
implements zzaan {
    private static final String zzb = RecaptchaActivity.class.getSimpleName();
    @SuppressLint(value={"ThreadPoolCreation"})
    private static final ExecutorService zzc = com.google.android.gms.internal.firebase-auth-api.zzf.zza().zza(2);
    private static long zzd = 0L;
    private static final zzca zze = zzca.zzc();
    private boolean zzf = false;

    protected final void onCreate(@NonNull Bundle object) {
        super.onCreate(object);
        String string = this.getIntent().getAction();
        if ("com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA".equals(string) || "android.intent.action.VIEW".equals(string)) {
            long l = DefaultClock.getInstance().currentTimeMillis();
            if (l - zzd < 30000L) {
                Log.e((String)zzb, (String)"Could not start operation - already in progress");
                return;
            }
            zzd = l;
            if (object != null) {
                this.zzf = object.getBoolean("com.google.firebase.auth.internal.KEY_ALREADY_STARTED_RECAPTCHA_FLOW");
                return;
            }
            return;
        }
        object = String.valueOf(string);
        string = "Could not do operation - unknown action: ";
        Log.e((String)zzb, (String)string.concat((String)object));
        this.zzh();
    }

    public final void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void onResume() {
        block9: {
            String string;
            super.onResume();
            String string2 = this.getIntent().getAction();
            if ("android.intent.action.VIEW".equals(string2)) {
                string2 = this.getIntent();
                if (string2.hasExtra("firebaseError")) {
                    this.zzi(zzbz.zzb(string2.getStringExtra("firebaseError")));
                    return;
                }
                if (string2.hasExtra("link") && string2.hasExtra("eventId")) {
                    String string3 = string2.getStringExtra("link");
                    String string4 = zzl.zzb().zzc(this.getApplicationContext(), this.getPackageName(), string2.getStringExtra("eventId"));
                    if (TextUtils.isEmpty((CharSequence)string4)) {
                        Log.e((String)zzb, (String)"Failed to find registration for this event - failing to prevent session injection.");
                        this.zzi(zzak.zza("Failed to find registration for this reCAPTCHA event"));
                    }
                    string2 = string2.getBooleanExtra("encryptionEnabled", true) ? zzm.zza(this.getApplicationContext(), FirebaseApp.getInstance((String)string4).getPersistenceKey()).zzb(string3) : string3;
                    string2 = Uri.parse((String)string2).getQueryParameter("recaptchaToken");
                    zzd = 0L;
                    this.zzf = false;
                    string3 = new Intent();
                    string3.putExtra("com.google.firebase.auth.internal.RECAPTCHA_TOKEN", string2);
                    string3.putExtra("com.google.firebase.auth.internal.OPERATION", "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA");
                    string3.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                    if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast((Intent)string3)) {
                        SharedPreferences.Editor editor = this.getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
                        editor.putString("recaptchaToken", string2);
                        editor.putString("operation", "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA");
                        long l = DefaultClock.getInstance().currentTimeMillis();
                        editor.putLong("timestamp", l);
                        editor.commit();
                    } else {
                        zze.zzd((Context)this);
                    }
                    this.finish();
                    return;
                }
                this.zzh();
                return;
            }
            if (this.zzf) {
                this.zzh();
                return;
            }
            string2 = this.getIntent();
            String string5 = this.getPackageName();
            try {
                string = Hex.bytesToStringUppercase((byte[])AndroidUtilsLight.getPackageCertificateHashBytes((Context)this, (String)string5)).toLowerCase(Locale.US);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string6 = ((Object)((Object)nameNotFoundException)).toString();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not get package signature: ");
                stringBuilder.append(string5);
                stringBuilder.append(" ");
                stringBuilder.append(string6);
                Log.e((String)zzb, (String)stringBuilder.toString());
                this.zze(string5, null);
                break block9;
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2.getStringExtra("com.google.firebase.auth.internal.FIREBASE_APP_NAME"));
            new zzaal(string5, string, (Intent)string2, firebaseApp, this).executeOnExecutor(zzc, new Void[0]);
        }
        this.zzf = true;
    }

    protected final void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_ALREADY_STARTED_RECAPTCHA_FLOW", this.zzf);
    }

    @Override
    @NonNull
    public final Context zza() {
        return this.getApplicationContext();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public final Uri.Builder zzb(@NonNull Intent object, @NonNull String string, @NonNull String string2) {
        String string3 = object.getStringExtra("com.google.firebase.auth.KEY_API_KEY");
        String string4 = UUID.randomUUID().toString();
        Object object2 = object;
        object = object2.getStringExtra("com.google.firebase.auth.internal.CLIENT_VERSION");
        String string5 = object2.getStringExtra("com.google.firebase.auth.internal.FIREBASE_APP_NAME");
        FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string5);
        FirebaseAuth firebaseAuth = FirebaseAuth.getInstance(firebaseApp);
        String string6 = "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA";
        zzl.zzb().zze(object3.getApplicationContext(), string, string4, string6, string5);
        String string7 = zzm.zza(object3.getApplicationContext(), firebaseApp.getPersistenceKey()).zzc();
        if (TextUtils.isEmpty((CharSequence)string7)) {
            Log.e((String)zzb, (String)"Could not generate an encryption key for reCAPTCHA - cancelling flow.");
            ((RecaptchaActivity)object3).zzi(zzak.zza("Failed to generate/retrieve public encryption key for reCAPTCHA flow."));
            return null;
        }
        Object object3 = !TextUtils.isEmpty((CharSequence)firebaseAuth.getLanguageCode()) ? firebaseAuth.getLanguageCode() : zzaay.zza();
        Uri.Builder builder = new Uri.Builder().scheme("https").appendPath("__").appendPath("auth").appendPath("handler").appendQueryParameter("apiKey", string3).appendQueryParameter("authType", "verifyApp").appendQueryParameter("apn", string).appendQueryParameter("hl", (String)object3).appendQueryParameter("eventId", string4);
        object3 = String.valueOf(object);
        object = "X";
        return builder.appendQueryParameter("v", ((String)object).concat((String)object3)).appendQueryParameter("eid", "p").appendQueryParameter("appName", string5).appendQueryParameter("sha1Cert", string2).appendQueryParameter("publicKey", string7);
    }

    @Override
    @NonNull
    public final String zzc(@NonNull String string) {
        return zzach.zzb(string);
    }

    @Override
    @Nullable
    public final HttpURLConnection zzd(@NonNull URL uRL) {
        try {
            Object object = uRL.openConnection();
            object = (HttpURLConnection)object;
            return object;
        }
        catch (IOException iOException) {
            zza.e("Error generating connection", new Object[0]);
            return null;
        }
    }

    private final void zzh() {
        zzd = 0L;
        this.zzf = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
        zze.zzd((Context)this);
        this.finish();
    }

    private final void zzi(Status status) {
        zzd = 0L;
        this.zzf = false;
        Intent intent = new Intent();
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)status, (Intent)intent, (String)"com.google.firebase.auth.internal.STATUS");
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
        zze.zzd((Context)this);
        this.finish();
    }

    @Override
    public final void zze(@NonNull String string, @Nullable Status status) {
        if (status == null) {
            this.zzh();
            return;
        }
        this.zzi(status);
    }

    @Override
    public final void zzf(@NonNull Uri uri, @NonNull String string, @NonNull Provider provider) {
        Tasks.forResult((Object)uri).addOnCompleteListener((OnCompleteListener)new zzbh(this, string));
    }

    final /* synthetic */ void zzg(String string, Task task) {
        Object object = new Intent("android.intent.action.VIEW");
        if (this.getPackageManager().resolveActivity((Intent)object, 0) != null) {
            object = this.getPackageManager().queryIntentServices(new Intent("android.support.customtabs.action.CustomTabsService"), 0);
            if (object != null && !object.isEmpty()) {
                CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
                customTabsIntent.intent.addFlags(0x40000000);
                customTabsIntent.intent.addFlags(0x10000000);
                customTabsIntent.launchUrl((Context)this, (Uri)task.getResult());
                return;
            }
            task = (Uri)task.getResult();
            Intent intent = new Intent("android.intent.action.VIEW", (Uri)task);
            intent.putExtra("com.android.browser.application_id", string);
            intent.addFlags(0x40000000);
            intent.addFlags(0x10000000);
            this.startActivity(intent);
            return;
        }
        Log.e((String)zzb, (String)"Device cannot resolve intent for: android.intent.action.VIEW");
        this.zze(string, null);
    }
}

