/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-auth-api.zzaf;
import com.google.android.gms.internal.firebase-auth-api.zzn;
import com.google.android.gms.internal.firebase-auth-api.zzvi;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class zzbc {
    private static final Logger zza = new Logger("JSONParser", new String[0]);

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static List zza(JSONArray jSONArray) throws JSONException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < jSONArray.length()) {
            Object object = jSONArray.get(n);
            if (object instanceof JSONArray) {
                object = zzbc.zza((JSONArray)object);
            } else if (object instanceof JSONObject) {
                object = zzbc.zzd((JSONObject)object);
            }
            arrayList.add(object);
            ++n;
        }
        return arrayList;
    }

    @NonNull
    public static Map zzb(String hashMap) {
        block4: {
            Preconditions.checkNotEmpty((String)((Object)hashMap));
            Object[] objectArray = zzaf.zzb(zzn.zzb('.')).zzd((CharSequence)((Object)hashMap));
            if (objectArray.size() < 2) {
                hashMap = String.valueOf(hashMap);
                objectArray = new Object[]{};
                zza.e("Invalid idToken ".concat((String)((Object)hashMap)), objectArray);
                return new HashMap();
            }
            hashMap = (String)objectArray.get(1);
            try {
                hashMap = zzbc.zzc(new String(Base64Utils.decodeUrlSafeNoPadding((String)((Object)hashMap)), "UTF-8"));
                if (hashMap != null) break block4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                objectArray = new Object[]{};
                zza.e("Unable to decode token", (Throwable)unsupportedEncodingException, objectArray);
                return new HashMap();
            }
            hashMap = new HashMap();
        }
        return hashMap;
    }

    @Nullable
    public static Map zzc(String object) {
        block4: {
            JSONObject jSONObject;
            if (TextUtils.isEmpty((CharSequence)object)) {
                return null;
            }
            try {
                jSONObject = new JSONObject((String)object);
                object = JSONObject.NULL;
                if (jSONObject == object) break block4;
            }
            catch (Exception exception) {
                Log.d((String)"JSONParser", (String)"Failed to parse JSONObject into Map.");
                throw new zzvi(exception);
            }
            object = zzbc.zzd(jSONObject);
            return object;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static Map zzd(JSONObject jSONObject) throws JSONException {
        ArrayMap arrayMap = new ArrayMap();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = jSONObject.get(string);
            if (object instanceof JSONArray) {
                object = zzbc.zza((JSONArray)object);
            } else if (object instanceof JSONObject) {
                object = zzbc.zzd((JSONObject)object);
            }
            arrayMap.put(string, object);
        }
        return arrayMap;
    }
}

