/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.util.Log;
import com.google.android.gms.internal.firebase-auth-api.zzbb;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.ProviderException;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public final class zzjq
implements zzbb {
    private static final String zza = zzjq.class.getSimpleName();
    private final SecretKey zzb;

    zzjq(String string, KeyStore keyStore) throws GeneralSecurityException {
        ((zzjq)((Object)string2)).zzb = (SecretKey)keyStore.getKey(string, null);
        if (((zzjq)((Object)string2)).zzb == null) {
            String string2 = String.valueOf(string);
            string = "Keystore cannot load the key with ID: ";
            throw new InvalidKeyException(string.concat(string2));
        }
    }

    private static void zzc() {
        double d = Math.random() * 100.0;
        try {
            Thread.sleep((int)d);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray.length < 28) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        try {
            Object object = ((zzjq)object).zzd(byArray, byArray2);
            return object;
        }
        catch (AEADBadTagException aEADBadTagException) {
            throw aEADBadTagException;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zza, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)exception);
            zzjq.zzc();
            return super.zzd(byArray, byArray2);
        }
    }

    private final byte[] zzd(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray, 0, 12);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)this.zzb, gCMParameterSpec);
        cipher.updateAAD(byArray2);
        return cipher.doFinal(byArray, 12, byArray.length + -12);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        try {
            Object object = ((zzjq)object).zze(byArray, byArray2);
            return object;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zza, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)exception);
            zzjq.zzc();
            return super.zze(byArray, byArray2);
        }
    }

    private final byte[] zze(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        if (n > 2147483619) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] byArray3 = new byte[n + 28];
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, this.zzb);
        cipher.updateAAD(byArray2);
        cipher.doFinal(byArray, 0, n, byArray3, 12);
        System.arraycopy(cipher.getIV(), 0, byArray3, 0, 12);
        return byArray3;
    }
}

