/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.zzg;

@SafeParcelable.Class(creator="EmailAuthCredentialCreator")
public class EmailAuthCredential
extends AuthCredential {
    @NonNull
    public static final Parcelable.Creator<EmailAuthCredential> CREATOR = new zzg();
    @SafeParcelable.Field(id=1, getter="getEmail")
    private final String zza;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getPassword")
    private String zzb;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getSignInLink")
    private final String zzc;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getCachedState")
    private String zzd;
    @SafeParcelable.Field(id=5, getter="isForLinking")
    private boolean zze;

    @Override
    @NonNull
    public String getProvider() {
        return "password";
    }

    @Override
    @NonNull
    public String getSignInMethod() {
        if (!TextUtils.isEmpty((CharSequence)this.zzb)) {
            return "password";
        }
        return "emailLink";
    }

    @SafeParcelable.Constructor
    EmailAuthCredential(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=5) boolean bl) {
        this.zza = Preconditions.checkNotEmpty((String)string);
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Cannot create an EmailAuthCredential without a password or emailLink.");
        }
        this.zzb = string2;
        this.zzc = string3;
        this.zzd = string4;
        this.zze = bl;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzd, (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)this.zze);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    @NonNull
    public final AuthCredential zza() {
        return new EmailAuthCredential(this.zza, this.zzb, this.zzc, this.zzd, this.zze);
    }

    @NonNull
    public final EmailAuthCredential zzb(@NonNull FirebaseUser firebaseUser) {
        this.zzd = firebaseUser.zzf();
        this.zze = true;
        return this;
    }

    @Nullable
    public final String zzc() {
        return this.zzd;
    }

    @NonNull
    public final String zzd() {
        return this.zza;
    }

    @Nullable
    public final String zze() {
        return this.zzb;
    }

    @Nullable
    public final String zzf() {
        return this.zzc;
    }

    public final boolean zzg() {
        return !TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final boolean zzh() {
        return this.zze;
    }

    public static boolean zzi(@NonNull String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        return (object = ActionCodeUrl.parseLink((String)object)) != null && ((ActionCodeUrl)object).getOperation() == 4;
    }
}

