/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzacn;
import com.google.android.gms.internal.zzacq;
import com.google.android.gms.internal.zzacs;
import com.google.android.gms.internal.zzacv;
import com.google.android.gms.internal.zzadc;
import com.google.android.gms.internal.zzade;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzadh;
import com.google.android.gms.internal.zzadk;
import com.google.android.gms.internal.zzadl;
import com.google.android.gms.internal.zzadm;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetTokenResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements zzaja {
    private FirebaseApp zzbEZ;
    private List<AuthStateListener> mListeners;
    private zzacn zzbFa;
    private FirebaseUser zzbFb;
    private zzadl zzbFc;
    private zzajz zzbFd;
    private zzadm zzbFe;
    private static Map<String, FirebaseAuth> zzaTZ = new ArrayMap();
    private static FirebaseAuth zzbFf;

    public static FirebaseAuth getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        return FirebaseAuth.zzb(firebaseApp);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseAuth.zza(firebaseApp), new zzadl(firebaseApp.getApplicationContext(), firebaseApp.zzNV(), zzacs.zzOt()));
    }

    FirebaseAuth(FirebaseApp firebaseApp, zzacn zzacn2, zzadl zzadl2) {
        this.zzbEZ = (FirebaseApp)zzaa.zzz((Object)firebaseApp);
        this.zzbFa = (zzacn)((Object)zzaa.zzz((Object)((Object)zzacn2)));
        this.zzbFc = (zzadl)zzaa.zzz((Object)zzadl2);
        this.mListeners = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzbFd = zzacs.zzOt();
        this.zzbFe = zzadm.zzOV();
        this.zzOj();
    }

    static zzacn zza(FirebaseApp firebaseApp) {
        zzacv.zza zza2 = new zzacv.zza.zza(firebaseApp.getOptions().getApiKey()).zzOw();
        return zzacv.zza(firebaseApp.getApplicationContext(), zza2);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzbFb;
    }

    public void zza(@NonNull FirebaseUser firebaseUser, boolean bl, boolean bl2) {
        zzaa.zzz((Object)firebaseUser);
        if (this.zzbFb == null) {
            this.zzbFb = firebaseUser;
        } else {
            this.zzbFb.zzaK(firebaseUser.isAnonymous());
            this.zzbFb.zzN(firebaseUser.getProviderData());
        }
        if (bl) {
            this.zzbFc.zze(this.zzbFb);
        }
        if (bl2) {
            this.zza(this.zzbFb);
        }
    }

    public void zza(@NonNull FirebaseUser firebaseUser, @NonNull GetTokenResponse getTokenResponse, boolean bl) {
        boolean bl2;
        zzaa.zzz((Object)firebaseUser);
        zzaa.zzz((Object)getTokenResponse);
        if (this.zzbFb == null) {
            bl2 = true;
        } else {
            GetTokenResponse getTokenResponse2 = (GetTokenResponse)this.zzbFd.zzf(this.zzbFb.zzOm(), GetTokenResponse.class);
            String string = getTokenResponse2.getAccessToken();
            String string2 = getTokenResponse.getAccessToken();
            boolean bl3 = bl2 = this.zzbFb.getUid().equalsIgnoreCase(firebaseUser.getUid()) && string != null && !string.equals(string2);
        }
        if (bl2) {
            if (this.zzbFb != null) {
                this.zzbFb.zzhG(this.zzbFd.zzaH((Object)getTokenResponse));
            }
            this.zza(this.zzbFb);
        }
        if (bl) {
            this.zzbFc.zza(firebaseUser, getTokenResponse);
        }
    }

    public void zzOi() {
        if (this.zzbFb != null) {
            this.zzbFc.zzg(this.zzbFb);
            this.zzbFb = null;
        }
        this.zzbFc.zzOU();
        this.zza(null);
    }

    private static FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzc(firebaseApp);
    }

    private static synchronized FirebaseAuth zzc(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzaTZ.get(firebaseApp.zzNV());
        if (firebaseAuth == null) {
            firebaseAuth = new zzadg(firebaseApp);
            firebaseApp.zza((zzaja)firebaseAuth);
            if (zzbFf == null) {
                zzbFf = firebaseAuth;
            }
            zzaTZ.put(firebaseApp.zzNV(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addAuthStateListener(final @NonNull AuthStateListener authStateListener) {
        this.mListeners.add(authStateListener);
        this.zzbFe.execute(new Runnable(){

            @Override
            public void run() {
                authStateListener.onAuthStateChanged(FirebaseAuth.this);
            }
        });
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.mListeners.remove(authStateListener);
    }

    public void zza(final @Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(36 + String.valueOf(string).length()).append("Notifying listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying listeners about a sign-out event.");
        }
        this.zzbFe.execute(new Runnable(){

            @Override
            public void run() {
                FirebaseAuth.this.zzbEZ.zza((zzaja)FirebaseAuth.this, firebaseUser);
                for (AuthStateListener authStateListener : FirebaseAuth.this.mListeners) {
                    authStateListener.onAuthStateChanged(FirebaseAuth.this);
                }
            }
        });
    }

    @NonNull
    public Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzacq.zzbN(new Status(17495)));
        }
        GetTokenResponse getTokenResponse = (GetTokenResponse)this.zzbFd.zzf(this.zzbFb.zzOm(), GetTokenResponse.class);
        if (getTokenResponse.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(getTokenResponse.getAccessToken()));
        }
        return this.zzbFa.zza(this.zzbEZ, firebaseUser, getTokenResponse.zzOG(), new zzadc(){

            public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
                FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            }
        });
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzaa.zzz((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbFa.zzb(this.zzbEZ, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzadc)new zza());
        }
        return this.zzbFa.zza(this.zzbEZ, authCredential, (zzadc)new zza());
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzaa.zzz((Object)firebaseUser);
        zzaa.zzz((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbFa.zza(this.zzbEZ, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
        }
        return this.zzbFa.zza(this.zzbEZ, firebaseUser, authCredential, (zzadc)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzaa.zzdl((String)string);
        return this.zzbFa.zza(this.zzbEZ, string, (zzadc)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzaa.zzdl((String)string);
        zzaa.zzdl((String)string2);
        return this.zzbFa.zzb(this.zzbEZ, string, string2, (zzadc)new zza());
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzbFb != null && this.zzbFb.isAnonymous()) {
            zzadh zzadh2 = (zzadh)this.zzbFb;
            zzade zzade2 = new zzade(zzadh2);
            return Tasks.forResult((Object)zzade2);
        }
        return this.zzbFa.zza(this.zzbEZ, new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzaa.zzz((Object)firebaseUser);
        return this.zzbFa.zzb(this.zzbEZ, firebaseUser, new zza());
    }

    @NonNull
    public Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzaa.zzz((Object)authCredential);
        zzaa.zzz((Object)firebaseUser);
        return this.zzbFa.zzb(this.zzbEZ, firebaseUser, authCredential, (zzadc)new zza());
    }

    @NonNull
    public Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzaa.zzdl((String)string);
        zzaa.zzz((Object)firebaseUser);
        return this.zzbFa.zzd(this.zzbEZ, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzaa.zzdl((String)string);
        zzaa.zzdl((String)string2);
        return this.zzbFa.zza(this.zzbEZ, string, string2, (zzadc)new zza());
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzaa.zzdl((String)string);
        return this.zzbFa.zza(this.zzbEZ, string);
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzaa.zzz((Object)firebaseUser);
        zzaa.zzz((Object)userProfileChangeRequest);
        return this.zzbFa.zza(this.zzbEZ, firebaseUser, userProfileChangeRequest, (zzadc)new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzaa.zzz((Object)firebaseUser);
        zzaa.zzdl((String)string);
        return this.zzbFa.zzb(this.zzbEZ, firebaseUser, string, (zzadc)new zza());
    }

    @NonNull
    public Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzaa.zzz((Object)firebaseUser);
        zzaa.zzdl((String)string);
        return this.zzbFa.zzc(this.zzbEZ, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzaa.zzdl((String)string);
        return this.zzbFa.zzb(this.zzbEZ, string);
    }

    @NonNull
    public Task<Void> zzc(final @NonNull FirebaseUser firebaseUser) {
        zzaa.zzz((Object)firebaseUser);
        return this.zzbFa.zza(firebaseUser, new zzadk(){

            public void zzOk() {
                if (FirebaseAuth.this.zzbFb.getUid().equalsIgnoreCase(firebaseUser.getUid())) {
                    FirebaseAuth.this.zzOi();
                }
            }
        });
    }

    public void signOut() {
        this.zzOi();
    }

    protected void zzOj() {
        this.zzbFb = this.zzbFc.zzOT();
        if (this.zzbFb != null) {
            this.zza(this.zzbFb, false, true);
            GetTokenResponse getTokenResponse = this.zzbFc.zzf(this.zzbFb);
            if (getTokenResponse != null) {
                this.zza(this.zzbFb, getTokenResponse, false);
            }
        }
    }

    class zza
    implements zzadc {
        zza() {
        }

        public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
            zzaa.zzz((Object)getTokenResponse);
            zzaa.zzz((Object)firebaseUser);
            firebaseUser.zzhG(FirebaseAuth.this.zzbFd.zzaH((Object)getTokenResponse));
            FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            FirebaseAuth.this.zza(firebaseUser, true, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

