/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzafb;
import com.google.android.gms.internal.zzafd;
import com.google.android.gms.internal.zzafg;
import com.google.android.gms.internal.zzafi;
import com.google.android.gms.internal.zzafk;
import com.google.android.gms.internal.zzafl;
import com.google.android.gms.internal.zzafp;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzafs;
import com.google.android.gms.internal.zzafu;
import com.google.android.gms.internal.zzafv;
import com.google.android.gms.internal.zzafw;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetAccountInfoUser;
import com.google.firebase.auth.api.model.ProviderUserInfo;
import com.google.firebase.auth.api.model.VerifyAssertionRequest;
import java.util.ArrayList;
import java.util.List;

public class zzafa
extends com.google.android.gms.common.api.zzc<zzafi.zza> {
    zzafa(@NonNull Context context, @NonNull zzafi.zza zza2) {
        super(context, zzafi.aNs, (Api.ApiOptions)zza2);
    }

    public Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzafp zzafp2) {
        return this.zza(this.zza(new zzd(string).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzn(string).zzd(firebaseApp).zzba(zzafp2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzm(authCredential).zzd(firebaseApp).zzba(zzafp2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzh(authCredential).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzl().zzd(firebaseApp).zzba(zzafp2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzt(userProfileChangeRequest).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzr(string).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzs(string).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zza(string, string2).zzd(firebaseApp).zzba(zzafp2)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzo(string, string2).zzd(firebaseApp).zzba(zzafp2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzi(string, string2).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    public Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zza(this.zza(new zzc(string).zzd(firebaseApp)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(this.zza(new zzk(string).zzd(firebaseApp)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzafp zzafp2) {
        zzab.zzy((Object)firebaseApp);
        zzab.zzy((Object)authCredential);
        zzab.zzy((Object)firebaseUser);
        zzab.zzy((Object)zzafp2);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            return this.zza(firebaseApp, (EmailAuthCredential)authCredential, firebaseUser, zzafp2);
        }
        return this.zza(firebaseApp, authCredential, firebaseUser, zzafp2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zze(emailAuthCredential).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzafp zzafp2) {
        zzab.zzy((Object)firebaseApp);
        zzab.zzy((Object)authCredential);
        zzab.zzy((Object)firebaseUser);
        zzab.zzy((Object)zzafp2);
        List list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzafd.zzes(new Status(17015)));
        }
        return this.zzb(this.zza(new zzf(authCredential).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    public Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzafp zzafp2) {
        zzab.zzy((Object)firebaseApp);
        zzab.zzhr((String)string);
        zzab.zzy((Object)firebaseUser);
        zzab.zzy((Object)zzafp2);
        List list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzafd.zzes(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                return this.zza(firebaseApp, firebaseUser, zzafp2);
            }
        }
        return this.zza(firebaseApp, string, firebaseUser, zzafp2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzp().zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull FirebaseUser firebaseUser, @NonNull zzafp zzafp2) {
        return this.zzb(this.zza(new zzq(string).zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzafp zzafp2) {
        return this.zza(this.zza(new zzj().zzd(firebaseApp).zzd(firebaseUser).zzba(zzafp2)));
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzafx zzafx2) {
        return this.zzb(this.zza(new zzb().zzd(firebaseUser).zzba(zzafx2)));
    }

    @NonNull
    private static zzafu zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser) {
        return zzafa.zza(firebaseApp, getAccountInfoUser, false);
    }

    @NonNull
    private static zzafu zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser, boolean bl) {
        zzab.zzy((Object)firebaseApp);
        zzab.zzy((Object)getAccountInfoUser);
        ArrayList<zzafs> arrayList = new ArrayList<zzafs>();
        zzafs zzafs2 = new zzafs(getAccountInfoUser, "firebase");
        arrayList.add(zzafs2);
        List list = getAccountInfoUser.zzclk();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzafs((ProviderUserInfo)list.get(i)));
            }
        }
        zzafu zzafu2 = new zzafu(firebaseApp, arrayList);
        zzafu cfr_ignored_0 = (zzafu)zzafu2.zzcn(bl);
        if (!TextUtils.isEmpty((CharSequence)getAccountInfoUser.getEmail()) && !TextUtils.isEmpty((CharSequence)getAccountInfoUser.getPassword())) {
            zzafu2.zzrd("password");
        }
        return zzafu2;
    }

    private <ResultT, CallbackT> zzg<ResultT, CallbackT> zza(zzafl<ResultT, CallbackT> zzafl2) {
        return new zzg<ResultT, CallbackT>(zzafl2);
    }

    private class zzg<ResultT, CallbackT>
    extends zzqw<zzafb, ResultT>
    implements zzafk<ResultT> {
        private zzafl<ResultT, CallbackT> aNk;
        private TaskCompletionSource<ResultT> sA;

        public zzg(zzafl<ResultT, CallbackT> zzafl2) {
            this.aNk = zzafl2;
            this.aNk.zza(this);
        }

        protected void zza(zzafb zzafb2, TaskCompletionSource<ResultT> taskCompletionSource) throws RemoteException {
            this.sA = taskCompletionSource;
            this.aNk.zza(zzafb2.zzckz());
        }

        @Override
        public final void zza(ResultT ResultT, Status status) {
            zzab.zzb(this.sA, (Object)"doExecute must be called before onComplete");
            if (status != null) {
                this.sA.setException((Exception)zzafd.zzes(status));
            } else {
                this.sA.setResult(ResultT);
            }
        }
    }

    static final class zzb
    extends zzafl<Void, zzafx> {
        public zzb() {
            super(5);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzg(this.aNv.zzckt(), this.aNu);
        }

        @Override
        public void zzcky() {
            ((zzafx)this.aNx).zzckr();
            this.zzbb(null);
        }
    }

    static final class zzj
    extends zzafl<Void, zzafp> {
        public zzj() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzf(this.aNv.zzckt(), this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA, this.aNv.isAnonymous());
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(null);
        }
    }

    static final class zzq
    extends zzafl<AuthResult, zzafp> {
        @NonNull
        private String aNm;

        public zzq(@NonNull String string) {
            super(2);
            this.aNm = zzab.zzh((String)string, (Object)"provider cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zze(this.aNm, this.aNv.zzckt(), this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zzp
    extends zzafl<AuthResult, zzafp> {
        public zzp() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zze(this.aNv.zzckt(), this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zzf
    extends zzafl<AuthResult, zzafp> {
        @NonNull
        private final VerifyAssertionRequest aNj;

        public zzf(@NonNull AuthCredential authCredential) {
            super(2);
            zzab.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aNj = zzafq.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zza(this.aNv.zzckt(), this.aNj, (zzafg)this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zze
    extends zzafl<AuthResult, zzafp> {
        @NonNull
        private final EmailAuthCredential aNi;

        public zze(@NonNull EmailAuthCredential emailAuthCredential) {
            super(2);
            this.aNi = (EmailAuthCredential)zzab.zzb((Object)emailAuthCredential, (Object)"credential cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zza(this.aNi.getEmail(), this.aNi.getPassword(), this.aNv.zzckt(), this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zzk
    extends zzafl<Void, zzafp> {
        @NonNull
        private String dB;

        public zzk(@NonNull String string) {
            super(4);
            this.dB = zzab.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzd(this.dB, this.aNu);
        }

        @Override
        public void zzcky() {
            this.zzcle();
        }
    }

    static final class zzc
    extends zzafl<ProviderQueryResult, zzafp> {
        @NonNull
        private final String dB;

        public zzc(@NonNull String string) {
            super(3);
            this.dB = zzab.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzc(this.dB, this.aNu);
        }

        @Override
        public void zzcky() {
            this.zzbb(new zzafv(this.aNB));
        }
    }

    static final class zzi
    extends zzafl<Void, zzafp> {
        @NonNull
        private final String dB;
        @NonNull
        private final String cL;

        public zzi(@NonNull String string, @NonNull String string2) {
            super(2);
            this.dB = zzab.zzh((String)string, (Object)"email cannot be null or empty");
            this.cL = zzab.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzd(this.dB, this.cL, this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            if (this.aNv.getUid().equalsIgnoreCase(zzafu2.getUid())) {
                ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
                this.zzcle();
            } else {
                this.zzet(zzafw.zzclz());
            }
        }
    }

    static final class zzo
    extends zzafl<AuthResult, zzafp> {
        @NonNull
        private String dB;
        @NonNull
        private String cL;

        public zzo(String string, String string2) {
            super(2);
            this.dB = zzab.zzh((String)string, (Object)"email cannot be null or empty");
            this.cL = zzab.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzd(this.dB, this.cL, this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zza
    extends zzafl<AuthResult, zzafp> {
        @NonNull
        private String dB;
        @NonNull
        private String cL;

        public zza(@NonNull String string, @NonNull String string2) {
            super(2);
            this.dB = zzab.zzh((String)string, (Object)"email cannot be null or empty");
            this.cL = zzab.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzc(this.dB, this.cL, this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zzs
    extends zzafl<Void, zzafp> {
        @NonNull
        private final String cL;

        public zzs(@NonNull String string) {
            super(2);
            this.cL = zzab.zzh((String)string, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzb(this.aNv.zzckt(), this.cL, this.aNu);
        }

        @Override
        public void zzcky() {
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafa.zza(this.aMS, this.aNA));
            this.zzcle();
        }
    }

    static final class zzr
    extends zzafl<Void, zzafp> {
        @NonNull
        private final String dB;

        public zzr(String string) {
            super(2);
            this.dB = zzab.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zza(this.aNv.zzckt(), this.dB, (zzafg)this.aNu);
        }

        @Override
        public void zzcky() {
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafa.zza(this.aMS, this.aNA));
            this.zzcle();
        }
    }

    static final class zzt
    extends zzafl<Void, zzafp> {
        @NonNull
        private final UserProfileChangeRequest aNn;

        public zzt(UserProfileChangeRequest userProfileChangeRequest) {
            super(2);
            this.aNn = (UserProfileChangeRequest)zzab.zzb((Object)userProfileChangeRequest, (Object)"request cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zza(this.aNv.zzckt(), this.aNn, (zzafg)this.aNu);
        }

        @Override
        public void zzcky() {
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafa.zza(this.aMS, this.aNA));
            this.zzcle();
        }
    }

    static final class zzl
    extends zzafl<AuthResult, zzafp> {
        public zzl() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zza(this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA, true);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zzh
    extends zzafl<Void, zzafp> {
        @NonNull
        private final VerifyAssertionRequest aNj;

        public zzh(@NonNull AuthCredential authCredential) {
            super(2);
            zzab.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aNj = zzafq.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zza(this.aNj, (zzafg)this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            if (this.aNv.getUid().equalsIgnoreCase(zzafu2.getUid())) {
                ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
                this.zzcle();
            } else {
                this.zzet(zzafw.zzclz());
            }
        }
    }

    static final class zzm
    extends zzafl<AuthResult, zzafp> {
        @NonNull
        private final VerifyAssertionRequest aNj;

        public zzm(@NonNull AuthCredential authCredential) {
            super(2);
            zzab.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aNj = zzafq.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zza(this.aNj, (zzafg)this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zzn
    extends zzafl<AuthResult, zzafp> {
        @NonNull
        private final String co;

        public zzn(@NonNull String string) {
            super(2);
            this.co = zzab.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zzb(this.co, this.aNu);
        }

        @Override
        public void zzcky() {
            zzafu zzafu2 = zzafa.zza(this.aMS, this.aNA);
            ((zzafp)this.aNx).zza(this.aNz, (FirebaseUser)zzafu2);
            this.zzbb(new zzafr(zzafu2));
        }
    }

    static final class zzd
    extends zzafl<GetTokenResult, zzafp> {
        @NonNull
        private final String aNh;

        public zzd(@NonNull String string) {
            super(1);
            this.aNh = zzab.zzh((String)string, (Object)"refresh token cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNw.zza(this.aNh, (zzafg)this.aNu);
        }

        @Override
        public void zzcky() {
            this.aNz.zzrc(this.aNh);
            ((zzafp)this.aNx).zza(this.aNz, this.aNv);
            this.zzbb(new GetTokenResult(this.aNz.getAccessToken()));
        }
    }
}

