/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzafa;
import com.google.android.gms.internal.zzafd;
import com.google.android.gms.internal.zzaff;
import com.google.android.gms.internal.zzafi;
import com.google.android.gms.internal.zzafp;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzaft;
import com.google.android.gms.internal.zzafu;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzafz;
import com.google.android.gms.internal.zzalq;
import com.google.android.gms.internal.zzamp;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetTokenResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements zzalq {
    private FirebaseApp aMS;
    private List<AuthStateListener> mListeners;
    private zzafa aMT;
    private FirebaseUser aMU;
    private zzafy aMV;
    private zzamp aMW;
    private zzafz aMX;
    private static Map<String, FirebaseAuth> aap = new ArrayMap();
    private static FirebaseAuth aMY;

    public static FirebaseAuth getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        return FirebaseAuth.zzb(firebaseApp);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseAuth.zza(firebaseApp), new zzafy(firebaseApp.getApplicationContext(), firebaseApp.zzckc(), zzaff.zzcla()));
    }

    FirebaseAuth(FirebaseApp firebaseApp, zzafa zzafa2, zzafy zzafy2) {
        this.aMS = (FirebaseApp)zzab.zzy((Object)firebaseApp);
        this.aMT = (zzafa)((Object)zzab.zzy((Object)((Object)zzafa2)));
        this.aMV = (zzafy)zzab.zzy((Object)zzafy2);
        this.mListeners = new CopyOnWriteArrayList<AuthStateListener>();
        this.aMW = zzaff.zzcla();
        this.aMX = zzafz.zzcmc();
        this.zzckq();
    }

    static zzafa zza(FirebaseApp firebaseApp) {
        zzafi.zza zza2 = new zzafi.zza.zza(firebaseApp.getOptions().getApiKey()).zzcld();
        return zzafi.zza(firebaseApp.getApplicationContext(), zza2);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.aMU;
    }

    public void zza(@NonNull FirebaseUser firebaseUser, boolean bl, boolean bl2) {
        zzab.zzy((Object)firebaseUser);
        if (this.aMU == null) {
            this.aMU = firebaseUser;
        } else {
            this.aMU.zzcn(firebaseUser.isAnonymous());
            this.aMU.zzan(firebaseUser.getProviderData());
        }
        if (bl) {
            this.aMV.zze(this.aMU);
        }
        if (bl2) {
            this.zza(this.aMU);
        }
    }

    public void zza(@NonNull FirebaseUser firebaseUser, @NonNull GetTokenResponse getTokenResponse, boolean bl) {
        boolean bl2;
        zzab.zzy((Object)firebaseUser);
        zzab.zzy((Object)getTokenResponse);
        if (this.aMU == null) {
            bl2 = true;
        } else {
            GetTokenResponse getTokenResponse2 = (GetTokenResponse)this.aMW.zzf(this.aMU.zzckt(), GetTokenResponse.class);
            String string = getTokenResponse2.getAccessToken();
            String string2 = getTokenResponse.getAccessToken();
            boolean bl3 = bl2 = this.aMU.getUid().equalsIgnoreCase(firebaseUser.getUid()) && string != null && !string.equals(string2);
        }
        if (bl2) {
            if (this.aMU != null) {
                this.aMU.zzrb(this.aMW.zzch((Object)getTokenResponse));
            }
            this.zza(this.aMU);
        }
        if (bl) {
            this.aMV.zza(firebaseUser, getTokenResponse);
        }
    }

    public void zzckp() {
        if (this.aMU != null) {
            this.aMV.zzg(this.aMU);
            this.aMU = null;
        }
        this.aMV.zzcmb();
        this.zza(null);
    }

    private static FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzc(firebaseApp);
    }

    private static synchronized FirebaseAuth zzc(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = aap.get(firebaseApp.zzckc());
        if (firebaseAuth == null) {
            firebaseAuth = new zzaft(firebaseApp);
            firebaseApp.zza((zzalq)firebaseAuth);
            if (aMY == null) {
                aMY = firebaseAuth;
            }
            aap.put(firebaseApp.zzckc(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addAuthStateListener(final @NonNull AuthStateListener authStateListener) {
        this.mListeners.add(authStateListener);
        this.aMX.execute(new Runnable(){

            @Override
            public void run() {
                authStateListener.onAuthStateChanged(FirebaseAuth.this);
            }
        });
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.mListeners.remove(authStateListener);
    }

    public void zza(final @Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(36 + String.valueOf(string).length()).append("Notifying listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying listeners about a sign-out event.");
        }
        this.aMX.execute(new Runnable(){

            @Override
            public void run() {
                FirebaseAuth.this.aMS.zza((zzalq)FirebaseAuth.this, firebaseUser);
                for (AuthStateListener authStateListener : FirebaseAuth.this.mListeners) {
                    authStateListener.onAuthStateChanged(FirebaseAuth.this);
                }
            }
        });
    }

    @NonNull
    public Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzafd.zzes(new Status(17495)));
        }
        GetTokenResponse getTokenResponse = (GetTokenResponse)this.aMW.zzf(this.aMU.zzckt(), GetTokenResponse.class);
        if (getTokenResponse.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(getTokenResponse.getAccessToken()));
        }
        return this.aMT.zza(this.aMS, firebaseUser, getTokenResponse.zzcln(), new zzafp(){

            public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
                FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            }
        });
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzab.zzy((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.aMT.zzb(this.aMS, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzafp)new zza());
        }
        return this.aMT.zza(this.aMS, authCredential, (zzafp)new zza());
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzab.zzy((Object)firebaseUser);
        zzab.zzy((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.aMT.zza(this.aMS, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
        }
        return this.aMT.zza(this.aMS, firebaseUser, authCredential, (zzafp)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzab.zzhr((String)string);
        return this.aMT.zza(this.aMS, string, (zzafp)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzab.zzhr((String)string);
        zzab.zzhr((String)string2);
        return this.aMT.zzb(this.aMS, string, string2, (zzafp)new zza());
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.aMU != null && this.aMU.isAnonymous()) {
            zzafu zzafu2 = (zzafu)this.aMU;
            zzafr zzafr2 = new zzafr(zzafu2);
            return Tasks.forResult((Object)zzafr2);
        }
        return this.aMT.zza(this.aMS, new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzab.zzy((Object)firebaseUser);
        return this.aMT.zzb(this.aMS, firebaseUser, new zza());
    }

    @NonNull
    public Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzab.zzy((Object)authCredential);
        zzab.zzy((Object)firebaseUser);
        return this.aMT.zzb(this.aMS, firebaseUser, authCredential, (zzafp)new zza());
    }

    @NonNull
    public Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzab.zzhr((String)string);
        zzab.zzy((Object)firebaseUser);
        return this.aMT.zzd(this.aMS, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzab.zzhr((String)string);
        zzab.zzhr((String)string2);
        return this.aMT.zza(this.aMS, string, string2, (zzafp)new zza());
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzab.zzhr((String)string);
        return this.aMT.zza(this.aMS, string);
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzab.zzy((Object)firebaseUser);
        zzab.zzy((Object)userProfileChangeRequest);
        return this.aMT.zza(this.aMS, firebaseUser, userProfileChangeRequest, (zzafp)new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzab.zzy((Object)firebaseUser);
        zzab.zzhr((String)string);
        return this.aMT.zzb(this.aMS, firebaseUser, string, (zzafp)new zza());
    }

    @NonNull
    public Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzab.zzy((Object)firebaseUser);
        zzab.zzhr((String)string);
        return this.aMT.zzc(this.aMS, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzab.zzhr((String)string);
        return this.aMT.zzb(this.aMS, string);
    }

    @NonNull
    public Task<Void> zzc(final @NonNull FirebaseUser firebaseUser) {
        zzab.zzy((Object)firebaseUser);
        return this.aMT.zza(firebaseUser, new zzafx(){

            public void zzckr() {
                if (FirebaseAuth.this.aMU.getUid().equalsIgnoreCase(firebaseUser.getUid())) {
                    FirebaseAuth.this.zzckp();
                }
            }
        });
    }

    public void signOut() {
        this.zzckp();
    }

    protected void zzckq() {
        this.aMU = this.aMV.zzcma();
        if (this.aMU != null) {
            this.zza(this.aMU, false, true);
            GetTokenResponse getTokenResponse = this.aMV.zzf(this.aMU);
            if (getTokenResponse != null) {
                this.zza(this.aMU, getTokenResponse, false);
            }
        }
    }

    class zza
    implements zzafp {
        zza() {
        }

        public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
            zzab.zzy((Object)getTokenResponse);
            zzab.zzy((Object)firebaseUser);
            firebaseUser.zzrb(FirebaseAuth.this.aMW.zzch((Object)getTokenResponse));
            FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            FirebaseAuth.this.zza(firebaseUser, true, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

