/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.util.zzw;

public final class FirebaseOptions {
    private final String zzbWR;
    private final String zzamX;
    private final String zzbWS;
    private final String zzbWT;
    private final String zzbWU;
    private final String zzbWV;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        zzac.zza((!zzw.zzdz((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzamX = string;
        this.zzbWR = string2;
        this.zzbWS = string3;
        this.zzbWT = string4;
        this.zzbWU = string5;
        this.zzbWV = string6;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzam zzam2 = new zzam(context);
        String string = zzam2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzam2.getString("google_api_key"), zzam2.getString("firebase_database_url"), zzam2.getString("ga_trackingId"), zzam2.getString("gcm_defaultSenderId"), zzam2.getString("google_storage_bucket"));
    }

    public String getApiKey() {
        return this.zzbWR;
    }

    public String getApplicationId() {
        return this.zzamX;
    }

    public String getDatabaseUrl() {
        return this.zzbWS;
    }

    public String getGcmSenderId() {
        return this.zzbWU;
    }

    public String getStorageBucket() {
        return this.zzbWV;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzaa.equal((Object)this.zzamX, (Object)firebaseOptions.zzamX) && zzaa.equal((Object)this.zzbWR, (Object)firebaseOptions.zzbWR) && zzaa.equal((Object)this.zzbWS, (Object)firebaseOptions.zzbWS) && zzaa.equal((Object)this.zzbWT, (Object)firebaseOptions.zzbWT) && zzaa.equal((Object)this.zzbWU, (Object)firebaseOptions.zzbWU) && zzaa.equal((Object)this.zzbWV, (Object)firebaseOptions.zzbWV);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzamX, this.zzbWR, this.zzbWS, this.zzbWT, this.zzbWU, this.zzbWV});
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("applicationId", (Object)this.zzamX).zzg("apiKey", (Object)this.zzbWR).zzg("databaseUrl", (Object)this.zzbWS).zzg("gcmSenderId", (Object)this.zzbWU).zzg("storageBucket", (Object)this.zzbWV).toString();
    }

    public static final class Builder {
        private String zzbWR;
        private String zzamX;
        private String zzbWS;
        private String zzbWT;
        private String zzbWU;
        private String zzbWV;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzamX = firebaseOptions.zzamX;
            this.zzbWR = firebaseOptions.zzbWR;
            this.zzbWS = firebaseOptions.zzbWS;
            this.zzbWT = firebaseOptions.zzbWT;
            this.zzbWU = firebaseOptions.zzbWU;
            this.zzbWV = firebaseOptions.zzbWV;
        }

        public Builder setApiKey(@NonNull String string) {
            this.zzbWR = zzac.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public Builder setApplicationId(@NonNull String string) {
            this.zzamX = zzac.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public Builder setDatabaseUrl(@Nullable String string) {
            this.zzbWS = string;
            return this;
        }

        public Builder setGcmSenderId(@Nullable String string) {
            this.zzbWU = string;
            return this;
        }

        public Builder setStorageBucket(@Nullable String string) {
            this.zzbWV = string;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.zzamX, this.zzbWR, this.zzbWS, this.zzbWT, this.zzbWU, this.zzbWV);
        }
    }
}

