/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzr;
import com.google.android.gms.internal.aab;
import com.google.android.gms.internal.aac;
import com.google.android.gms.internal.aad;
import com.google.android.gms.internal.aae;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzbUV = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzbUW = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzbUX = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzbUY = Arrays.asList(new String[0]);
    private static final Set<String> zzbUZ = Collections.emptySet();
    private static final Object zzuF = new Object();
    static final Map<String, FirebaseApp> zzbgQ = new ArrayMap();
    private final Context mApplicationContext;
    private final String mName;
    private final FirebaseOptions zzbVa;
    private final AtomicBoolean zzbVb = new AtomicBoolean(false);
    private final AtomicBoolean zzbVc = new AtomicBoolean();
    private final List<zza> zzbVd = new CopyOnWriteArrayList<zza>();
    private final List<zzc> zzbVe = new CopyOnWriteArrayList<zzc>();
    private final List<Object> zzbVf = new CopyOnWriteArrayList<Object>();
    private aad zzbVg;
    private zzb zzbVh;

    @NonNull
    public Context getApplicationContext() {
        this.zzEp();
        return this.mApplicationContext;
    }

    @NonNull
    public String getName() {
        this.zzEp();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzEp();
        return this.zzbVa;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzbe.zzt((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzbVa).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        aac.zzbL(context);
        Object object = zzuF;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzbgQ.values());
            aac.zzJZ();
            Set<String> set = aac.zzKa();
            set.removeAll(zzbgQ.keySet());
            for (String string : set) {
                aac.zzhq(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zzuF;
        synchronized (object) {
            FirebaseApp firebaseApp = zzbgQ.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = String.valueOf(zzr.zzsf());
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzuF;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzbgQ.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzEs();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zzuF;
        synchronized (object) {
            if (zzbgQ.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        aac.zzbL(context);
        Context context2 = context;
        if (context2.getApplicationContext() instanceof Application) {
            zzbaw.zza((Application)((Application)context2.getApplicationContext()));
            zzbaw.zzpv().zza((zzbax)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = zzuF;
        synchronized (object) {
            zzbo.zza((!zzbgQ.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzbo.zzb((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zzbgQ.put(string2, firebaseApp);
        }
        aac.zze(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzbUV);
        if (firebaseApp.zzEq()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzbUW);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzbUX);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzac(boolean bl) {
        Object object = zzuF;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzbgQ.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzbVb.get()) continue;
                firebaseApp2.zzav(bl);
            }
            return;
        }
    }

    public final void zza(@NonNull aad aad2) {
        this.zzbVg = (aad)zzbo.zzu((Object)aad2);
    }

    public final Task<GetTokenResult> getToken(boolean bl) {
        this.zzEp();
        if (this.zzbVg == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzbVg.zzaw(bl);
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzEp();
        if (this.zzbVb.compareAndSet(!bl, bl)) {
            boolean bl2 = zzbaw.zzpv().zzpw();
            if (bl && bl2) {
                this.zzav(true);
                return;
            }
            if (!bl && bl2) {
                this.zzav(false);
            }
        }
    }

    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.mApplicationContext = (Context)zzbo.zzu((Object)context);
        this.mName = zzbo.zzcF((String)string);
        this.zzbVa = (FirebaseOptions)zzbo.zzu((Object)firebaseOptions);
        this.zzbVh = new aab();
    }

    private final void zzEp() {
        zzbo.zza((!this.zzbVc.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public final boolean zzEq() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public final void zza(@NonNull aae aae2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<zza> iterator = this.zzbVd.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb(aae2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zzav(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<zzc> iterator = this.zzbVe.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzac(bl);
        }
    }

    public final void zza(@NonNull zza zza2) {
        this.zzEp();
        zzbo.zzu((Object)zza2);
        this.zzbVd.add(zza2);
        this.zzbVd.size();
    }

    public final void zza(zzc zzc2) {
        this.zzEp();
        if (this.zzbVb.get() && zzbaw.zzpv().zzpw()) {
            zzc2.zzac(true);
        }
        this.zzbVe.add(zzc2);
    }

    public final String zzEr() {
        String string = String.valueOf(com.google.android.gms.common.util.zzc.zzh((byte[])this.getName().getBytes()));
        String string2 = String.valueOf(com.google.android.gms.common.util.zzc.zzh((byte[])this.getOptions().getApplicationId().getBytes()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzEs() {
        com.google.android.gms.common.util.zza zza2 = new com.google.android.gms.common.util.zza();
        ArrayList<String> arrayList = zzuF;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzbgQ.values()) {
                zza2.add(firebaseApp.getName());
            }
            if (aac.zzJZ() != null) {
                zza2.addAll(aac.zzKa());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)zza2);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzEt() {
        this.zza(FirebaseApp.class, this, zzbUV);
        if (this.zzEq()) {
            this.zza(FirebaseApp.class, this, zzbUW);
            this.zza(Context.class, this.mApplicationContext, zzbUX);
        }
    }

    private final <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.mApplicationContext);
        if (bl) {
            zzd.zzbB(this.mApplicationContext);
        }
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zzbUY.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzbUZ.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @TargetApi(value=24)
    static final class zzd
    extends BroadcastReceiver {
        private static AtomicReference<zzd> zzbVi = new AtomicReference();
        private final Context mApplicationContext;

        private zzd(Context context) {
            this.mApplicationContext = context;
        }

        private static void zzbB(Context context) {
            zzd zzd2;
            if (zzbVi.get() == null && zzbVi.compareAndSet(null, zzd2 = new zzd(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzd2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = zzuF;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zzbgQ.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzEt();
                }
            }
            zzd zzd2 = this;
            zzd2.mApplicationContext.unregisterReceiver((BroadcastReceiver)zzd2);
        }
    }

    public static interface zzc {
        public void zzac(boolean var1);
    }

    public static interface zzb {
    }

    public static interface zza {
        public void zzb(@NonNull aae var1);
    }
}

