/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.PublicApi;

@PublicApi
public class FirebaseInitProvider
extends ContentProvider {
    private static final String TAG = "FirebaseInitProvider";
    @VisibleForTesting
    static final String EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY = "com.google.firebase.firebaseinitprovider";

    public void attachInfo(Context context, ProviderInfo info) {
        FirebaseInitProvider.checkContentProviderAuthority(info);
        super.attachInfo(context, info);
    }

    public boolean onCreate() {
        if (FirebaseApp.initializeApp(this.getContext()) == null) {
            Log.i((String)TAG, (String)"FirebaseApp initialization unsuccessful");
        } else {
            Log.i((String)TAG, (String)"FirebaseApp initialization successful");
        }
        return false;
    }

    private static void checkContentProviderAuthority(@NonNull ProviderInfo info) {
        Preconditions.checkNotNull((Object)info, (Object)"FirebaseInitProvider ProviderInfo cannot be null.");
        if (EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY.equals(info.authority)) {
            throw new IllegalStateException("Incorrect provider authority in manifest. Most likely due to a missing applicationId variable in application's build.gradle.");
        }
    }

    @Nullable
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }
}

