/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import com.google.firebase.FirebaseCommonRegistrar$$Lambda$1;
import com.google.firebase.FirebaseCommonRegistrar$$Lambda$4;
import com.google.firebase.FirebaseCommonRegistrar$$Lambda$5;
import com.google.firebase.FirebaseCommonRegistrar$$Lambda$6;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatInfo;
import com.google.firebase.platforminfo.DefaultUserAgentPublisher;
import com.google.firebase.platforminfo.KotlinDetector;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import java.util.ArrayList;
import java.util.List;

public class FirebaseCommonRegistrar
implements ComponentRegistrar {
    private static final String FIREBASE_ANDROID = "fire-android";
    private static final String FIREBASE_COMMON = "fire-core";
    private static final String DEVICE_NAME = "device-name";
    private static final String DEVICE_MODEL = "device-model";
    private static final String DEVICE_BRAND = "device-brand";
    private static final String TARGET_SDK = "android-target-sdk";
    private static final String MIN_SDK = "android-min-sdk";
    private static final String ANDROID_PLATFORM = "android-platform";
    private static final String ANDROID_INSTALLER = "android-installer";
    private static final String KOTLIN = "kotlin";

    public List<Component<?>> getComponents() {
        ArrayList result = new ArrayList();
        result.add(DefaultUserAgentPublisher.component());
        result.add(DefaultHeartBeatInfo.component());
        result.add(LibraryVersionComponent.create(FIREBASE_ANDROID, String.valueOf(Build.VERSION.SDK_INT)));
        result.add(LibraryVersionComponent.create(FIREBASE_COMMON, "19.4.0"));
        result.add(LibraryVersionComponent.create(DEVICE_NAME, FirebaseCommonRegistrar.safeValue(Build.PRODUCT)));
        result.add(LibraryVersionComponent.create(DEVICE_MODEL, FirebaseCommonRegistrar.safeValue(Build.DEVICE)));
        result.add(LibraryVersionComponent.create(DEVICE_BRAND, FirebaseCommonRegistrar.safeValue(Build.BRAND)));
        result.add(LibraryVersionComponent.fromContext(TARGET_SDK, FirebaseCommonRegistrar$$Lambda$1.lambdaFactory$()));
        result.add(LibraryVersionComponent.fromContext(MIN_SDK, FirebaseCommonRegistrar$$Lambda$4.lambdaFactory$()));
        result.add(LibraryVersionComponent.fromContext(ANDROID_PLATFORM, FirebaseCommonRegistrar$$Lambda$5.lambdaFactory$()));
        result.add(LibraryVersionComponent.fromContext(ANDROID_INSTALLER, FirebaseCommonRegistrar$$Lambda$6.lambdaFactory$()));
        String kotlinVersion = KotlinDetector.detectVersion();
        if (kotlinVersion != null) {
            result.add(LibraryVersionComponent.create(KOTLIN, kotlinVersion));
        }
        return result;
    }

    private static String safeValue(String value) {
        return value.replace(' ', '_').replace('/', '_');
    }

    static /* synthetic */ String lambda$getComponents$3(Context ctx) {
        String installer = ctx.getPackageManager().getInstallerPackageName(ctx.getPackageName());
        return installer != null ? FirebaseCommonRegistrar.safeValue(installer) : "";
    }

    static /* synthetic */ String lambda$getComponents$2(Context ctx) {
        if (Build.VERSION.SDK_INT >= 16 && ctx.getPackageManager().hasSystemFeature("android.hardware.type.television")) {
            return "tv";
        }
        if (Build.VERSION.SDK_INT >= 20 && ctx.getPackageManager().hasSystemFeature("android.hardware.type.watch")) {
            return "watch";
        }
        if (Build.VERSION.SDK_INT >= 23 && ctx.getPackageManager().hasSystemFeature("android.hardware.type.automotive")) {
            return "auto";
        }
        if (Build.VERSION.SDK_INT >= 26 && ctx.getPackageManager().hasSystemFeature("android.hardware.type.embedded")) {
            return "embedded";
        }
        return "";
    }

    static /* synthetic */ String lambda$getComponents$1(Context ctx) {
        ApplicationInfo info = ctx.getApplicationInfo();
        if (info != null && Build.VERSION.SDK_INT >= 24) {
            return String.valueOf(info.minSdkVersion);
        }
        return "";
    }

    static /* synthetic */ String lambda$getComponents$0(Context ctx) {
        ApplicationInfo info = ctx.getApplicationInfo();
        if (info != null) {
            return String.valueOf(info.targetSdkVersion);
        }
        return "";
    }
}

