/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Lazy;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatInfo$$Lambda$1;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatInfo$$Lambda$2;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.heartbeatinfo.HeartBeatInfoStorage;
import com.google.firebase.inject.Provider;

public class DefaultHeartBeatInfo
implements HeartBeatInfo {
    private Provider<HeartBeatInfoStorage> storage;

    private DefaultHeartBeatInfo(Context context) {
        this((Provider<HeartBeatInfoStorage>)new Lazy(DefaultHeartBeatInfo$$Lambda$1.lambdaFactory$(context)));
    }

    @VisibleForTesting
    DefaultHeartBeatInfo(Provider<HeartBeatInfoStorage> testStorage) {
        this.storage = testStorage;
    }

    @Override
    @NonNull
    public HeartBeatInfo.HeartBeat getHeartBeatCode(@NonNull String heartBeatTag) {
        long presentTime = System.currentTimeMillis();
        boolean shouldSendSdkHB = ((HeartBeatInfoStorage)this.storage.get()).shouldSendSdkHeartBeat(heartBeatTag, presentTime);
        boolean shouldSendGlobalHB = ((HeartBeatInfoStorage)this.storage.get()).shouldSendGlobalHeartBeat(presentTime);
        if (shouldSendSdkHB && shouldSendGlobalHB) {
            return HeartBeatInfo.HeartBeat.COMBINED;
        }
        if (shouldSendGlobalHB) {
            return HeartBeatInfo.HeartBeat.GLOBAL;
        }
        if (shouldSendSdkHB) {
            return HeartBeatInfo.HeartBeat.SDK;
        }
        return HeartBeatInfo.HeartBeat.NONE;
    }

    @NonNull
    public static Component<HeartBeatInfo> component() {
        return Component.builder(HeartBeatInfo.class).add(Dependency.required(Context.class)).factory(DefaultHeartBeatInfo$$Lambda$2.lambdaFactory$()).build();
    }

    static /* synthetic */ HeartBeatInfo lambda$component$1(ComponentContainer c) {
        return new DefaultHeartBeatInfo((Context)c.get(Context.class));
    }

    static /* synthetic */ HeartBeatInfoStorage lambda$new$0(Context context) {
        return HeartBeatInfoStorage.getInstance(context);
    }
}

