/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import androidx.core.os.UserManagerCompat;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.firebase.FirebaseAppLifecycleListener;
import com.google.firebase.FirebaseCommonRegistrar;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentDiscovery;
import com.google.firebase.components.ComponentDiscoveryService;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.ComponentRegistrarProcessor;
import com.google.firebase.components.ComponentRuntime;
import com.google.firebase.components.Lazy;
import com.google.firebase.events.Publisher;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatController;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.DataCollectionConfigStorage;
import com.google.firebase.tracing.ComponentMonitor;
import com.google.firebase.tracing.FirebaseTrace;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    private static final String LOG_TAG = "FirebaseApp";
    @NonNull
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final Object LOCK = new Object();
    private static final Executor UI_EXECUTOR = new UiExecutor();
    @GuardedBy(value="LOCK")
    static final Map<String, FirebaseApp> INSTANCES = new ArrayMap();
    private static final String FIREBASE_ANDROID = "fire-android";
    private static final String FIREBASE_COMMON = "fire-core";
    private static final String KOTLIN = "kotlin";
    private final Context applicationContext;
    private final String name;
    private final FirebaseOptions options;
    private final ComponentRuntime componentRuntime;
    private final AtomicBoolean automaticResourceManagementEnabled = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean();
    private final Lazy<DataCollectionConfigStorage> dataCollectionConfigStorage;
    private final Provider<DefaultHeartBeatController> defaultHeartBeatController;
    private final List<BackgroundStateChangeListener> backgroundStateChangeListeners = new CopyOnWriteArrayList<BackgroundStateChangeListener>();
    private final List<FirebaseAppLifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<FirebaseAppLifecycleListener>();

    @NonNull
    public Context getApplicationContext() {
        this.checkNotDeleted();
        return this.applicationContext;
    }

    @NonNull
    public String getName() {
        this.checkNotDeleted();
        return this.name;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.checkNotDeleted();
        return this.options;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirebaseApp)) {
            return false;
        }
        return this.name.equals(((FirebaseApp)o).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("options", (Object)this.options).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static List<FirebaseApp> getApps(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            return new ArrayList<FirebaseApp>(INSTANCES.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static FirebaseApp getInstance() {
        Object object = LOCK;
        synchronized (object) {
            FirebaseApp defaultApp = INSTANCES.get(DEFAULT_APP_NAME);
            if (defaultApp == null) {
                throw new IllegalStateException("Default FirebaseApp is not initialized in this process " + ProcessUtils.getMyProcessName() + ". Make sure to call FirebaseApp.initializeApp(Context) first.");
            }
            return defaultApp;
        }
    }

    @NonNull
    public static FirebaseApp getInstance(@NonNull String name) {
        Object object = LOCK;
        synchronized (object) {
            FirebaseApp firebaseApp = INSTANCES.get(FirebaseApp.normalize(name));
            if (firebaseApp != null) {
                ((DefaultHeartBeatController)firebaseApp.defaultHeartBeatController.get()).registerHeartBeat();
                return firebaseApp;
            }
            List<String> availableAppNames = FirebaseApp.getAllAppNames();
            String availableAppNamesMessage = availableAppNames.isEmpty() ? "" : "Available app names: " + TextUtils.join((CharSequence)", ", availableAppNames);
            String errorMessage = String.format("FirebaseApp with name %s doesn't exist. %s", name, availableAppNamesMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCES.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                Log.w((String)LOG_TAG, (String)"Default FirebaseApp failed to initialize because no default options were found. This usually means that com.google.gms:google-services was not applied to your gradle project.");
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    @NonNull
    public static FirebaseApp initializeApp(@NonNull Context context, @NonNull FirebaseOptions options) {
        return FirebaseApp.initializeApp(context, options, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static FirebaseApp initializeApp(@NonNull Context context, @NonNull FirebaseOptions options, @NonNull String name) {
        FirebaseApp firebaseApp;
        GlobalBackgroundStateListener.ensureBackgroundStateListenerRegistered(context);
        String normalizedName = FirebaseApp.normalize(name);
        Context applicationContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = LOCK;
        synchronized (object) {
            Preconditions.checkState((!INSTANCES.containsKey(normalizedName) ? 1 : 0) != 0, (Object)("FirebaseApp name " + normalizedName + " already exists!"));
            Preconditions.checkNotNull((Object)applicationContext, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(applicationContext, normalizedName, options);
            INSTANCES.put(normalizedName, firebaseApp);
        }
        firebaseApp.initializeAllApis();
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        boolean valueChanged = this.deleted.compareAndSet(false, true);
        if (!valueChanged) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            INSTANCES.remove(this.name);
        }
        this.notifyOnAppDeleted();
    }

    @KeepForSdk
    public <T> T get(Class<T> anInterface) {
        this.checkNotDeleted();
        return (T)this.componentRuntime.get(anInterface);
    }

    public void setAutomaticResourceManagementEnabled(boolean enabled) {
        this.checkNotDeleted();
        boolean updated = this.automaticResourceManagementEnabled.compareAndSet(!enabled, enabled);
        if (updated) {
            boolean inBackground = BackgroundDetector.getInstance().isInBackground();
            if (enabled && inBackground) {
                this.notifyBackgroundStateChangeListeners(true);
            } else if (!enabled && inBackground) {
                this.notifyBackgroundStateChangeListeners(false);
            }
        }
    }

    @KeepForSdk
    public boolean isDataCollectionDefaultEnabled() {
        this.checkNotDeleted();
        return ((DataCollectionConfigStorage)this.dataCollectionConfigStorage.get()).isEnabled();
    }

    @KeepForSdk
    public void setDataCollectionDefaultEnabled(Boolean enabled) {
        this.checkNotDeleted();
        ((DataCollectionConfigStorage)this.dataCollectionConfigStorage.get()).setEnabled(enabled);
    }

    @Deprecated
    @KeepForSdk
    public void setDataCollectionDefaultEnabled(boolean enabled) {
        this.setDataCollectionDefaultEnabled((Boolean)enabled);
    }

    protected FirebaseApp(Context applicationContext, String name, FirebaseOptions options) {
        this.applicationContext = (Context)Preconditions.checkNotNull((Object)applicationContext);
        this.name = Preconditions.checkNotEmpty((String)name);
        this.options = (FirebaseOptions)Preconditions.checkNotNull((Object)options);
        FirebaseTrace.pushTrace("Firebase");
        FirebaseTrace.pushTrace("ComponentDiscovery");
        List registrars = ComponentDiscovery.forContext((Context)applicationContext, ComponentDiscoveryService.class).discoverLazy();
        FirebaseTrace.popTrace();
        FirebaseTrace.pushTrace("Runtime");
        this.componentRuntime = ComponentRuntime.builder((Executor)UI_EXECUTOR).addLazyComponentRegistrars((Collection)registrars).addComponentRegistrar((ComponentRegistrar)new FirebaseCommonRegistrar()).addComponent(Component.of((Object)applicationContext, Context.class, (Class[])new Class[0])).addComponent(Component.of((Object)this, FirebaseApp.class, (Class[])new Class[0])).addComponent(Component.of((Object)options, FirebaseOptions.class, (Class[])new Class[0])).setProcessor((ComponentRegistrarProcessor)new ComponentMonitor()).build();
        FirebaseTrace.popTrace();
        this.dataCollectionConfigStorage = new Lazy(() -> new DataCollectionConfigStorage(applicationContext, this.getPersistenceKey(), (Publisher)this.componentRuntime.get(Publisher.class)));
        this.defaultHeartBeatController = this.componentRuntime.getProvider(DefaultHeartBeatController.class);
        this.addBackgroundStateChangeListener(background -> {
            if (!background) {
                ((DefaultHeartBeatController)this.defaultHeartBeatController.get()).registerHeartBeat();
            }
        });
        FirebaseTrace.popTrace();
    }

    private void checkNotDeleted() {
        Preconditions.checkState((!this.deleted.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    @KeepForSdk
    @VisibleForTesting
    public boolean isDefaultApp() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    void initializeAllComponents() {
        this.componentRuntime.initializeAllComponentsForTests();
    }

    private void notifyBackgroundStateChangeListeners(boolean background) {
        Log.d((String)LOG_TAG, (String)"Notifying background state change listeners.");
        for (BackgroundStateChangeListener listener : this.backgroundStateChangeListeners) {
            listener.onBackgroundStateChanged(background);
        }
    }

    @KeepForSdk
    public void addBackgroundStateChangeListener(BackgroundStateChangeListener listener) {
        this.checkNotDeleted();
        if (this.automaticResourceManagementEnabled.get() && BackgroundDetector.getInstance().isInBackground()) {
            listener.onBackgroundStateChanged(true);
        }
        this.backgroundStateChangeListeners.add(listener);
    }

    @KeepForSdk
    public void removeBackgroundStateChangeListener(BackgroundStateChangeListener listener) {
        this.checkNotDeleted();
        this.backgroundStateChangeListeners.remove(listener);
    }

    @KeepForSdk
    public String getPersistenceKey() {
        return Base64Utils.encodeUrlSafeNoPadding((byte[])this.getName().getBytes(Charset.defaultCharset())) + "+" + Base64Utils.encodeUrlSafeNoPadding((byte[])this.getOptions().getApplicationId().getBytes(Charset.defaultCharset()));
    }

    @KeepForSdk
    public void addLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull((Object)listener);
        this.lifecycleListeners.add(listener);
    }

    @KeepForSdk
    public void removeLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull((Object)listener);
        this.lifecycleListeners.remove(listener);
    }

    private void notifyOnAppDeleted() {
        for (FirebaseAppLifecycleListener listener : this.lifecycleListeners) {
            listener.onDeleted(this.name, this.options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearInstancesForTest() {
        Object object = LOCK;
        synchronized (object) {
            INSTANCES.clear();
        }
    }

    @KeepForSdk
    public static String getPersistenceKey(String name, FirebaseOptions options) {
        return Base64Utils.encodeUrlSafeNoPadding((byte[])name.getBytes(Charset.defaultCharset())) + "+" + Base64Utils.encodeUrlSafeNoPadding((byte[])options.getApplicationId().getBytes(Charset.defaultCharset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAppNames() {
        ArrayList<String> allAppNames = new ArrayList<String>();
        Object object = LOCK;
        synchronized (object) {
            for (FirebaseApp app : INSTANCES.values()) {
                allAppNames.add(app.getName());
            }
        }
        Collections.sort(allAppNames);
        return allAppNames;
    }

    private void initializeAllApis() {
        boolean inDirectBoot;
        boolean bl = inDirectBoot = !UserManagerCompat.isUserUnlocked((Context)this.applicationContext);
        if (inDirectBoot) {
            Log.i((String)LOG_TAG, (String)("Device in Direct Boot Mode: postponing initialization of Firebase APIs for app " + this.getName()));
            UserUnlockReceiver.ensureReceiverRegistered(this.applicationContext);
        } else {
            Log.i((String)LOG_TAG, (String)("Device unlocked: initializing all Firebase APIs for app " + this.getName()));
            this.componentRuntime.initializeEagerComponents(this.isDefaultApp());
            ((DefaultHeartBeatController)this.defaultHeartBeatController.get()).registerHeartBeat();
        }
    }

    private static String normalize(@NonNull String name) {
        return name.trim();
    }

    private static class UiExecutor
    implements Executor {
        private static final Handler HANDLER = new Handler(Looper.getMainLooper());

        private UiExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            HANDLER.post(command);
        }
    }

    @TargetApi(value=14)
    private static class GlobalBackgroundStateListener
    implements BackgroundDetector.BackgroundStateChangeListener {
        private static AtomicReference<GlobalBackgroundStateListener> INSTANCE = new AtomicReference();

        private GlobalBackgroundStateListener() {
        }

        private static void ensureBackgroundStateListenerRegistered(Context context) {
            GlobalBackgroundStateListener listener;
            if (!PlatformVersion.isAtLeastIceCreamSandwich() || !(context.getApplicationContext() instanceof Application)) {
                return;
            }
            Application application = (Application)context.getApplicationContext();
            if (INSTANCE.get() == null && INSTANCE.compareAndSet(null, listener = new GlobalBackgroundStateListener())) {
                BackgroundDetector.initialize((Application)application);
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBackgroundStateChanged(boolean background) {
            Object object = LOCK;
            synchronized (object) {
                for (FirebaseApp app : new ArrayList<FirebaseApp>(INSTANCES.values())) {
                    if (!app.automaticResourceManagementEnabled.get()) continue;
                    app.notifyBackgroundStateChangeListeners(background);
                }
            }
        }
    }

    @TargetApi(value=24)
    private static class UserUnlockReceiver
    extends BroadcastReceiver {
        private static AtomicReference<UserUnlockReceiver> INSTANCE = new AtomicReference();
        private final Context applicationContext;

        public UserUnlockReceiver(Context applicationContext) {
            this.applicationContext = applicationContext;
        }

        private static void ensureReceiverRegistered(Context applicationContext) {
            UserUnlockReceiver receiver;
            if (INSTANCE.get() == null && INSTANCE.compareAndSet(null, receiver = new UserUnlockReceiver(applicationContext))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                applicationContext.registerReceiver((BroadcastReceiver)receiver, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = LOCK;
            synchronized (object) {
                for (FirebaseApp app : INSTANCES.values()) {
                    app.initializeAllApis();
                }
            }
            this.unregister();
        }

        public void unregister() {
            this.applicationContext.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    @KeepForSdk
    public static interface BackgroundStateChangeListener {
        @KeepForSdk
        public void onBackgroundStateChanged(boolean var1);
    }
}

