/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzaiz;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzbEC = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzbED = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzbEE = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final Set<String> zzbEF = Collections.emptySet();
    private static final Object zzrs = new Object();
    static final Map<String, FirebaseApp> zzaTZ = new ArrayMap();
    private final Context zztm;
    private final String mName;
    private final FirebaseOptions zzbEG;
    private final AtomicBoolean zzbEH = new AtomicBoolean(true);
    private final AtomicBoolean zzbEI = new AtomicBoolean();
    private final List<zza> zzbEJ = new CopyOnWriteArrayList<zza>();
    private final List<zzb> zzbEK = new CopyOnWriteArrayList<zzb>();
    private final List<Object> zzbEL = new CopyOnWriteArrayList<Object>();
    protected zzaja zzbEM;

    public zzaja zzNS() {
        this.zzNT();
        return this.zzbEM;
    }

    @NonNull
    public Context getApplicationContext() {
        this.zzNT();
        return this.zztm;
    }

    @NonNull
    public String getName() {
        this.zzNT();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzNT();
        return this.zzbEG;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzz.zzy((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzbEG).toString();
    }

    public static List<FirebaseApp> getApps(Context context) {
        return new ArrayList<FirebaseApp>(zzaTZ.values());
    }

    @Nullable
    public static FirebaseApp getInstance() {
        return FirebaseApp.getInstance(DEFAULT_APP_NAME);
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzrs;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzaTZ.get(FirebaseApp.zzhF(string));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzNW();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(zzx.zzdk((String)", ").zza(list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string2);
            throw new IllegalStateException(string4);
        }
    }

    public static FirebaseApp zzbu(Context context) {
        FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
        if (firebaseOptions == null) {
            return null;
        }
        return FirebaseApp.initializeApp(context, firebaseOptions);
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzaiz zzaiz2 = zzaiz.zzbA(context);
        FirebaseApp.zzbv(context);
        String string2 = FirebaseApp.zzhF(string);
        Context context2 = context.getApplicationContext();
        Object object = zzrs;
        synchronized (object) {
            zzaa.zza((!zzaTZ.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzaa.zzb((Object)context2, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context2, string2, firebaseOptions);
            zzaTZ.put(string2, firebaseApp);
        }
        zzaiz2.zzf(firebaseApp);
        FirebaseApp.zza(FirebaseApp.class, firebaseApp, zzbEC);
        if (firebaseApp.zzNU()) {
            FirebaseApp.zza(FirebaseApp.class, firebaseApp, zzbED);
            FirebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzbEE);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzaI(boolean bl) {
        Object object = zzrs;
        synchronized (object) {
            for (FirebaseApp firebaseApp : new ArrayList<FirebaseApp>(zzaTZ.values())) {
                if (!firebaseApp.zzbEH.get()) continue;
                firebaseApp.zzaJ(bl);
            }
        }
    }

    protected FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.zztm = (Context)zzaa.zzz((Object)context);
        this.mName = zzaa.zzdl((String)string);
        this.zzbEG = (FirebaseOptions)zzaa.zzz((Object)firebaseOptions);
    }

    private void zzNT() {
        zzaa.zza((!this.zzbEI.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public void zza(@NonNull zzaja zzaja2) {
        this.zzbEM = (zzaja)zzaa.zzz((Object)zzaja2);
    }

    public Task<GetTokenResult> getToken(boolean bl) {
        this.zzNT();
        if (this.zzbEM == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzbEM.zza(this.zzbEM.getCurrentUser(), bl);
    }

    public boolean zzNU() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public void zza(zzaja zzaja2, FirebaseUser firebaseUser) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        for (zza zza2 : this.zzbEJ) {
            zza2.zzb(zzaja2, firebaseUser);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private void zzaJ(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        for (zzb zzb2 : this.zzbEK) {
            zzb2.zzaI(bl);
        }
    }

    public void zza(@NonNull zza zza2) {
        this.zzNT();
        zzaa.zzz((Object)zza2);
        this.zzbEJ.add(zza2);
    }

    public String zzNV() {
        String string = String.valueOf(zzc.zzm((byte[])this.getName().getBytes()));
        String string2 = String.valueOf(zzc.zzm((byte[])this.getOptions().getApplicationId().getBytes()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzNW() {
        com.google.android.gms.common.util.zza zza2 = new com.google.android.gms.common.util.zza();
        ArrayList<String> arrayList = zzrs;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzaTZ.values()) {
                zza2.add(firebaseApp.getName());
            }
            zzaiz zzaiz2 = zzaiz.zzUw();
            if (zzaiz2 != null) {
                zza2.addAll(zzaiz2.zzUx());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)zza2);
        Collections.sort(arrayList);
        return arrayList;
    }

    private static <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        for (String string : iterable) {
            try {
                Class<?> clazz2 = Class.forName(string);
                Method method = clazz2.getMethod("getInstance", clazz);
                int n = 9;
                if ((method.getModifiers() & 9) == 9) {
                    method.invoke(null, t);
                }
                String string2 = String.valueOf(clazz2);
                Log.d((String)"FirebaseApp", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Initialized ").append(string2).append(".").toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzbEF.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string3 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string3.length() != 0 ? "Failed to initialize ".concat(string3) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    private static String zzhF(@NonNull String string) {
        return string.trim();
    }

    @TargetApi(value=14)
    private static void zzbv(Context context) {
        if (zzs.zzva() && context.getApplicationContext() instanceof Application) {
            Application application = (Application)context.getApplicationContext();
            zzaiy.zza(application);
        }
    }

    public static interface zzb {
        public void zzaI(boolean var1);
    }

    public static interface zza {
        public void zzb(@NonNull zzaja var1, @Nullable FirebaseUser var2);
    }
}

