/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzy;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzalo;
import com.google.android.gms.internal.zzalp;
import com.google.android.gms.internal.zzalq;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> aMv = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> aMw = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> aMx = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final Set<String> aMy = Collections.emptySet();
    private static final Object zzamr = new Object();
    static final Map<String, FirebaseApp> aap = new ArrayMap();
    private final Context zzaql;
    private final String mName;
    private final FirebaseOptions aMz;
    private final AtomicBoolean aMA = new AtomicBoolean(true);
    private final AtomicBoolean aMB = new AtomicBoolean();
    private final List<zza> aMC = new CopyOnWriteArrayList<zza>();
    private final List<zzb> aMD = new CopyOnWriteArrayList<zzb>();
    private final List<Object> aME = new CopyOnWriteArrayList<Object>();
    protected zzalq aMF;

    public zzalq zzcjz() {
        this.zzcka();
        return this.aMF;
    }

    @NonNull
    public Context getApplicationContext() {
        this.zzcka();
        return this.zzaql;
    }

    @NonNull
    public String getName() {
        this.zzcka();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzcka();
        return this.aMz;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzaa.zzx((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.aMz).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        zzalp zzalp2 = zzalp.zzeq(context);
        Object object = zzamr;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(aap.values());
            Set<String> set = zzalp.zzcxc().zzcxd();
            set.removeAll(aap.keySet());
            for (String string : set) {
                FirebaseOptions firebaseOptions = zzalp2.zzta(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, firebaseOptions, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    @Nullable
    public static FirebaseApp getInstance() {
        return FirebaseApp.getInstance(DEFAULT_APP_NAME);
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzamr;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = aap.get(FirebaseApp.zzra(string));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzckd();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(zzy.zzhq((String)", ").zza(list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string2);
            throw new IllegalStateException(string4);
        }
    }

    public static FirebaseApp zzek(Context context) {
        FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
        if (firebaseOptions == null) {
            return null;
        }
        return FirebaseApp.initializeApp(context, firebaseOptions);
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzalp zzalp2 = zzalp.zzeq(context);
        FirebaseApp.zzel(context);
        String string2 = FirebaseApp.zzra(string);
        Context context2 = context.getApplicationContext();
        Object object = zzamr;
        synchronized (object) {
            zzab.zza((!aap.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzab.zzb((Object)context2, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context2, string2, firebaseOptions);
            aap.put(string2, firebaseApp);
        }
        zzalp2.zzf(firebaseApp);
        FirebaseApp.zza(FirebaseApp.class, firebaseApp, aMv);
        if (firebaseApp.zzckb()) {
            FirebaseApp.zza(FirebaseApp.class, firebaseApp, aMw);
            FirebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), aMx);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzcl(boolean bl) {
        Object object = zzamr;
        synchronized (object) {
            for (FirebaseApp firebaseApp : new ArrayList<FirebaseApp>(aap.values())) {
                if (!firebaseApp.aMA.get()) continue;
                firebaseApp.zzcm(bl);
            }
        }
    }

    protected FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.zzaql = (Context)zzab.zzy((Object)context);
        this.mName = zzab.zzhr((String)string);
        this.aMz = (FirebaseOptions)zzab.zzy((Object)firebaseOptions);
    }

    private void zzcka() {
        zzab.zza((!this.aMB.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public void zza(@NonNull zzalq zzalq2) {
        this.aMF = (zzalq)zzab.zzy((Object)zzalq2);
    }

    public Task<GetTokenResult> getToken(boolean bl) {
        this.zzcka();
        if (this.aMF == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.aMF.zza(this.aMF.getCurrentUser(), bl);
    }

    public boolean zzckb() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public void zza(zzalq zzalq2, FirebaseUser firebaseUser) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        for (zza zza2 : this.aMC) {
            zza2.zzb(zzalq2, firebaseUser);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private void zzcm(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        for (zzb zzb2 : this.aMD) {
            zzb2.zzcl(bl);
        }
    }

    public void zza(@NonNull zza zza2) {
        this.zzcka();
        zzab.zzy((Object)zza2);
        this.aMC.add(zza2);
    }

    public String zzckc() {
        String string = String.valueOf(zzc.zzr((byte[])this.getName().getBytes()));
        String string2 = String.valueOf(zzc.zzr((byte[])this.getOptions().getApplicationId().getBytes()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzckd() {
        com.google.android.gms.common.util.zza zza2 = new com.google.android.gms.common.util.zza();
        ArrayList<String> arrayList = zzamr;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : aap.values()) {
                zza2.add(firebaseApp.getName());
            }
            zzalp zzalp2 = zzalp.zzcxc();
            if (zzalp2 != null) {
                zza2.addAll(zzalp2.zzcxd());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)zza2);
        Collections.sort(arrayList);
        return arrayList;
    }

    private static <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        for (String string : iterable) {
            try {
                Class<?> clazz2 = Class.forName(string);
                Method method = clazz2.getMethod("getInstance", clazz);
                int n = method.getModifiers();
                if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (aMy.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    private static String zzra(@NonNull String string) {
        return string.trim();
    }

    @TargetApi(value=14)
    private static void zzel(Context context) {
        if (zzs.zzavq() && context.getApplicationContext() instanceof Application) {
            Application application = (Application)context.getApplicationContext();
            zzalo.zza(application);
        }
    }

    public static interface zzb {
        public void zzcl(boolean var1);
    }

    public static interface zza {
        public void zzb(@NonNull zzalq var1, @Nullable FirebaseUser var2);
    }
}

