/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzadi;
import com.google.android.gms.internal.zzado;
import com.google.android.gms.internal.zzblq;
import com.google.android.gms.internal.zzbub;
import com.google.android.gms.internal.zzbuc;
import com.google.android.gms.internal.zzbud;
import com.google.android.gms.internal.zzbue;
import com.google.android.gms.internal.zzbuf;
import com.google.android.gms.internal.zzbug;
import com.google.android.gms.internal.zzbuh;
import com.google.android.gms.internal.zzbui;
import com.google.android.gms.internal.zzbyb;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzcnO;
    private zzbue zzcnP;
    private zzbue zzcnQ;
    private zzbue zzcnR;
    private zzbuh zzcnS;
    private final Context mContext;
    private final ReadWriteLock zzcnT = new ReentrantReadWriteLock(true);

    FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzbue zzbue2, zzbue zzbue3, zzbue zzbue4, zzbuh zzbuh2) {
        this.mContext = context;
        this.zzcnS = zzbuh2 != null ? zzbuh2 : new zzbuh();
        this.zzcnS.zzbg(this.zzcF(this.mContext));
        if (zzbue2 != null) {
            this.zzcnP = zzbue2;
        }
        if (zzbue3 != null) {
            this.zzcnQ = zzbue3;
        }
        if (zzbue4 != null) {
            this.zzcnR = zzbue4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzcnO == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            return FirebaseRemoteConfig.zzcE(context);
        }
        return zzcnO;
    }

    public static FirebaseRemoteConfig zzcE(Context context) {
        if (zzcnO == null) {
            zzbui.zze zze2 = FirebaseRemoteConfig.zzcG(context);
            if (zze2 == null) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                }
                zzcnO = new FirebaseRemoteConfig(context);
            } else {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                }
                zzbue zzbue2 = FirebaseRemoteConfig.zza(zze2.zzcot);
                zzbue zzbue3 = FirebaseRemoteConfig.zza(zze2.zzcou);
                zzbue zzbue4 = FirebaseRemoteConfig.zza(zze2.zzcov);
                zzbuh zzbuh2 = FirebaseRemoteConfig.zza(zze2.zzcow);
                if (zzbuh2 != null) {
                    zzbuh2.zzaJ(FirebaseRemoteConfig.zza(zze2.zzcox));
                }
                zzcnO = new FirebaseRemoteConfig(context, zzbue2, zzbue3, zzbue4, zzbuh2);
            }
        }
        return zzcnO;
    }

    private long zzcF(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzbui.zze zzcG(Context context) {
        zzbui.zze zze2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            zzbyb zzbyb2 = zzbyb.zzag((byte[])FirebaseRemoteConfig.zzk(fileInputStream));
            zze2 = new zzbui.zze();
            zze2.zzb(zzbyb2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zze2;
    }

    private static Map<String, zzbub> zza(zzbui.zzf[] zzfArray) {
        HashMap<String, zzbub> hashMap = new HashMap<String, zzbub>();
        if (zzfArray == null) {
            return hashMap;
        }
        for (zzbui.zzf zzf2 : zzfArray) {
            String string = zzf2.zzaGP;
            int n = zzf2.resourceId;
            long l = zzf2.zzcoz;
            hashMap.put(string, new zzbub(n, l));
        }
        return hashMap;
    }

    private static zzbuh zza(zzbui.zzc zzc2) {
        if (zzc2 == null) {
            return null;
        }
        zzbuh zzbuh2 = new zzbuh();
        zzbuh2.zzqP(zzc2.zzcoo);
        zzbuh2.zzbi(zzc2.zzcop);
        zzbuh2.zzbh(zzc2.zzcoq);
        return zzbuh2;
    }

    /*
     * WARNING - void declaration
     */
    private static zzbue zza(zzbui.zza zza2) {
        void var5_8;
        zzbui.zzd[] zzdArray;
        if (zza2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        zzbui.zzd[] object = zzdArray = zza2.zzcok;
        int arrayList = object.length;
        boolean bl = false;
        while (var5_8 < arrayList) {
            zzbui.zzd zzd2 = object[var5_8];
            String string = zzd2.zzaGP;
            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
            for (zzbui.zzb zzb2 : zzd2.zzcos) {
                hashMap2.put(zzb2.zzaB, zzb2.zzcon);
            }
            hashMap.put(string, hashMap2);
            ++var5_8;
        }
        byte[][] byArray = zza2.zzcol;
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        for (byte[] byArray2 : byArray) {
            arrayList2.add(byArray2);
        }
        return new zzbue(hashMap, zza2.timestamp, arrayList2);
    }

    private static byte[] zzk(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FirebaseRemoteConfig.zzb(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long zzb(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateFetched() {
        this.zzcnT.writeLock().lock();
        try {
            if (this.zzcnP == null) {
                return false;
            }
            if (this.zzcnQ != null && this.zzcnQ.getTimestamp() >= this.zzcnP.getTimestamp()) {
                return false;
            }
            long l = this.zzcnP.getTimestamp();
            this.zzcnQ = this.zzcnP;
            this.zzcnQ.setTimestamp(System.currentTimeMillis());
            this.zzcnP = new zzbue(null, l, null);
            long l2 = this.zzcnS.zzacS();
            this.zzcnS.zzbh(zzblq.zza(l2, this.zzcnQ.zzzE()));
            this.zza(this.mContext, this.zzcnQ.zzzE(), l2);
            this.zzacK();
            return true;
        }
        finally {
            this.zzcnT.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzcnT.readLock().lock();
        try {
            if (this.zzcnS != null && this.zzcnS.zzacQ() != null && this.zzcnS.zzacQ().get(string) != null && n == ((zzbub)(object = this.zzcnS.zzacQ().get(string))).zzacL() && this.zzcnS.zzacR() == ((zzbub)object).zzacM()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
        object = new HashMap();
        try {
            Resources resources = this.mContext.getResources();
            XmlResourceParser xmlResourceParser = resources.getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzbub zzbub2 = new zzbub(n, this.zzcnS.zzacR());
            this.zzcnS.zza(string, zzbub2);
            this.zzc((Map<String, Object>)object, string, false);
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzbug.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzbug.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzbug.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzbug.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzbug.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzbug.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzcnT.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzcnR == null || !this.zzcnR.zzjY(string)) {
                    return;
                }
                this.zzcnR.zzj(null, string);
                this.zzcnR.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzcnR == null) {
                    this.zzcnR = new zzbue(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzcnR.zzj(hashMap, string);
                this.zzcnR.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzcnS.zzjZ(string);
            }
            this.zzacK();
        }
        finally {
            this.zzcnT.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzcnT.writeLock().lock();
        try {
            boolean bl = this.zzcnS.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzcnS.zzbi(bl2);
            if (bl != bl2) {
                this.zzacK();
            }
        }
        finally {
            this.zzcnT.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzcnT.readLock().lock();
        try {
            if (this.zzcnQ != null && this.zzcnQ.zzaA(string, string2)) {
                byte[] byArray = this.zzcnQ.zzaB(string, string2);
                return byArray;
            }
            if (this.zzcnR != null && this.zzcnR.zzaA(string, string2)) {
                byte[] byArray = this.zzcnR.zzaB(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_STRING;
        }
        this.zzcnT.readLock().lock();
        try {
            if (this.zzcnQ != null && this.zzcnQ.zzaA(string, string2)) {
                String string3 = new String(this.zzcnQ.zzaB(string, string2), zzbug.UTF_8);
                return string3;
            }
            if (this.zzcnR != null && this.zzcnR.zzaA(string, string2)) {
                String string4 = new String(this.zzcnR.zzaB(string, string2), zzbug.UTF_8);
                return string4;
            }
            String string5 = DEFAULT_VALUE_FOR_STRING;
            return string5;
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzcnT.readLock().lock();
        try {
            String string3;
            if (this.zzcnQ != null && this.zzcnQ.zzaA(string, string2)) {
                string3 = new String(this.zzcnQ.zzaB(string, string2), zzbug.UTF_8);
                if (zzbug.zzaII.matcher(string3).matches()) {
                    return true;
                }
                if (zzbug.zzaIJ.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzcnR != null && this.zzcnR.zzaA(string, string2)) {
                string3 = new String(this.zzcnR.zzaB(string, string2), zzbug.UTF_8);
                if (zzbug.zzaII.matcher(string3).matches()) {
                    return true;
                }
                if (zzbug.zzaIJ.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzbug(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzcnT.readLock().lock();
        try {
            if (this.zzcnQ != null && this.zzcnQ.zzaA(string, string2)) {
                zzbug zzbug2 = new zzbug(this.zzcnQ.zzaB(string, string2), 2);
                return zzbug2;
            }
            if (this.zzcnR != null && this.zzcnR.zzaA(string, string2)) {
                zzbug zzbug3 = new zzbug(this.zzcnR.zzaB(string, string2), 1);
                return zzbug3;
            }
            zzbug zzbug4 = new zzbug(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzbug4;
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        zzbuf zzbuf2 = new zzbuf();
        this.zzcnT.readLock().lock();
        try {
            long l = this.zzcnP == null ? -1L : this.zzcnP.getTimestamp();
            zzbuf2.zzbf(l);
            zzbuf2.zzqP(this.zzcnS.getLastFetchStatus());
            zzbuf2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzcnS.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
        return zzbuf2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzcnT.readLock().lock();
        try {
            if (this.zzcnQ == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzcnQ.zzaC(string, string2);
            return set;
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
    }

    private void zzt(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private void zza(Context context, List<byte[]> list, long l) {
        this.zzt(new zzbuc(context, list, l));
    }

    private void zzacK() {
        this.zzcnT.readLock().lock();
        try {
            this.zzt(new zzbud(this.mContext, this.zzcnP, this.zzcnQ, this.zzcnR, this.zzcnS));
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> fetch(long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcnT.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzadi.zza.zza zza2 = new zzadi.zza.zza();
            zza2.zzK(l);
            if (this.zzcnS.isDeveloperModeEnabled()) {
                zza2.zzH("_rcn_developer", "true");
            }
            zza2.zzdr(10300);
            if (this.zzcnQ != null && this.zzcnQ.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzcnQ.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zza2.zzdt(n);
            }
            if (this.zzcnP != null && this.zzcnP.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzcnP.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zza2.zzds(n);
            }
            PendingResult<zzadi.zzb> pendingResult = new zzado(this.mContext).zza(zza2.zzzD());
            pendingResult.setResultCallback((ResultCallback)new ResultCallback<zzadi.zzb>(){

                public void zza(@NonNull zzadi.zzb zzb2) {
                    FirebaseRemoteConfig.this.zza((TaskCompletionSource<Void>)taskCompletionSource, zzb2);
                }

                public /* synthetic */ void onResult(@NonNull Result result) {
                    this.zza((zzadi.zzb)result);
                }
            });
        }
        finally {
            this.zzcnT.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    void zza(TaskCompletionSource<Void> taskCompletionSource, zzadi.zzb zzb2) {
        if (zzb2 == null || zzb2.getStatus() == null) {
            this.zzcnS.zzqP(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzacK();
            return;
        }
        int n = zzb2.getStatus().getStatusCode();
        this.zzcnT.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzcnS.zzqP(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzacK();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzcnS.zzqP(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzb2.getThrottleEndTimeMillis())));
                    this.zzacK();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzcnS.zzqP(-1);
                    if (this.zzcnP != null && !this.zzcnP.zzacO()) {
                        Map<String, Set<String>> map = zzb2.zzzF();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzb2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzcnP = new zzbue(hashMap, this.zzcnP.getTimestamp(), zzb2.zzzE());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzacK();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzb2.zzzF();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzb2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzcnP = new zzbue(hashMap, System.currentTimeMillis(), zzb2.zzzE());
                    this.zzcnS.zzqP(-1);
                    taskCompletionSource.setResult(null);
                    this.zzacK();
                    return;
                }
                default: {
                    if (zzb2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzcnS.zzqP(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzacK();
                    return;
                }
            }
        }
        finally {
            this.zzcnT.writeLock().unlock();
        }
    }
}

