/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbip;
import com.google.android.gms.internal.zzbir;
import com.google.android.gms.internal.zzbit;
import com.google.android.gms.internal.zzbiy;
import com.google.android.gms.internal.zzbjg;
import com.google.android.gms.internal.zzbjm;
import com.google.android.gms.internal.zzbjs;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzbix
implements zzbip {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzaKw = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzaKx = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbit> zza(GoogleApiClient googleApiClient, zzbir zzbir2) {
        if (googleApiClient == null || zzbir2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzbck)new zzbiy(this, googleApiClient, zzbir2));
    }

    private static Status zzaH(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbjm zzbjm2) {
        if (zzbjm2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbjm2.zzst();
        if (dataHolder == null) {
            return null;
        }
        zzbjs zzbjs2 = (zzbjs)((Object)new zzd(dataHolder, zzbjs.CREATOR).get(0));
        zzbjm2.zzsv();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbjs2.zzsx().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbjs2.zzsx().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbjm zzbjm2) {
        if (zzbjm2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbjm2.zzsu();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbjg.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbjg)((Object)iterator.next())).getPayload());
        }
        zzbjm2.zzsw();
        return arrayList;
    }

    static /* synthetic */ Status zzaI(int n) {
        return zzbix.zzaH(n);
    }

    static /* synthetic */ HashMap zzc(zzbjm zzbjm2) {
        return zzbix.zza(zzbjm2);
    }
}

