/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.afu;
import com.google.android.gms.internal.afv;
import com.google.android.gms.internal.afw;
import com.google.android.gms.internal.afx;
import com.google.android.gms.internal.afy;
import com.google.android.gms.internal.afz;
import com.google.android.gms.internal.aga;
import com.google.android.gms.internal.agb;
import com.google.android.gms.internal.agc;
import com.google.android.gms.internal.agd;
import com.google.android.gms.internal.age;
import com.google.android.gms.internal.agf;
import com.google.android.gms.internal.agg;
import com.google.android.gms.internal.ahw;
import com.google.android.gms.internal.ko;
import com.google.android.gms.internal.zzbin;
import com.google.android.gms.internal.zzbir;
import com.google.android.gms.internal.zzbis;
import com.google.android.gms.internal.zzbit;
import com.google.android.gms.internal.zzbje;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzcqb;
    private afx zzcqc;
    private afx zzcqd;
    private afx zzcqe;
    private aga zzcqf;
    private final Context mContext;
    private final ReadWriteLock zzcqg = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, afx afx2, afx afx3, afx afx4, aga aga2) {
        this.mContext = context;
        this.zzcqf = aga2 != null ? aga2 : new aga();
        this.zzcqf.zzaL(this.zzbT(this.mContext));
        if (afx2 != null) {
            this.zzcqc = afx2;
        }
        if (afx3 != null) {
            this.zzcqd = afx3;
        }
        if (afx4 != null) {
            this.zzcqe = afx4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzcqb == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzcqb == null) {
                agf agf2 = FirebaseRemoteConfig.zzbU(context);
                if (agf2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzcqb = new FirebaseRemoteConfig(context);
                } else {
                    aga aga2;
                    aga aga3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    afx afx2 = FirebaseRemoteConfig.zza(agf2.zzcqG);
                    afx afx3 = FirebaseRemoteConfig.zza(agf2.zzcqH);
                    afx afx4 = FirebaseRemoteConfig.zza(agf2.zzcqI);
                    agd agd2 = agf2.zzcqJ;
                    if (agd2 == null) {
                        aga3 = null;
                    } else {
                        aga aga4 = new aga();
                        aga4.zzcd(agd2.zzcqB);
                        aga4.zzaJ(agd2.zzcqC);
                        aga4.zzaM(agd2.zzcqD);
                        aga3 = aga2 = aga4;
                    }
                    if (aga3 != null) {
                        aga2.zzH(FirebaseRemoteConfig.zza(agf2.zzcqK));
                    }
                    zzcqb = new FirebaseRemoteConfig(context, afx2, afx3, afx4, aga2);
                }
            }
            return zzcqb;
        }
        return zzcqb;
    }

    private final long zzbT(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static agf zzbU(Context context) {
        agf agf2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            ahw ahw2 = ahw.zzb((byte[])byArray, (int)0, (int)((Object)object).length);
            agf2 = new agf();
            agf2.zza(ahw2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return agf2;
    }

    private static Map<String, afu> zza(agg[] aggArray) {
        HashMap<String, afu> hashMap = new HashMap<String, afu>();
        if (aggArray == null) {
            return hashMap;
        }
        agg[] aggArray2 = aggArray;
        int n = aggArray.length;
        for (int i = 0; i < n; ++i) {
            agg agg2 = aggArray2[i];
            String string = agg2.zzbxY;
            int n2 = agg2.resourceId;
            long l = agg2.zzcqM;
            hashMap.put(string, new afu(n2, l));
        }
        return hashMap;
    }

    private static afx zza(agb agb2) {
        Object object;
        if (agb2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = agb2.zzcqx;
        int n = agb2.zzcqx.length;
        for (int i = 0; i < n; ++i) {
            age age2 = object2[i];
            String string = age2.zzbxY;
            object = new HashMap();
            agc[] agcArray = age2.zzcqF;
            int n2 = age2.zzcqF.length;
            for (int j = 0; j < n2; ++j) {
                agc agc2 = agcArray[j];
                object.put(agc2.key, agc2.zzcqA);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = agb2.zzcqy;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((age[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new afx(hashMap, agb2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzcqg.writeLock().lock();
        try {
            if (this.zzcqc == null) {
                return false;
            }
            if (this.zzcqd != null && this.zzcqd.getTimestamp() >= this.zzcqc.getTimestamp()) {
                return false;
            }
            long l = this.zzcqc.getTimestamp();
            this.zzcqd = this.zzcqc;
            this.zzcqd.setTimestamp(System.currentTimeMillis());
            this.zzcqc = new afx(null, l, null);
            long l2 = this.zzcqf.zzKY();
            this.zzcqf.zzaM(ko.zza(l2, this.zzcqd.zzsr()));
            long l3 = l2;
            List<byte[]> list = this.zzcqd.zzsr();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzr(new afv(context, list, l3));
            this.zzKR();
            return true;
        }
        finally {
            this.zzcqg.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzcqg.readLock().lock();
        try {
            if (this.zzcqf != null && this.zzcqf.zzKW() != null && this.zzcqf.zzKW().get(string) != null && n == ((afu)(object = this.zzcqf.zzKW().get(string))).zzKS() && this.zzcqf.zzKX() == ((afu)object).zzKT()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzcqg.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            afu afu2 = new afu(n, this.zzcqf.zzKX());
            this.zzcqf.zza(string, afu2);
            this.zzc((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    private final void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(afz.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(afz.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(afz.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(afz.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(afz.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(afz.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzcqg.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzcqe == null || !this.zzcqe.zzie(string)) {
                    return;
                }
                this.zzcqe.zzh(null, string);
                this.zzcqe.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzcqe == null) {
                    this.zzcqe = new afx(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzcqe.zzh(hashMap, string);
                this.zzcqe.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzcqf.zzif(string);
            }
            this.zzKR();
            return;
        }
        finally {
            this.zzcqg.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzcqg.writeLock().lock();
        try {
            boolean bl = this.zzcqf.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzcqf.zzaJ(bl2);
            if (bl != bl2) {
                this.zzKR();
            }
            return;
        }
        finally {
            this.zzcqg.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzcqg.readLock().lock();
        try {
            if (this.zzcqd != null && this.zzcqd.zzak(string, string2)) {
                byte[] byArray = this.zzcqd.zzal(string, string2);
                return byArray;
            }
            if (this.zzcqe != null && this.zzcqe.zzak(string, string2)) {
                byte[] byArray = this.zzcqe.zzal(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzcqg.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzcqg.readLock().lock();
            try {
                if (this.zzcqd == null || !this.zzcqd.zzak(string, string2)) break block5;
                String string3 = new String(this.zzcqd.zzal(string, string2), afz.UTF_8);
                this.zzcqg.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzcqg.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzcqe != null && this.zzcqe.zzak(string, string2)) {
            String string4 = new String(this.zzcqe.zzal(string, string2), afz.UTF_8);
            this.zzcqg.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzcqg.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzcqg.readLock().lock();
        try {
            String string3;
            if (this.zzcqd != null && this.zzcqd.zzak(string, string2)) {
                string3 = new String(this.zzcqd.zzal(string, string2), afz.UTF_8);
                if (afz.zzaKw.matcher(string3).matches()) {
                    return true;
                }
                if (afz.zzaKx.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzcqe != null && this.zzcqe.zzak(string, string2)) {
                string3 = new String(this.zzcqe.zzal(string, string2), afz.UTF_8);
                if (afz.zzaKw.matcher(string3).matches()) {
                    return true;
                }
                if (afz.zzaKx.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzcqg.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new afz(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzcqg.readLock().lock();
        try {
            if (this.zzcqd != null && this.zzcqd.zzak(string, string2)) {
                afz afz2 = new afz(this.zzcqd.zzal(string, string2), 2);
                return afz2;
            }
            if (this.zzcqe != null && this.zzcqe.zzak(string, string2)) {
                afz afz3 = new afz(this.zzcqe.zzal(string, string2), 1);
                return afz3;
            }
            afz afz4 = new afz(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return afz4;
        }
        finally {
            this.zzcqg.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        afy afy2 = new afy();
        this.zzcqg.readLock().lock();
        try {
            long l = this.zzcqc == null ? -1L : this.zzcqc.getTimestamp();
            afy2.zzaK(l);
            afy2.zzcd(this.zzcqf.getLastFetchStatus());
            afy2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzcqf.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzcqg.readLock().unlock();
        }
        return afy2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzcqg.readLock().lock();
        try {
            if (this.zzcqd == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzcqd.zzam(string, string2);
            return set;
        }
        finally {
            this.zzcqg.readLock().unlock();
        }
    }

    private static void zzr(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzKR() {
        this.zzcqg.readLock().lock();
        try {
            FirebaseRemoteConfig.zzr(new afw(this.mContext, this.zzcqc, this.zzcqd, this.zzcqe, this.zzcqf));
            return;
        }
        finally {
            this.zzcqg.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcqg.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbis zzbis2 = new zzbis();
            zzbis2.zzA(l);
            if (this.zzcqf.isDeveloperModeEnabled()) {
                zzbis2.zzA("_rcn_developer", "true");
            }
            zzbis2.zzaE(10300);
            if (this.zzcqd != null && this.zzcqd.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzcqd.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbis2.zzaG(n);
            }
            if (this.zzcqc != null && this.zzcqc.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzcqc.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbis2.zzaF(n);
            }
            zzbir zzbir2 = zzbis2.zzsq();
            zzbje zzbje2 = new zzbje(this.mContext);
            zzbin.zzaKp.zza(zzbje2.zzpg(), zzbir2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzcqg.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbit zzbit2) {
        if (zzbit2 == null || zzbit2.getStatus() == null) {
            this.zzcqf.zzcd(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzKR();
            return;
        }
        int n = zzbit2.getStatus().getStatusCode();
        this.zzcqg.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzcqf.zzcd(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzKR();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzcqf.zzcd(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbit2.getThrottleEndTimeMillis())));
                    this.zzKR();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzcqf.zzcd(-1);
                    if (this.zzcqc != null && !this.zzcqc.zzKV()) {
                        Map<String, Set<String>> map = zzbit2.zzss();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbit2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzcqc = new afx(hashMap, this.zzcqc.getTimestamp(), zzbit2.zzsr());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzKR();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbit2.zzss();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbit2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzcqc = new afx(hashMap, System.currentTimeMillis(), zzbit2.zzsr());
                    this.zzcqf.zzcd(-1);
                    taskCompletionSource.setResult(null);
                    this.zzKR();
                    return;
                }
                default: {
                    if (zzbit2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzcqf.zzcd(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzKR();
                    return;
                }
            }
        }
        finally {
            this.zzcqg.writeLock().unlock();
        }
    }
}

