/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbhc;
import com.google.android.gms.internal.zzbhe;
import com.google.android.gms.internal.zzbhg;
import com.google.android.gms.internal.zzbhl;
import com.google.android.gms.internal.zzbht;
import com.google.android.gms.internal.zzbhz;
import com.google.android.gms.internal.zzbif;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzbhk
implements zzbhc {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzaKs = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzaKt = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbhg> zza(GoogleApiClient googleApiClient, zzbhe zzbhe2) {
        if (googleApiClient == null || zzbhe2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzbax)new zzbhl(this, googleApiClient, zzbhe2));
    }

    private static Status zzaH(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbhz zzbhz2) {
        if (zzbhz2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbhz2.zzsu();
        if (dataHolder == null) {
            return null;
        }
        zzbif zzbif2 = (zzbif)((Object)new zzd(dataHolder, zzbif.CREATOR).get(0));
        zzbhz2.zzsw();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbif2.zzsy().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbif2.zzsy().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbhz zzbhz2) {
        if (zzbhz2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbhz2.zzsv();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbht.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbht)((Object)iterator.next())).getPayload());
        }
        zzbhz2.zzsx();
        return arrayList;
    }

    static /* synthetic */ Status zzaI(int n) {
        return zzbhk.zzaH(n);
    }

    static /* synthetic */ HashMap zzc(zzbhz zzbhz2) {
        return zzbhk.zza(zzbhz2);
    }
}

