/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbhd;
import com.google.android.gms.internal.zzbhf;
import com.google.android.gms.internal.zzbhh;
import com.google.android.gms.internal.zzbhm;
import com.google.android.gms.internal.zzbhu;
import com.google.android.gms.internal.zzbia;
import com.google.android.gms.internal.zzbig;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzbhl
implements zzbhd {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzaKs = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzaKt = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbhh> zza(GoogleApiClient googleApiClient, zzbhf zzbhf2) {
        if (googleApiClient == null || zzbhf2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzbay)new zzbhm(this, googleApiClient, zzbhf2));
    }

    private static Status zzaH(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbia zzbia2) {
        if (zzbia2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbia2.zzsu();
        if (dataHolder == null) {
            return null;
        }
        zzbig zzbig2 = (zzbig)((Object)new zzd(dataHolder, zzbig.CREATOR).get(0));
        zzbia2.zzsw();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbig2.zzsy().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbig2.zzsy().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbia zzbia2) {
        if (zzbia2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbia2.zzsv();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbhu.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbhu)((Object)iterator.next())).getPayload());
        }
        zzbia2.zzsx();
        return arrayList;
    }

    static /* synthetic */ Status zzaI(int n) {
        return zzbhl.zzaH(n);
    }

    static /* synthetic */ HashMap zzc(zzbia zzbia2) {
        return zzbhl.zza(zzbia2);
    }
}

