/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.internal.zzbdy;
import com.google.android.gms.internal.zzbea;
import com.google.android.gms.internal.zzbec;
import com.google.android.gms.internal.zzbeh;
import com.google.android.gms.internal.zzbep;
import com.google.android.gms.internal.zzbev;
import com.google.android.gms.internal.zzbfb;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzbeg
implements zzbdy {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzfzv = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzfzw = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbec> zza(GoogleApiClient googleApiClient, zzbea zzbea2) {
        if (googleApiClient == null || zzbea2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzm)new zzbeh(this, googleApiClient, zzbea2));
    }

    private static Status zzck(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbev zzbev2) {
        if (zzbev2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbev2.zzalz();
        if (dataHolder == null) {
            return null;
        }
        zzbfb zzbfb2 = (zzbfb)((Object)new zzd(dataHolder, zzbfb.CREATOR).get(0));
        zzbev2.zzamb();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbfb2.zzamd().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbfb2.zzamd().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbev zzbev2) {
        if (zzbev2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbev2.zzama();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbep.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbep)((Object)iterator.next())).getPayload());
        }
        zzbev2.zzamc();
        return arrayList;
    }

    static /* synthetic */ Status zzcl(int n) {
        return zzbeg.zzck(n);
    }

    static /* synthetic */ HashMap zzc(zzbev zzbev2) {
        return zzbeg.zza(zzbev2);
    }
}

