/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbea;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzbec;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzdis;
import com.google.android.gms.internal.zzebo;
import com.google.android.gms.internal.zzebp;
import com.google.android.gms.internal.zzebq;
import com.google.android.gms.internal.zzebr;
import com.google.android.gms.internal.zzebs;
import com.google.android.gms.internal.zzebt;
import com.google.android.gms.internal.zzebu;
import com.google.android.gms.internal.zzebv;
import com.google.android.gms.internal.zzebw;
import com.google.android.gms.internal.zzebx;
import com.google.android.gms.internal.zzeby;
import com.google.android.gms.internal.zzebz;
import com.google.android.gms.internal.zzeca;
import com.google.android.gms.internal.zzegq;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzmpk;
    private zzebr zzmpl;
    private zzebr zzmpm;
    private zzebr zzmpn;
    private zzebu zzmpo;
    private final Context mContext;
    private final ReadWriteLock zzmpp = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzebr zzebr2, zzebr zzebr3, zzebr zzebr4, zzebu zzebu2) {
        this.mContext = context;
        this.zzmpo = zzebu2 != null ? zzebu2 : new zzebu();
        this.zzmpo.zzck(this.zzev(this.mContext));
        if (zzebr2 != null) {
            this.zzmpl = zzebr2;
        }
        if (zzebr3 != null) {
            this.zzmpm = zzebr3;
        }
        if (zzebr4 != null) {
            this.zzmpn = zzebr4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzmpk == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzmpk == null) {
                zzebz zzebz2 = FirebaseRemoteConfig.zzew(context);
                if (zzebz2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzmpk = new FirebaseRemoteConfig(context);
                } else {
                    zzebu zzebu2;
                    zzebu zzebu3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzebr zzebr2 = FirebaseRemoteConfig.zza(zzebz2.zzmqp);
                    zzebr zzebr3 = FirebaseRemoteConfig.zza(zzebz2.zzmqq);
                    zzebr zzebr4 = FirebaseRemoteConfig.zza(zzebz2.zzmqr);
                    zzebx zzebx2 = zzebz2.zzmqs;
                    if (zzebx2 == null) {
                        zzebu3 = null;
                    } else {
                        zzebu zzebu4 = new zzebu();
                        zzebu4.zzgb(zzebx2.zzmqk);
                        zzebu4.zzck(zzebx2.zzmql);
                        zzebu4.zzcl(zzebx2.zzmqm);
                        zzebu3 = zzebu2 = zzebu4;
                    }
                    if (zzebu3 != null) {
                        zzebu2.zzai(FirebaseRemoteConfig.zza(zzebz2.zzmqt));
                    }
                    zzmpk = new FirebaseRemoteConfig(context, zzebr2, zzebr3, zzebr4, zzebu2);
                }
            }
            return zzmpk;
        }
        return zzmpk;
    }

    private final long zzev(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzebz zzew(Context context) {
        zzebz zzebz2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzegq zzegq2 = zzegq.zzh((byte[])byArray, (int)0, (int)((Object)object).length);
            zzebz2 = new zzebz();
            zzebz2.zza(zzegq2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzebz2;
    }

    private static Map<String, zzebo> zza(zzeca[] zzecaArray) {
        HashMap<String, zzebo> hashMap = new HashMap<String, zzebo>();
        if (zzecaArray == null) {
            return hashMap;
        }
        zzeca[] zzecaArray2 = zzecaArray;
        int n = zzecaArray.length;
        for (int i = 0; i < n; ++i) {
            zzeca zzeca2 = zzecaArray2[i];
            String string = zzeca2.zzjdp;
            int n2 = zzeca2.resourceId;
            long l = zzeca2.zzmqv;
            hashMap.put(string, new zzebo(n2, l));
        }
        return hashMap;
    }

    private static zzebr zza(zzebv zzebv2) {
        Object object;
        if (zzebv2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzebv2.zzmqg;
        int n = zzebv2.zzmqg.length;
        for (int i = 0; i < n; ++i) {
            zzeby zzeby2 = object2[i];
            String string = zzeby2.zzjdp;
            object = new HashMap();
            zzebw[] zzebwArray = zzeby2.zzmqo;
            int n2 = zzeby2.zzmqo.length;
            for (int j = 0; j < n2; ++j) {
                zzebw zzebw2 = zzebwArray[j];
                object.put(zzebw2.key, zzebw2.zzmqj);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzebv2.zzmqh;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzeby[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzebr(hashMap, zzebv2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzmpp.writeLock().lock();
        try {
            if (this.zzmpl == null) {
                return false;
            }
            if (this.zzmpm != null && this.zzmpm.getTimestamp() >= this.zzmpl.getTimestamp()) {
                return false;
            }
            long l = this.zzmpl.getTimestamp();
            this.zzmpm = this.zzmpl;
            this.zzmpm.setTimestamp(System.currentTimeMillis());
            this.zzmpl = new zzebr(null, l, null);
            long l2 = this.zzmpo.zzcad();
            this.zzmpo.zzcl(zzdis.zza(l2, this.zzmpm.zzalx()));
            long l3 = l2;
            List<byte[]> list = this.zzmpm.zzalx();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzo(new zzebp(context, list, l3));
            this.zzbzw();
            return true;
        }
        finally {
            this.zzmpp.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzmpp.readLock().lock();
        try {
            if (this.zzmpo != null && this.zzmpo.zzcab() != null && this.zzmpo.zzcab().get(string) != null && n == ((zzebo)(object = this.zzmpo.zzcab().get(string))).zzbzx() && this.zzmpo.zzcac() == ((zzebo)object).zzbzy()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzmpp.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzebo zzebo2 = new zzebo(n, this.zzmpo.zzcac());
            this.zzmpo.zza(string, zzebo2);
            this.zzc((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    private final void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzebt.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzebt.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzebt.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzebt.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzebt.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzebt.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzmpp.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzmpn == null || !this.zzmpn.zzqo(string)) {
                    return;
                }
                this.zzmpn.zzh(null, string);
                this.zzmpn.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzmpn == null) {
                    this.zzmpn = new zzebr(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzmpn.zzh(hashMap, string);
                this.zzmpn.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzmpo.zzqp(string);
            }
            this.zzbzw();
            return;
        }
        finally {
            this.zzmpp.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzmpp.writeLock().lock();
        try {
            boolean bl = this.zzmpo.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzmpo.zzck(bl2);
            if (bl != bl2) {
                this.zzbzw();
            }
            return;
        }
        finally {
            this.zzmpp.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzmpp.readLock().lock();
        try {
            if (this.zzmpm != null && this.zzmpm.zzbm(string, string2)) {
                byte[] byArray = this.zzmpm.zzbn(string, string2);
                return byArray;
            }
            if (this.zzmpn != null && this.zzmpn.zzbm(string, string2)) {
                byte[] byArray = this.zzmpn.zzbn(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzmpp.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzmpp.readLock().lock();
            try {
                if (this.zzmpm == null || !this.zzmpm.zzbm(string, string2)) break block5;
                String string3 = new String(this.zzmpm.zzbn(string, string2), zzebt.UTF_8);
                this.zzmpp.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzmpp.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzmpn != null && this.zzmpn.zzbm(string, string2)) {
            String string4 = new String(this.zzmpn.zzbn(string, string2), zzebt.UTF_8);
            this.zzmpp.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzmpp.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzmpp.readLock().lock();
        try {
            String string3;
            if (this.zzmpm != null && this.zzmpm.zzbm(string, string2)) {
                string3 = new String(this.zzmpm.zzbn(string, string2), zzebt.UTF_8);
                if (zzebt.zzfzv.matcher(string3).matches()) {
                    return true;
                }
                if (zzebt.zzfzw.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzmpn != null && this.zzmpn.zzbm(string, string2)) {
                string3 = new String(this.zzmpn.zzbn(string, string2), zzebt.UTF_8);
                if (zzebt.zzfzv.matcher(string3).matches()) {
                    return true;
                }
                if (zzebt.zzfzw.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzmpp.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzebt(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzmpp.readLock().lock();
        try {
            if (this.zzmpm != null && this.zzmpm.zzbm(string, string2)) {
                zzebt zzebt2 = new zzebt(this.zzmpm.zzbn(string, string2), 2);
                return zzebt2;
            }
            if (this.zzmpn != null && this.zzmpn.zzbm(string, string2)) {
                zzebt zzebt3 = new zzebt(this.zzmpn.zzbn(string, string2), 1);
                return zzebt3;
            }
            zzebt zzebt4 = new zzebt(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzebt4;
        }
        finally {
            this.zzmpp.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzebs zzebs2 = new zzebs();
        this.zzmpp.readLock().lock();
        try {
            long l = this.zzmpl == null ? -1L : this.zzmpl.getTimestamp();
            zzebs2.zzcj(l);
            zzebs2.zzgb(this.zzmpo.getLastFetchStatus());
            zzebs2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzmpo.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzmpp.readLock().unlock();
        }
        return zzebs2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzmpp.readLock().lock();
        try {
            if (this.zzmpm == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzmpm.zzbo(string, string2);
            return set;
        }
        finally {
            this.zzmpp.readLock().unlock();
        }
    }

    private static void zzo(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzbzw() {
        this.zzmpp.readLock().lock();
        try {
            FirebaseRemoteConfig.zzo(new zzebq(this.mContext, this.zzmpl, this.zzmpm, this.zzmpn, this.zzmpo));
            return;
        }
        finally {
            this.zzmpp.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzmpp.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbeb zzbeb2 = new zzbeb();
            zzbeb2.zzaa(l);
            if (this.zzmpo.isDeveloperModeEnabled()) {
                zzbeb2.zzaa("_rcn_developer", "true");
            }
            zzbeb2.zzch(10300);
            if (this.zzmpm != null && this.zzmpm.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzmpm.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbeb2.zzcj(n);
            }
            if (this.zzmpl != null && this.zzmpl.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzmpl.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbeb2.zzci(n);
            }
            zzbea zzbea2 = zzbeb2.zzalw();
            zzben zzben2 = new zzben(this.mContext);
            zzbdw.zzfzo.zza(zzben2.zzafk(), zzbea2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzmpp.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbec zzbec2) {
        if (zzbec2 == null || zzbec2.getStatus() == null) {
            this.zzmpo.zzgb(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzbzw();
            return;
        }
        int n = zzbec2.getStatus().getStatusCode();
        this.zzmpp.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzmpo.zzgb(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzbzw();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzmpo.zzgb(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbec2.getThrottleEndTimeMillis())));
                    this.zzbzw();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzmpo.zzgb(-1);
                    if (this.zzmpl != null && !this.zzmpl.zzcaa()) {
                        Map<String, Set<String>> map = zzbec2.zzaly();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbec2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzmpl = new zzebr(hashMap, this.zzmpl.getTimestamp(), zzbec2.zzalx());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzbzw();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbec2.zzaly();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbec2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzmpl = new zzebr(hashMap, System.currentTimeMillis(), zzbec2.zzalx());
                    this.zzmpo.zzgb(-1);
                    taskCompletionSource.setResult(null);
                    this.zzbzw();
                    return;
                }
                default: {
                    if (zzbec2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzmpo.zzgb(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzbzw();
                    return;
                }
            }
        }
        finally {
            this.zzmpp.writeLock().unlock();
        }
    }
}

