/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.internal.zzbeg;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbek;
import com.google.android.gms.internal.zzbep;
import com.google.android.gms.internal.zzbex;
import com.google.android.gms.internal.zzbfd;
import com.google.android.gms.internal.zzbfj;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzbeo
implements zzbeg {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzgaa = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzgab = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbek> zza(GoogleApiClient googleApiClient, zzbei zzbei2) {
        if (googleApiClient == null || zzbei2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzm)new zzbep(this, googleApiClient, zzbei2));
    }

    private static Status zzcl(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbfd zzbfd2) {
        if (zzbfd2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbfd2.zzama();
        if (dataHolder == null) {
            return null;
        }
        zzbfj zzbfj2 = (zzbfj)((Object)new zzd(dataHolder, zzbfj.CREATOR).get(0));
        zzbfd2.zzamc();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbfj2.zzame().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbfj2.zzame().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbfd zzbfd2) {
        if (zzbfd2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbfd2.zzamb();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbex.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbex)((Object)iterator.next())).getPayload());
        }
        zzbfd2.zzamd();
        return arrayList;
    }

    static /* synthetic */ Status zzcm(int n) {
        return zzbeo.zzcl(n);
    }

    static /* synthetic */ HashMap zzc(zzbfd zzbfd2) {
        return zzbeo.zza(zzbfd2);
    }
}

