/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbgd;
import com.google.android.gms.internal.zzbgh;
import com.google.android.gms.internal.zzbgi;
import com.google.android.gms.internal.zzbgj;
import com.google.android.gms.internal.zzbgu;
import com.google.android.gms.internal.zzdtm;
import com.google.android.gms.internal.zzevy;
import com.google.android.gms.internal.zzevz;
import com.google.android.gms.internal.zzewa;
import com.google.android.gms.internal.zzewb;
import com.google.android.gms.internal.zzewc;
import com.google.android.gms.internal.zzewd;
import com.google.android.gms.internal.zzewe;
import com.google.android.gms.internal.zzewf;
import com.google.android.gms.internal.zzewg;
import com.google.android.gms.internal.zzewh;
import com.google.android.gms.internal.zzewi;
import com.google.android.gms.internal.zzewj;
import com.google.android.gms.internal.zzewk;
import com.google.android.gms.internal.zzfhj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzocd;
    private zzewb zzoce;
    private zzewb zzocf;
    private zzewb zzocg;
    private zzewe zzoch;
    private final Context mContext;
    private final ReadWriteLock zzoci = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzewb zzewb2, zzewb zzewb3, zzewb zzewb4, zzewe zzewe2) {
        this.mContext = context;
        this.zzoch = zzewe2 != null ? zzewe2 : new zzewe();
        this.zzoch.zzcm(this.zzfd(this.mContext));
        if (zzewb2 != null) {
            this.zzoce = zzewb2;
        }
        if (zzewb3 != null) {
            this.zzocf = zzewb3;
        }
        if (zzewb4 != null) {
            this.zzocg = zzewb4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzocd == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzocd == null) {
                zzewj zzewj2 = FirebaseRemoteConfig.zzfe(context);
                if (zzewj2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzocd = new FirebaseRemoteConfig(context);
                } else {
                    zzewe zzewe2;
                    zzewe zzewe3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzewb zzewb2 = FirebaseRemoteConfig.zza(zzewj2.zzodi);
                    zzewb zzewb3 = FirebaseRemoteConfig.zza(zzewj2.zzodj);
                    zzewb zzewb4 = FirebaseRemoteConfig.zza(zzewj2.zzodk);
                    zzewh zzewh2 = zzewj2.zzodl;
                    if (zzewh2 == null) {
                        zzewe3 = null;
                    } else {
                        zzewe zzewe4 = new zzewe();
                        zzewe4.zzhz(zzewh2.zzodd);
                        zzewe4.zzcs(zzewh2.zzode);
                        zzewe4.zzcn(zzewh2.zzodf);
                        zzewe3 = zzewe2 = zzewe4;
                    }
                    if (zzewe3 != null) {
                        zzewe2.zzar(FirebaseRemoteConfig.zza(zzewj2.zzodm));
                    }
                    zzocd = new FirebaseRemoteConfig(context, zzewb2, zzewb3, zzewb4, zzewe2);
                }
            }
            return zzocd;
        }
        return zzocd;
    }

    private final long zzfd(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzewj zzfe(Context context) {
        zzewj zzewj2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzfhj zzfhj2 = zzfhj.zzn((byte[])byArray, (int)0, (int)((Object)object).length);
            zzewj2 = new zzewj();
            zzewj2.zza(zzfhj2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzewj2;
    }

    private static Map<String, zzevy> zza(zzewk[] zzewkArray) {
        HashMap<String, zzevy> hashMap = new HashMap<String, zzevy>();
        if (zzewkArray == null) {
            return hashMap;
        }
        zzewk[] zzewkArray2 = zzewkArray;
        int n = zzewkArray.length;
        for (int i = 0; i < n; ++i) {
            zzewk zzewk2 = zzewkArray2[i];
            String string = zzewk2.zzjox;
            int n2 = zzewk2.resourceId;
            long l = zzewk2.zzodo;
            hashMap.put(string, new zzevy(n2, l));
        }
        return hashMap;
    }

    private static zzewb zza(zzewf zzewf2) {
        Object object;
        if (zzewf2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzewf2.zzocz;
        int n = zzewf2.zzocz.length;
        for (int i = 0; i < n; ++i) {
            zzewi zzewi2 = object2[i];
            String string = zzewi2.zzjox;
            object = new HashMap();
            zzewg[] zzewgArray = zzewi2.zzodh;
            int n2 = zzewi2.zzodh.length;
            for (int j = 0; j < n2; ++j) {
                zzewg zzewg2 = zzewgArray[j];
                object.put(zzewg2.key, zzewg2.zzodc);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzewf2.zzoda;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzewi[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzewb(hashMap, zzewf2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzoci.writeLock().lock();
        try {
            if (this.zzoce == null) {
                return false;
            }
            if (this.zzocf != null && this.zzocf.getTimestamp() >= this.zzoce.getTimestamp()) {
                return false;
            }
            long l = this.zzoce.getTimestamp();
            this.zzocf = this.zzoce;
            this.zzocf.setTimestamp(System.currentTimeMillis());
            this.zzoce = new zzewb(null, l, null);
            long l2 = this.zzoch.zzcjk();
            this.zzoch.zzcn(zzdtm.zza(l2, this.zzocf.zzamq()));
            long l3 = l2;
            List<byte[]> list = this.zzocf.zzamq();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzr(new zzevz(context, list, l3));
            this.zzcje();
            return true;
        }
        finally {
            this.zzoci.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzoci.readLock().lock();
        try {
            if (this.zzoch != null && this.zzoch.zzcji() != null && this.zzoch.zzcji().get(string) != null && n == ((zzevy)(object = this.zzoch.zzcji().get(string))).getResourceId() && this.zzoch.zzcjj() == ((zzevy)object).zzcjf()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzoci.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzevy zzevy2 = new zzevy(n, this.zzoch.zzcjj());
            this.zzoch.zza(string, zzevy2);
            this.zzc((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    private final void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzewd.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzewd.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzewd.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzewd.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzewd.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzewd.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzoci.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzocg == null || !this.zzocg.zzrp(string)) {
                    return;
                }
                this.zzocg.zzi(null, string);
                this.zzocg.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzocg == null) {
                    this.zzocg = new zzewb(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzocg.zzi(hashMap, string);
                this.zzocg.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzoch.zzrq(string);
            }
            this.zzcje();
            return;
        }
        finally {
            this.zzoci.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzoci.writeLock().lock();
        try {
            boolean bl = this.zzoch.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzoch.zzcs(bl2);
            if (bl != bl2) {
                this.zzcje();
            }
            return;
        }
        finally {
            this.zzoci.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzoci.readLock().lock();
        try {
            if (this.zzocf != null && this.zzocf.zzbn(string, string2)) {
                byte[] byArray = this.zzocf.zzbo(string, string2);
                return byArray;
            }
            if (this.zzocg != null && this.zzocg.zzbn(string, string2)) {
                byte[] byArray = this.zzocg.zzbo(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzoci.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzoci.readLock().lock();
            try {
                if (this.zzocf == null || !this.zzocf.zzbn(string, string2)) break block5;
                String string3 = new String(this.zzocf.zzbo(string, string2), zzewd.UTF_8);
                this.zzoci.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzoci.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzocg != null && this.zzocg.zzbn(string, string2)) {
            String string4 = new String(this.zzocg.zzbo(string, string2), zzewd.UTF_8);
            this.zzoci.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzoci.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzoci.readLock().lock();
        try {
            String string3;
            if (this.zzocf != null && this.zzocf.zzbn(string, string2)) {
                string3 = new String(this.zzocf.zzbo(string, string2), zzewd.UTF_8);
                if (zzewd.zzgdf.matcher(string3).matches()) {
                    return true;
                }
                if (zzewd.zzgdg.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzocg != null && this.zzocg.zzbn(string, string2)) {
                string3 = new String(this.zzocg.zzbo(string, string2), zzewd.UTF_8);
                if (zzewd.zzgdf.matcher(string3).matches()) {
                    return true;
                }
                if (zzewd.zzgdg.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzoci.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzewd(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzoci.readLock().lock();
        try {
            if (this.zzocf != null && this.zzocf.zzbn(string, string2)) {
                zzewd zzewd2 = new zzewd(this.zzocf.zzbo(string, string2), 2);
                return zzewd2;
            }
            if (this.zzocg != null && this.zzocg.zzbn(string, string2)) {
                zzewd zzewd3 = new zzewd(this.zzocg.zzbo(string, string2), 1);
                return zzewd3;
            }
            zzewd zzewd4 = new zzewd(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzewd4;
        }
        finally {
            this.zzoci.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzewc zzewc2 = new zzewc();
        this.zzoci.readLock().lock();
        try {
            long l = this.zzoce == null ? -1L : this.zzoce.getTimestamp();
            zzewc2.zzcl(l);
            zzewc2.zzhz(this.zzoch.getLastFetchStatus());
            zzewc2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzoch.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzoci.readLock().unlock();
        }
        return zzewc2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzoci.readLock().lock();
        try {
            if (this.zzocf == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzocf.zzbp(string, string2);
            return set;
        }
        finally {
            this.zzoci.readLock().unlock();
        }
    }

    private static void zzr(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzcje() {
        this.zzoci.readLock().lock();
        try {
            FirebaseRemoteConfig.zzr(new zzewa(this.mContext, this.zzoce, this.zzocf, this.zzocg, this.zzoch));
            return;
        }
        finally {
            this.zzoci.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzoci.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbgi zzbgi2 = new zzbgi();
            zzbgi2.zzz(l);
            if (this.zzoch.isDeveloperModeEnabled()) {
                zzbgi2.zzx("_rcn_developer", "true");
            }
            zzbgi2.zzcl(10300);
            if (this.zzocf != null && this.zzocf.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzocf.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbgi2.zzcn(n);
            }
            if (this.zzoce != null && this.zzoce.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzoce.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbgi2.zzcm(n);
            }
            zzbgh zzbgh2 = zzbgi2.zzamp();
            zzbgu zzbgu2 = new zzbgu(this.mContext);
            zzbgd.zzgcy.zza(zzbgu2.zzagc(), zzbgh2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzoci.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbgj zzbgj2) {
        if (zzbgj2 == null || zzbgj2.getStatus() == null) {
            this.zzoch.zzhz(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzcje();
            return;
        }
        int n = zzbgj2.getStatus().getStatusCode();
        this.zzoci.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzoch.zzhz(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzcje();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzoch.zzhz(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbgj2.getThrottleEndTimeMillis())));
                    this.zzcje();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzoch.zzhz(-1);
                    if (this.zzoce != null && !this.zzoce.zzcjh()) {
                        Map<String, Set<String>> map = zzbgj2.zzamr();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbgj2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzoce = new zzewb(hashMap, this.zzoce.getTimestamp(), zzbgj2.zzamq());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzcje();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbgj2.zzamr();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbgj2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzoce = new zzewb(hashMap, System.currentTimeMillis(), zzbgj2.zzamq());
                    this.zzoch.zzhz(-1);
                    taskCompletionSource.setResult(null);
                    this.zzcje();
                    return;
                }
                default: {
                    if (zzbgj2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzoch.zzhz(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzcje();
                    return;
                }
            }
        }
        finally {
            this.zzoci.writeLock().unlock();
        }
    }
}

