/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzbl;
import com.google.android.gms.internal.firebase_remote_config.zzbr;
import com.google.android.gms.internal.firebase_remote_config.zzbs;
import com.google.android.gms.internal.firebase_remote_config.zzbw;
import com.google.android.gms.internal.firebase_remote_config.zzby;
import com.google.android.gms.internal.firebase_remote_config.zzbz;
import com.google.android.gms.internal.firebase_remote_config.zzco;
import com.google.android.gms.internal.firebase_remote_config.zzdy;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public final class zzbt {
    private static final Boolean zzes = new Boolean(true);
    private static final String zzet = new String();
    private static final Character zzeu = new Character('\u0000');
    private static final Byte zzev = new Byte(0);
    private static final Short zzew = new Short(0);
    private static final Integer zzex = new Integer(0);
    private static final Float zzey = new Float(0.0f);
    private static final Long zzez = new Long(0L);
    private static final Double zzfa = new Double(0.0);
    private static final BigInteger zzfb = new BigInteger("0");
    private static final BigDecimal zzfc = new BigDecimal("0");
    private static final zzbw zzfd = new zzbw(0L);
    private static final ConcurrentHashMap<Class<?>, Object> zzfe = new ConcurrentHashMap<Class<Boolean>, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T zzd(Class<?> clazz) {
        Object object = zzfe.get(clazz);
        if (object == null) {
            ConcurrentHashMap<Class<?>, Object> concurrentHashMap = zzfe;
            synchronized (concurrentHashMap) {
                object = zzfe.get(clazz);
                if (object == null) {
                    if (clazz.isArray()) {
                        int n = 0;
                        Class<?> clazz2 = clazz;
                        do {
                            clazz2 = clazz2.getComponentType();
                            ++n;
                        } while (clazz2.isArray());
                        object = Array.newInstance(clazz2, new int[n]);
                    } else if (clazz.isEnum()) {
                        zzbz zzbz2 = zzbr.zzc(clazz).zzae(null);
                        Object[] objectArray = new Object[]{clazz};
                        String string = "enum missing constant with @NullValue annotation: %s";
                        Object[] objectArray2 = objectArray;
                        String string2 = "enum missing constant with @NullValue annotation: %s";
                        if (zzbz2 == null) {
                            throw new NullPointerException(zzdy.zza(string2, objectArray2));
                        }
                        object = zzbz2.zzcb();
                    } else {
                        object = zzco.zzf(clazz);
                    }
                    zzfe.put(clazz, object);
                }
            }
        }
        return (T)object;
    }

    public static boolean isNull(Object object) {
        return object != null && object == zzfe.get(object.getClass());
    }

    public static Map<String, Object> zzf(Object object) {
        if (object == null || zzbt.isNull(object)) {
            return Collections.emptyMap();
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        return new zzbs(object, false);
    }

    public static <T> T clone(T t) {
        Object object;
        if (t == null || zzbt.zza(t.getClass())) {
            return t;
        }
        if (t instanceof zzby) {
            return (T)((zzby)((zzby)t).clone());
        }
        Class<?> clazz = t.getClass();
        if (clazz.isArray()) {
            object = Array.newInstance(clazz.getComponentType(), Array.getLength(t));
        } else if (t instanceof zzbl) {
            object = (zzbl)((zzbl)t).clone();
        } else {
            if ("java.util.Arrays$ArrayList".equals(clazz.getName())) {
                Object[] objectArray = ((List)t).toArray();
                zzbt.zza(objectArray, objectArray);
                return (T)Arrays.asList(objectArray);
            }
            object = zzco.zzf(clazz);
        }
        zzbt.zza(t, object);
        return (T)object;
    }

    public static void zza(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        if (!(clazz == object2.getClass())) {
            throw new IllegalArgumentException();
        }
        if (clazz.isArray()) {
            if (!(Array.getLength(object) == Array.getLength(object2))) {
                throw new IllegalArgumentException();
            }
            int n = 0;
            for (Object t : zzco.zzi(object)) {
                Array.set(object2, n++, zzbt.clone(t));
            }
            return;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)object;
            if (ArrayList.class.isAssignableFrom(clazz)) {
                ((ArrayList)object2).ensureCapacity(collection.size());
            }
            Collection collection2 = (Collection)object2;
            for (Object e : collection) {
                collection2.add(zzbt.clone(e));
            }
            return;
        }
        boolean bl = zzby.class.isAssignableFrom(clazz);
        if (bl || !Map.class.isAssignableFrom(clazz)) {
            zzbr zzbr2 = bl ? ((zzby)object).zzay : zzbr.zzc(clazz);
            for (String string : zzbr2.zzer) {
                Object object3;
                zzbz zzbz2 = zzbr2.zzae(string);
                if (zzbz2.zzca() || bl && zzbz2.isPrimitive() || (object3 = zzbz2.zzh(object)) == null) continue;
                zzbz2.zzb(object2, zzbt.clone(object3));
            }
            return;
        }
        if (zzbl.class.isAssignableFrom(clazz)) {
            zzbl zzbl2 = (zzbl)object2;
            zzbl zzbl3 = (zzbl)object;
            int n = zzbl3.size();
            for (int i = 0; i < n; ++i) {
                Object v = zzbl3.zzg(i);
                zzbl2.set(i, zzbt.clone(v));
            }
            return;
        }
        Map map = (Map)object2;
        for (Map.Entry entry : ((Map)object).entrySet()) {
            map.put((String)entry.getKey(), zzbt.clone(entry.getValue()));
        }
    }

    public static boolean zza(Type type) {
        if (type instanceof WildcardType) {
            type = zzco.zza((WildcardType)type);
        }
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        return clazz.isPrimitive() || clazz == Character.class || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == Byte.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == zzbw.class || clazz == Boolean.class;
    }

    public static boolean zzg(Object object) {
        return object == null || zzbt.zza(object.getClass());
    }

    public static Object zza(Type type, String string) {
        Class clazz;
        Class clazz2 = clazz = type instanceof Class ? (Class)type : null;
        if (type == null || clazz != null) {
            if (clazz == Void.class) {
                return null;
            }
            if (string == null || clazz == null || clazz.isAssignableFrom(String.class)) {
                return string;
            }
            if (clazz == Character.class || clazz == Character.TYPE) {
                if (string.length() != 1) {
                    String string2 = String.valueOf(clazz);
                    throw new IllegalArgumentException(new StringBuilder(37 + String.valueOf(string2).length()).append("expected type Character/char but got ").append(string2).toString());
                }
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return Boolean.valueOf(string);
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return Byte.valueOf(string);
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return Short.valueOf(string);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return Integer.valueOf(string);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return Long.valueOf(string);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return Float.valueOf(string);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return Double.valueOf(string);
            }
            if (clazz == zzbw.class) {
                return zzbw.zzaf(string);
            }
            if (clazz == BigInteger.class) {
                return new BigInteger(string);
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string);
            }
            if (clazz.isEnum()) {
                if (!zzbr.zzc(clazz).zzer.contains(string)) {
                    throw new IllegalArgumentException(String.format("given enum name %s not part of enumeration", string));
                }
                return zzbr.zzc(clazz).zzae(string).zzcb();
            }
        }
        String string3 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(string3).length()).append("expected primitive class, but got: ").append(string3).toString());
    }

    public static Collection<Object> zzb(Type type) {
        Class clazz;
        if (type instanceof WildcardType) {
            type = zzco.zza((WildcardType)type);
        }
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        Class clazz2 = clazz = type instanceof Class ? (Class)type : null;
        if (type == null || type instanceof GenericArrayType || clazz != null && (clazz.isArray() || clazz.isAssignableFrom(ArrayList.class))) {
            return new ArrayList<Object>();
        }
        if (clazz == null) {
            String string = String.valueOf(type);
            throw new IllegalArgumentException(new StringBuilder(39 + String.valueOf(string).length()).append("unable to create new instance of type: ").append(string).toString());
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<Object>();
        }
        if (clazz.isAssignableFrom(TreeSet.class)) {
            return new TreeSet<Object>();
        }
        return (Collection)zzco.zzf(clazz);
    }

    public static Map<String, Object> zze(Class<?> clazz) {
        if (clazz == null || clazz.isAssignableFrom(zzbl.class)) {
            return new zzbl<String, Object>();
        }
        if (clazz.isAssignableFrom(TreeMap.class)) {
            return new TreeMap<String, Object>();
        }
        return (Map)zzco.zzf(clazz);
    }

    public static Type zza(List<Type> list, Type type) {
        if (type instanceof WildcardType) {
            type = zzco.zza((WildcardType)type);
        }
        while (type instanceof TypeVariable) {
            Type type2 = zzco.zza(list, (TypeVariable)type);
            if (type2 != null) {
                type = type2;
            }
            if (!(type instanceof TypeVariable)) continue;
            type = ((TypeVariable)type).getBounds()[0];
        }
        return type;
    }

    static {
        zzfe.put(Boolean.class, zzes);
        zzfe.put(String.class, zzet);
        zzfe.put(Character.class, zzeu);
        zzfe.put(Byte.class, zzev);
        zzfe.put(Short.class, zzew);
        zzfe.put(Integer.class, zzex);
        zzfe.put(Float.class, zzey);
        zzfe.put(Long.class, zzez);
        zzfe.put(Double.class, zzfa);
        zzfe.put(BigInteger.class, zzfb);
        zzfe.put(BigDecimal.class, zzfc);
        zzfe.put(zzbw.class, zzfd);
    }
}

