/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class zzbw
implements Serializable {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Pattern zzfo = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})([Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?)?([Zz]|([+-])(\\d{2}):(\\d{2}))?");
    private final long value;
    private final boolean zzfp;
    private final int zzfq;

    public zzbw(long l) {
        this(false, 0L, null);
    }

    private zzbw(boolean bl, long l, Integer n) {
        this.zzfp = bl;
        this.value = l;
        this.zzfq = bl ? 0 : (n == null ? TimeZone.getDefault().getOffset(l) / 60000 : n);
    }

    public final String zzbx() {
        StringBuilder stringBuilder = new StringBuilder();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT);
        long l = this.value + (long)this.zzfq * 60000L;
        gregorianCalendar.setTimeInMillis(l);
        zzbw.zza(stringBuilder, gregorianCalendar.get(1), 4);
        stringBuilder.append('-');
        zzbw.zza(stringBuilder, gregorianCalendar.get(2) + 1, 2);
        stringBuilder.append('-');
        zzbw.zza(stringBuilder, gregorianCalendar.get(5), 2);
        if (!this.zzfp) {
            stringBuilder.append('T');
            zzbw.zza(stringBuilder, gregorianCalendar.get(11), 2);
            stringBuilder.append(':');
            zzbw.zza(stringBuilder, gregorianCalendar.get(12), 2);
            stringBuilder.append(':');
            zzbw.zza(stringBuilder, gregorianCalendar.get(13), 2);
            if (gregorianCalendar.isSet(14)) {
                stringBuilder.append('.');
                zzbw.zza(stringBuilder, gregorianCalendar.get(14), 3);
            }
            if (this.zzfq == 0) {
                stringBuilder.append('Z');
            } else {
                int n = this.zzfq;
                if (this.zzfq > 0) {
                    stringBuilder.append('+');
                } else {
                    stringBuilder.append('-');
                    n = -n;
                }
                int n2 = n / 60;
                int n3 = n % 60;
                zzbw.zza(stringBuilder, n2, 2);
                stringBuilder.append(':');
                zzbw.zza(stringBuilder, n3, 2);
            }
        }
        return stringBuilder.toString();
    }

    public final String toString() {
        return this.zzbx();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzbw)) {
            return false;
        }
        zzbw zzbw2 = (zzbw)object;
        return this.zzfp == zzbw2.zzfp && this.value == zzbw2.value && this.zzfq == zzbw2.zzfq;
    }

    public final int hashCode() {
        return Arrays.hashCode(new long[]{this.value, this.zzfp ? 1L : 0L, this.zzfq});
    }

    public static zzbw zzaf(String string) throws NumberFormatException {
        Matcher matcher = zzfo.matcher(string);
        if (!matcher.matches()) {
            String string2 = String.valueOf(string);
            throw new NumberFormatException(string2.length() != 0 ? "Invalid date/time format: ".concat(string2) : new String("Invalid date/time format: "));
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2)) - 1;
        int n3 = Integer.parseInt(matcher.group(3));
        boolean bl = matcher.group(4) != null;
        String string3 = matcher.group(9);
        boolean bl2 = string3 != null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Integer n8 = null;
        if (bl2 && !bl) {
            String string4 = String.valueOf(string);
            throw new NumberFormatException(string4.length() != 0 ? "Invalid date/time format, cannot specify time zone shift without specifying time: ".concat(string4) : new String("Invalid date/time format, cannot specify time zone shift without specifying time: "));
        }
        if (bl) {
            n4 = Integer.parseInt(matcher.group(5));
            n5 = Integer.parseInt(matcher.group(6));
            n6 = Integer.parseInt(matcher.group(7));
            if (matcher.group(8) != null) {
                n7 = Integer.parseInt(matcher.group(8).substring(1));
                int n9 = matcher.group(8).substring(1).length() - 3;
                n7 = (int)((double)n7 / Math.pow(10.0, n9));
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT);
        gregorianCalendar.set(n, n2, n3, n4, n5, n6);
        gregorianCalendar.set(14, n7);
        long l = gregorianCalendar.getTimeInMillis();
        if (bl && bl2) {
            int n10;
            if (Character.toUpperCase(string3.charAt(0)) == 'Z') {
                n10 = 0;
            } else {
                n10 = Integer.parseInt(matcher.group(11)) * 60 + Integer.parseInt(matcher.group(12));
                if (matcher.group(10).charAt(0) == '-') {
                    n10 = -n10;
                }
                l -= (long)n10 * 60000L;
            }
            n8 = n10;
        }
        return new zzbw(!bl, l, n8);
    }

    private static void zza(StringBuilder stringBuilder, int n, int n2) {
        if (n < 0) {
            stringBuilder.append('-');
            n = -n;
        }
        int n3 = n;
        while (n3 > 0) {
            n3 /= 10;
            --n2;
        }
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append('0');
        }
        if (n != 0) {
            stringBuilder.append(n);
        }
    }
}

