/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.format.DateUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase_remote_config.zzaf;
import com.google.android.gms.internal.firebase_remote_config.zzby;
import com.google.android.gms.internal.firebase_remote_config.zzcy;
import com.google.android.gms.internal.firebase_remote_config.zzcz;
import com.google.android.gms.internal.firebase_remote_config.zzda;
import com.google.android.gms.internal.firebase_remote_config.zzdc;
import com.google.android.gms.internal.firebase_remote_config.zzdd;
import com.google.android.gms.internal.firebase_remote_config.zzdf;
import com.google.android.gms.internal.firebase_remote_config.zzdg;
import com.google.android.gms.internal.firebase_remote_config.zzei;
import com.google.android.gms.internal.firebase_remote_config.zzen;
import com.google.android.gms.internal.firebase_remote_config.zzep;
import com.google.android.gms.internal.firebase_remote_config.zzer;
import com.google.android.gms.internal.firebase_remote_config.zzet;
import com.google.android.gms.internal.firebase_remote_config.zzeu;
import com.google.android.gms.internal.firebase_remote_config.zzev;
import com.google.android.gms.internal.firebase_remote_config.zzw;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigClientException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigServerException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;

public final class zzes {
    public static final long zzla = TimeUnit.HOURS.toSeconds(12L);
    @VisibleForTesting
    private static final int[] zzlb = new int[]{2, 4, 8, 16, 32, 64, 128, 256};
    private final Context zzja;
    private final FirebaseInstanceId zzjy;
    @Nullable
    private final AnalyticsConnector zzjz;
    private final String namespace;
    private final Executor executor;
    private final Clock zzlc;
    private final Random zzld;
    private final zzei zzjd;
    private final zzcy zzle;
    private final zzev zzji;
    private final String appId;
    private final String zzlf;
    private static final Pattern zzlg = Pattern.compile("^[^:]+:([0-9]+):(android|ios|web):([0-9a-f]+)");

    public zzes(Context context, String string, FirebaseInstanceId firebaseInstanceId, @Nullable AnalyticsConnector analyticsConnector, String string2, Executor executor, Clock clock, Random random, zzei zzei2, zzcy zzcy2, zzev zzev2) {
        this.zzja = context;
        this.appId = string;
        this.zzjy = firebaseInstanceId;
        this.zzjz = analyticsConnector;
        this.namespace = string2;
        this.executor = executor;
        this.zzlc = clock;
        this.zzld = random;
        this.zzjd = zzei2;
        this.zzle = zzcy2;
        this.zzji = zzev2;
        String string3 = string;
        Matcher matcher = zzlg.matcher(string3);
        this.zzlf = matcher.matches() ? matcher.group(1) : null;
    }

    public final Task<zzet> zza(boolean bl) {
        return this.zza(bl, this.zzji.getMinimumFetchIntervalInSeconds());
    }

    public final Task<zzet> zza(boolean bl, long l) {
        return this.zzjd.zzcp().continueWithTask(this.executor, (Continuation)new zzer(this, bl, l));
    }

    private final Task<zzet> zzb(Date date) {
        try {
            zzdf zzdf2;
            zzdf zzdf3 = zzdf2 = this.zzc(date);
            if (!(zzdf2.getState() == null || !zzdf3.getState().equals("NO_CHANGE"))) {
                return Tasks.forResult((Object)zzet.zzd(date));
            }
            zzen zzen2 = zzes.zza(zzdf2, date);
            return this.zzjd.zzc(zzen2).onSuccessTask(this.executor, zzeu.zzjk);
        }
        catch (FirebaseRemoteConfigException firebaseRemoteConfigException) {
            return Tasks.forException((Exception)((Object)firebaseRemoteConfigException));
        }
    }

    @WorkerThread
    private final zzdf zzc(Date date) throws FirebaseRemoteConfigException {
        zzdg zzdg2 = this.zzcw();
        try {
            Object object = this.zzle;
            object = new zzda((zzcy)object);
            zzdc zzdc2 = new zzcz((zzda)object).zza(this.zzlf, this.namespace, zzdg2);
            zzw zzw2 = zzdc2.zzg();
            zzw2.zzr(this.zzji.zzcz());
            ((zzby)zzw2).zzb("X-Android-Package", this.zzja.getPackageName());
            ((zzby)zzw2).zzb("X-Android-Cert", zzes.zza(this.zzja, this.zzja.getPackageName()));
            zzdf zzdf2 = (zzdf)zzdc2.zzi();
            this.zzji.zzbd(zzdc2.zzh().zzq());
            this.zzji.zza(0, zzev.zzlj);
            return zzdf2;
        }
        catch (zzaf zzaf2) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Fetch failed! Server responded with an error.", (Throwable)zzaf2);
            Object object = date;
            int n = zzaf2.getStatusCode();
            zzes zzes2 = this;
            if (n == 429 || n == 503 || n == 504) {
                Date date2 = object;
                zzes zzes3 = zzes2;
                int n2 = zzes3.zzji.zzda().zzdd();
                int n3 = ++n2;
                zzes zzes4 = zzes3;
                long l = TimeUnit.MINUTES.toMillis(zzlb[Math.min(n3, zzlb.length) - 1]);
                long l2 = l / 2L + (long)zzes4.zzld.nextInt((int)l);
                Date date3 = new Date(date2.getTime() + l2);
                zzes3.zzji.zza(n2, date3);
            }
            int n4 = zzaf2.getStatusCode();
            switch (n4) {
                case 401: {
                    object = "The request did not have the required credentials. Please make sure your google-services.json is valid.";
                    break;
                }
                case 403: {
                    object = "The user is not authorized to access the project. Please make sure you are using the API key that corresponds to your Firebase project.";
                    break;
                }
                case 500: {
                    object = "There was an internal server error.";
                    break;
                }
                case 429: {
                    object = "You have reached the throttle limit for your project. Please wait before making more requests.";
                    break;
                }
                case 503: 
                case 504: {
                    object = "The server is unavailable. Please try again later.";
                    break;
                }
                default: {
                    object = "The server returned an unexpected error.";
                }
            }
            throw new FirebaseRemoteConfigServerException(n4, String.format("Fetch failed: %s", object));
        }
        catch (IOException iOException) {
            throw new FirebaseRemoteConfigClientException("Fetch failed due to an unexpected error! Check logs for details.", iOException);
        }
    }

    private static String zza(Context context, String string) {
        try {
            byte[] byArray = AndroidUtilsLight.getPackageCertificateHashBytes((Context)context, (String)string);
            if (byArray == null) {
                String string2 = String.valueOf(string);
                Log.e((String)"FirebaseRemoteConfig", (String)(string2.length() != 0 ? "Could not get fingerprint hash for package: ".concat(string2) : new String("Could not get fingerprint hash for package: ")));
                return null;
            }
            return Hex.bytesToStringUppercase((byte[])byArray, (boolean)false);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string);
            Log.e((String)"FirebaseRemoteConfig", (String)(string3.length() != 0 ? "No such package: ".concat(string3) : new String("No such package: ")), (Throwable)nameNotFoundException);
            return null;
        }
    }

    private static zzen zza(zzdf zzdf2, Date date) throws FirebaseRemoteConfigClientException {
        try {
            List<zzdd> list;
            zzep zzep2 = zzen.zzct().zza(date);
            Map<String, String> map = zzdf2.getEntries();
            if (map != null) {
                zzep2.zzd(map);
            }
            if ((list = zzdf2.zzcf()) != null) {
                zzep2.zzb(list);
            }
            return zzep2.zzcv();
        }
        catch (JSONException jSONException) {
            throw new FirebaseRemoteConfigClientException("Fetch failed: fetch response could not be parsed.", jSONException);
        }
    }

    @VisibleForTesting
    @WorkerThread
    private final zzdg zzcw() throws FirebaseRemoteConfigClientException {
        String string = this.zzjy.getId();
        if (string == null) {
            throw new FirebaseRemoteConfigClientException("Fetch request could not be created: Firebase instance id is null.");
        }
        String string2 = this.zzjy.getToken();
        zzdg zzdg2 = new zzdg();
        zzdg2.zzas(string);
        if (string2 != null) {
            zzdg2.zzat(string2);
        }
        zzdg2.zzar(this.appId);
        Locale locale = this.zzja.getResources().getConfiguration().locale;
        zzdg2.zzav(locale.getCountry());
        zzdg2.zzaw(locale.toString());
        zzdg2.zzay(Integer.toString(Build.VERSION.SDK_INT));
        zzdg2.zzba(TimeZone.getDefault().getID());
        try {
            PackageInfo packageInfo = this.zzja.getPackageManager().getPackageInfo(this.zzja.getPackageName(), 0);
            if (packageInfo != null) {
                zzdg2.zzau(packageInfo.versionName);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        zzdg2.zzax(this.zzja.getPackageName());
        zzdg2.zzaz("17.0.0");
        zzes zzes2 = this;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (zzes2.zzjz != null) {
            for (Map.Entry entry : zzes2.zzjz.getUserProperties(false).entrySet()) {
                hashMap.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        zzdg2.zza(hashMap);
        return zzdg2;
    }

    static final /* synthetic */ Task zzf(zzen zzen2) throws Exception {
        return Tasks.forResult((Object)zzet.zzg(zzen2));
    }

    final /* synthetic */ Task zza(boolean bl, long l, Task task) throws Exception {
        Date date;
        Date date2;
        Date date3;
        long l2 = l;
        boolean bl2 = bl;
        Task task2 = task;
        zzes zzes2 = this;
        Date date4 = new Date(zzes2.zzlc.currentTimeMillis());
        if (task2.isSuccessful()) {
            boolean bl3;
            boolean bl4 = bl2;
            Date date5 = date4;
            long l3 = l2;
            zzes zzes3 = zzes2;
            if (bl4) {
                bl3 = false;
            } else {
                Date date6 = zzes3.zzji.zzcy();
                if (date6.equals(zzev.zzli)) {
                    bl3 = false;
                } else {
                    Date date7 = new Date(date6.getTime() + TimeUnit.SECONDS.toMillis(l3));
                    bl3 = date5.before(date7);
                }
            }
            if (bl3) {
                return Tasks.forResult((Object)zzet.zze(date4));
            }
        }
        if ((date3 = (date2 = date4).before(date = zzes2.zzji.zzda().zzde()) ? date : null) != null) {
            long l4 = date3.getTime() - date4.getTime();
            return Tasks.forException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(String.format("Fetch is throttled. Please wait before calling fetch again: %s", DateUtils.formatElapsedTime((long)TimeUnit.MILLISECONDS.toSeconds(l4))), date3.getTime())));
        }
        return zzes2.zzb(date4);
    }
}

