/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.internal.firebase_remote_config.zzes;
import com.google.android.gms.internal.firebase_remote_config.zzey;
import com.google.android.gms.internal.firebase_remote_config.zzfb;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import java.util.Date;

public final class zzev {
    @VisibleForTesting
    static final Date zzli = new Date(-1L);
    @VisibleForTesting
    static final Date zzlj = new Date(-1L);
    private final SharedPreferences zzlk;
    private final Object zzll;
    private final Object zzlm;

    public zzev(SharedPreferences sharedPreferences) {
        this.zzlk = sharedPreferences;
        this.zzll = new Object();
        this.zzlm = new Object();
    }

    public final boolean isDeveloperModeEnabled() {
        return this.zzlk.getBoolean("is_developer_mode_enabled", false);
    }

    public final long getFetchTimeoutInSeconds() {
        return this.zzlk.getLong("fetch_timeout_in_seconds", 5L);
    }

    public final long getMinimumFetchIntervalInSeconds() {
        return this.zzlk.getLong("minimum_fetch_interval_in_seconds", zzes.zzla);
    }

    final Date zzcy() {
        return new Date(this.zzlk.getLong("last_fetch_time_in_millis", -1L));
    }

    @Nullable
    final String zzcz() {
        return this.zzlk.getString("last_fetch_etag", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzm(int n) {
        Object object = this.zzll;
        synchronized (object) {
            this.zzlk.edit().putInt("last_fetch_status", n).apply();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzf(Date date) {
        Object object = this.zzll;
        synchronized (object) {
            this.zzlk.edit().putLong("last_fetch_time_in_millis", date.getTime()).apply();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FirebaseRemoteConfigInfo getInfo() {
        Object object = this.zzll;
        synchronized (object) {
            long l = this.zzlk.getLong("last_fetch_time_in_millis", -1L);
            int n = this.zzlk.getInt("last_fetch_status", 0);
            FirebaseRemoteConfigSettings firebaseRemoteConfigSettings = new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzlk.getBoolean("is_developer_mode_enabled", false)).setFetchTimeoutInSeconds(this.zzlk.getLong("fetch_timeout_in_seconds", 5L)).setMinimumFetchIntervalInSeconds(this.zzlk.getLong("minimum_fetch_interval_in_seconds", zzes.zzla)).build();
            return new zzfb(null).zzn(n).zzc(l).zzc(firebaseRemoteConfigSettings).zzdf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void clear() {
        Object object = this.zzll;
        synchronized (object) {
            this.zzlk.edit().clear().commit();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        Object object = this.zzll;
        synchronized (object) {
            this.zzlk.edit().putBoolean("is_developer_mode_enabled", firebaseRemoteConfigSettings.isDeveloperModeEnabled()).putLong("fetch_timeout_in_seconds", firebaseRemoteConfigSettings.getFetchTimeoutInSeconds()).putLong("minimum_fetch_interval_in_seconds", firebaseRemoteConfigSettings.getMinimumFetchIntervalInSeconds()).commit();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        Object object = this.zzll;
        synchronized (object) {
            this.zzlk.edit().putBoolean("is_developer_mode_enabled", firebaseRemoteConfigSettings.isDeveloperModeEnabled()).putLong("fetch_timeout_in_seconds", firebaseRemoteConfigSettings.getFetchTimeoutInSeconds()).putLong("minimum_fetch_interval_in_seconds", firebaseRemoteConfigSettings.getMinimumFetchIntervalInSeconds()).apply();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzbd(String string) {
        Object object = this.zzll;
        synchronized (object) {
            this.zzlk.edit().putString("last_fetch_etag", string).apply();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final zzey zzda() {
        Object object = this.zzlm;
        synchronized (object) {
            return new zzey(this.zzlk.getInt("num_failed_fetches", 0), new Date(this.zzlk.getLong("backoff_end_time_in_millis", -1L)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zza(int n, Date date) {
        Object object = this.zzlm;
        synchronized (object) {
            this.zzlk.edit().putInt("num_failed_fetches", n).putLong("backoff_end_time_in_millis", date.getTime()).apply();
            return;
        }
    }
}

