/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.internal.firebase_remote_config.zzdd;
import com.google.android.gms.internal.firebase_remote_config.zzei;
import com.google.android.gms.internal.firebase_remote_config.zzen;
import com.google.android.gms.internal.firebase_remote_config.zzep;
import com.google.android.gms.internal.firebase_remote_config.zzff;
import com.google.android.gms.internal.firebase_remote_config.zzfg;
import com.google.android.gms.internal.firebase_remote_config.zzfi;
import com.google.android.gms.internal.firebase_remote_config.zzfx;
import com.google.android.gms.internal.firebase_remote_config.zzgg;
import com.google.android.gms.internal.firebase_remote_config.zzhq;
import com.google.android.gms.internal.firebase_remote_config.zzkt;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

public final class zzfd {
    private static final Charset zzlz = Charset.forName("UTF-8");
    @VisibleForTesting
    private static final ThreadLocal<DateFormat> zzma = new zzfg();
    private final Context zzja;
    private final String appId;
    private final SharedPreferences zzmb;

    public zzfd(Context context, String string) {
        this.zzja = context;
        this.appId = string;
        this.zzmb = context.getSharedPreferences("com.google.firebase.remoteconfig_legacy_settings", 0);
    }

    @WorkerThread
    public final boolean zzdg() {
        if (this.zzmb.getBoolean("save_legacy_configs", true)) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            zzfd zzfd2 = this;
            Object object6 = zzfd2.zzdh();
            HashMap hashMap = new HashMap();
            if (object6 != null) {
                Map<String, zzen> object7 = zzfd2.zza(((zzfi.zze)object6).zzdu());
                object5 = zzfd2.zza(((zzfi.zze)object6).zzdt());
                object4 = zzfd2.zza(((zzfi.zze)object6).zzdv());
                object3 = new HashSet<String>();
                object3.addAll(object7.keySet());
                object3.addAll(object5.keySet());
                object3.addAll(object4.keySet());
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    zzff zzff2 = new zzff(null);
                    if (object7.containsKey(object)) {
                        zzff.zza(zzff2, object7.get(object));
                    }
                    if (object5.containsKey(object)) {
                        zzff.zzb(zzff2, (zzen)object5.get(object));
                    }
                    if (object4.containsKey(object)) {
                        zzff.zzc(zzff2, (zzen)object4.get(object));
                    }
                    hashMap.put(object, zzff2);
                }
            }
            object6 = hashMap;
            zzfd2 = this;
            for (Map.Entry entry : object6.entrySet()) {
                object5 = (String)entry.getKey();
                object4 = (zzff)entry.getValue();
                object3 = zzfd2.zzd((String)object5, "fetch");
                object2 = zzfd2.zzd((String)object5, "activate");
                object = zzfd2.zzd((String)object5, "defaults");
                if (zzff.zza((zzff)object4) != null) {
                    ((zzei)object3).zzc(zzff.zza((zzff)object4));
                }
                if (zzff.zzb((zzff)object4) != null) {
                    ((zzei)object2).zzc(zzff.zzb((zzff)object4));
                }
                if (zzff.zzc((zzff)object4) == null) continue;
                ((zzei)object).zzc(zzff.zzc((zzff)object4));
            }
            this.zzmb.edit().putBoolean("save_legacy_configs", false).commit();
            return true;
        }
        return false;
    }

    private final Map<String, zzen> zza(zzfi.zza zza2) {
        HashMap<String, zzen> hashMap = new HashMap<String, zzen>();
        Date date = new Date(zza2.getTimestamp());
        List<zzfx> list = zza2.zzdl();
        Cloneable cloneable = new ArrayList<zzdd>();
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            zzkt.zzb zzb2 = zzfd.zza(iterator.next());
            if (zzb2 == null) continue;
            zzkt.zzb zzb3 = zzb2;
            zzdd zzdd2 = new zzdd();
            zzdd2.zzan(zzb3.zzjm());
            zzdd2.zzaq(zzb3.zzjn());
            zzdd2.zzao(zzma.get().format(new Date(zzb3.zzjo())));
            zzdd2.zzap(zzb3.zzjp());
            zzdd2.zzb(zzb3.zzjq());
            zzdd2.zza(zzb3.zzjr());
            ((ArrayList)cloneable).add((zzdd)zzdd2);
        }
        ArrayList<zzdd> arrayList = cloneable;
        for (zzfi.zzd zzd2 : zza2.zzdk()) {
            String string = zzd2.getNamespace();
            if (string.startsWith("configns:")) {
                string = string.substring(9);
            }
            zzep zzep2 = zzen.zzct();
            List<zzfi.zzb> list2 = zzd2.zzdr();
            cloneable = new HashMap();
            for (zzfi.zzb zzb4 : list2) {
                cloneable.put(zzb4.getKey(), zzb4.zzdo().zzb(zzlz));
            }
            zzep zzep3 = zzep2.zzd((Map<String, String>)((Object)cloneable)).zza(date);
            if (string.equals("firebase")) {
                zzep3.zzb(arrayList);
            }
            try {
                hashMap.put(string, zzep3.zzcv());
            }
            catch (JSONException jSONException) {
                Log.i((String)"FirebaseRemoteConfig", (String)"A set of legacy configs could not be converted.");
            }
        }
        return hashMap;
    }

    @Nullable
    private static zzkt.zzb zza(zzfx zzfx2) {
        try {
            zzgg zzgg2 = (zzgg)zzfx2.iterator();
            byte[] byArray = new byte[zzfx2.size()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (Byte)zzgg2.next();
            }
            return zzkt.zzb.zzg(byArray);
        }
        catch (zzhq zzhq2) {
            Log.i((String)"FirebaseRemoteConfig", (String)"Payload was not defined or could not be deserialized.", (Throwable)zzhq2);
            return null;
        }
    }

    @WorkerThread
    private final zzfi.zze zzdh() {
        zzfi.zze zze2;
        if (this.zzja == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = this.zzja.openFileInput("persisted_config");
            zze2 = zzfi.zze.zzb(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zze2;
    }

    private final zzei zzd(String string, String string2) {
        return RemoteConfigComponent.zza(this.zzja, this.appId, string, string2);
    }
}

