/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzab;
import com.google.android.gms.internal.firebase_remote_config.zzag;
import com.google.android.gms.internal.firebase_remote_config.zzai;
import com.google.android.gms.internal.firebase_remote_config.zzbo;
import com.google.android.gms.internal.firebase_remote_config.zzce;
import com.google.android.gms.internal.firebase_remote_config.zzcl;
import com.google.android.gms.internal.firebase_remote_config.zzdt;
import com.google.android.gms.internal.firebase_remote_config.zzw;
import com.google.android.gms.internal.firebase_remote_config.zzy;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public final class zzac {
    private InputStream zzbr;
    private final String zzbs;
    private final String zzbt;
    private final zzy zzag;
    private zzai zzbu;
    private final int statusCode;
    private final String zzbv;
    private final zzab zzbw;
    private int zzbf;
    private boolean zzbg;
    private boolean zzbx;

    zzac(zzab zzab2, zzai zzai2) throws IOException {
        String string;
        String string2;
        this.zzbw = zzab2;
        this.zzbf = zzab2.zzv();
        this.zzbg = zzab2.zzw();
        this.zzbu = zzai2;
        this.zzbs = zzai2.getContentEncoding();
        int n = zzai2.getStatusCode();
        this.statusCode = n < 0 ? 0 : n;
        this.zzbv = string2 = zzai2.getReasonPhrase();
        Logger logger = com.google.android.gms.internal.firebase_remote_config.zzag.zzbz;
        boolean bl = this.zzbg && logger.isLoggable(Level.CONFIG);
        StringBuilder stringBuilder = null;
        if (bl) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("-------------- RESPONSE --------------").append(zzcl.zzgg);
            string = zzai2.zzag();
            if (string != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(this.statusCode);
                if (string2 != null) {
                    stringBuilder.append(' ').append(string2);
                }
            }
            stringBuilder.append(zzcl.zzgg);
        }
        zzab2.zzy().zza(zzai2, bl ? stringBuilder : null);
        string = zzai2.getContentType();
        if (string == null) {
            string = zzab2.zzy().getContentType();
        }
        this.zzbt = string;
        zzy zzy2 = this.zzag = string == null ? null : new zzy(string);
        if (bl) {
            logger.logp(Level.CONFIG, "com.google.api.client.http.HttpResponse", "<init>", stringBuilder.toString());
        }
    }

    public final String getContentType() {
        return this.zzbt;
    }

    public final zzw zzx() {
        return this.zzbw.zzy();
    }

    public final boolean zzad() {
        int n = this.statusCode;
        return n >= 200 && n < 300;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getStatusMessage() {
        return this.zzbv;
    }

    public final InputStream getContent() throws IOException {
        if (!this.zzbx) {
            InputStream inputStream = this.zzbu.getContent();
            if (inputStream != null) {
                try {
                    String string = this.zzbs;
                    if (string != null && string.contains("gzip")) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    Logger logger = com.google.android.gms.internal.firebase_remote_config.zzag.zzbz;
                    if (this.zzbg && logger.isLoggable(Level.CONFIG)) {
                        inputStream = new zzce(inputStream, logger, Level.CONFIG, this.zzbf);
                    }
                    this.zzbr = inputStream;
                }
                catch (EOFException eOFException) {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
            }
            this.zzbx = true;
        }
        return this.zzbr;
    }

    public final void ignore() throws IOException {
        InputStream inputStream = this.getContent();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public final void disconnect() throws IOException {
        this.ignore();
        this.zzbu.disconnect();
    }

    public final <T> T zza(Class<T> clazz) throws IOException {
        boolean bl;
        zzac zzac2 = this;
        int n = zzac2.statusCode;
        if (zzac2.zzbw.getRequestMethod().equals("HEAD") || n / 100 == 1 || n == 204 || n == 304) {
            zzac2.ignore();
            bl = false;
        } else {
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return this.zzbw.zzaa().zza(this.getContent(), this.zzaf(), clazz);
    }

    public final String zzae() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = this.getContent();
        if (inputStream == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
        InputStream inputStream2 = inputStream;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream4 = byteArrayOutputStream3;
            InputStream inputStream3 = inputStream2;
            zzdt.checkNotNull(inputStream3);
            zzdt.checkNotNull(byteArrayOutputStream4);
            byte[] byArray = new byte[4096];
            while ((n = inputStream3.read(byArray)) != -1) {
                ((OutputStream)byteArrayOutputStream4).write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            inputStream2.close();
            throw throwable;
        }
        inputStream2.close();
        return byteArrayOutputStream.toString(this.zzaf().name());
    }

    private final Charset zzaf() {
        if (this.zzag == null || this.zzag.zzr() == null) {
            return zzbo.ISO_8859_1;
        }
        return this.zzag.zzr();
    }
}

