/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzew;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;

public final class zzfe
implements FirebaseRemoteConfigValue {
    private final String value;
    private final int zzmc;

    zzfe(String string, int n) {
        this.value = string;
        this.zzmc = n;
    }

    @Override
    public final long asLong() {
        if (this.zzmc == 0) {
            return 0L;
        }
        String string = this.asString().trim();
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("[Value: %s] cannot be converted to a %s.", string, "long"), numberFormatException);
        }
    }

    @Override
    public final double asDouble() {
        if (this.zzmc == 0) {
            return 0.0;
        }
        String string = this.asString().trim();
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("[Value: %s] cannot be converted to a %s.", string, "double"), numberFormatException);
        }
    }

    @Override
    public final String asString() {
        if (this.zzmc == 0) {
            return "";
        }
        if (this.value == null) {
            throw new IllegalArgumentException("Value is null, and cannot be converted to the desired type.");
        }
        return this.value;
    }

    @Override
    public final byte[] asByteArray() {
        if (this.zzmc == 0) {
            return FirebaseRemoteConfig.DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        return this.value.getBytes(zzew.zzln);
    }

    @Override
    public final boolean asBoolean() throws IllegalArgumentException {
        if (this.zzmc == 0) {
            return false;
        }
        String string = this.asString().trim();
        if (zzew.zzlo.matcher(string).matches()) {
            return true;
        }
        if (zzew.zzlp.matcher(string).matches()) {
            return false;
        }
        throw new IllegalArgumentException(String.format("[Value: %s] cannot be converted to a %s.", string, "boolean"));
    }

    @Override
    public final int getSource() {
        return this.zzmc;
    }
}

