/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzfr;
import com.google.android.gms.internal.firebase_remote_config.zzhm;
import com.google.android.gms.internal.firebase_remote_config.zzhn;
import com.google.android.gms.internal.firebase_remote_config.zzjc;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgt
extends zzfr<Double>
implements zzhn<Double>,
zzjc,
RandomAccess {
    private static final zzgt zzpx = new zzgt(new double[0], 0);
    private double[] zzpy;
    private int size;

    zzgt() {
        this(new double[10], 0);
    }

    private zzgt(double[] dArray, int n) {
        this.zzpy = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzet();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzpy, n2, this.zzpy, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgt)) {
            return super.equals(object);
        }
        zzgt zzgt2 = (zzgt)object;
        if (this.size != zzgt2.size) {
            return false;
        }
        double[] dArray = zzgt2.zzpy;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzpy[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzpy[i]);
            n = n * 31 + zzhm.zzo(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zze(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzet();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
        if (this.size < this.zzpy.length) {
            System.arraycopy(this.zzpy, n, this.zzpy, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzpy, 0, dArray, 0, n);
            System.arraycopy(this.zzpy, n, dArray, n + 1, this.size - n);
            this.zzpy = dArray;
        }
        this.zzpy[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzet();
        zzhm.checkNotNull(collection);
        if (!(collection instanceof zzgt)) {
            return super.addAll(collection);
        }
        zzgt zzgt2 = (zzgt)collection;
        if (zzgt2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgt2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgt2.size;
        if (n > this.zzpy.length) {
            this.zzpy = Arrays.copyOf(this.zzpy, n);
        }
        System.arraycopy(zzgt2.zzpy, 0, this.zzpy, this.size, zzgt2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzet();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzpy[i])) continue;
            System.arraycopy(this.zzpy, i + 1, this.zzpy, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzs(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
    }

    private final String zzt(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzgt zzgt2 = this;
        zzgt2.zzet();
        zzgt2.zzs(n);
        double d3 = zzgt2.zzpy[n];
        zzgt2.zzpy[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgt zzgt2 = this;
        zzgt2.zzet();
        zzgt2.zzs(n);
        double d = zzgt2.zzpy[n];
        if (n < zzgt2.size - 1) {
            System.arraycopy(zzgt2.zzpy, n + 1, zzgt2.zzpy, n, zzgt2.size - n - 1);
        }
        --zzgt2.size;
        ++zzgt2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzhn zzu(int n) {
        int n2 = n;
        zzgt zzgt2 = this;
        if (n2 < zzgt2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgt(Arrays.copyOf(zzgt2.zzpy, n2), zzgt2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgt zzgt2 = this;
        zzgt2.zzs(n);
        return zzgt2.zzpy[n];
    }

    static {
        zzpx.zzes();
    }
}

