/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzfr;
import com.google.android.gms.internal.firebase_remote_config.zzhm;
import com.google.android.gms.internal.firebase_remote_config.zzhn;
import com.google.android.gms.internal.firebase_remote_config.zzjc;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhk
extends zzfr<Integer>
implements zzhn<Integer>,
zzjc,
RandomAccess {
    private static final zzhk zztk = new zzhk(new int[0], 0);
    private int[] zztl;
    private int size;

    zzhk() {
        this(new int[10], 0);
    }

    private zzhk(int[] nArray, int n) {
        this.zztl = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzet();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zztl, n2, this.zztl, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhk)) {
            return super.equals(object);
        }
        zzhk zzhk2 = (zzhk)object;
        if (this.size != zzhk2.size) {
            return false;
        }
        int[] nArray = zzhk2.zztl;
        for (int i = 0; i < this.size; ++i) {
            if (this.zztl[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zztl[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzs(n);
        return this.zztl[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbb(int n) {
        this.zzp(this.size, n);
    }

    private final void zzp(int n, int n2) {
        this.zzet();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
        if (this.size < this.zztl.length) {
            System.arraycopy(this.zztl, n, this.zztl, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zztl, 0, nArray, 0, n);
            System.arraycopy(this.zztl, n, nArray, n + 1, this.size - n);
            this.zztl = nArray;
        }
        this.zztl[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzet();
        zzhm.checkNotNull(collection);
        if (!(collection instanceof zzhk)) {
            return super.addAll(collection);
        }
        zzhk zzhk2 = (zzhk)collection;
        if (zzhk2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhk2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhk2.size;
        if (n > this.zztl.length) {
            this.zztl = Arrays.copyOf(this.zztl, n);
        }
        System.arraycopy(zzhk2.zztl, 0, this.zztl, this.size, zzhk2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzet();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zztl[i])) continue;
            System.arraycopy(this.zztl, i + 1, this.zztl, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzs(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
    }

    private final String zzt(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzhk zzhk2 = this;
        zzhk2.zzet();
        zzhk2.zzs(n);
        int n4 = zzhk2.zztl[n];
        zzhk2.zztl[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhk zzhk2 = this;
        zzhk2.zzet();
        zzhk2.zzs(n);
        int n2 = zzhk2.zztl[n];
        if (n < zzhk2.size - 1) {
            System.arraycopy(zzhk2.zztl, n + 1, zzhk2.zztl, n, zzhk2.size - n - 1);
        }
        --zzhk2.size;
        ++zzhk2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzp(n, n2);
    }

    @Override
    public final /* synthetic */ zzhn zzu(int n) {
        int n2 = n;
        zzhk zzhk2 = this;
        if (n2 < zzhk2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhk(Arrays.copyOf(zzhk2.zztl, n2), zzhk2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zztk.zzes();
    }
}

