/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.android.gms.internal.firebase_remote_config.zzes;
import com.google.firebase.remoteconfig.zzn;

public class FirebaseRemoteConfigSettings {
    private final boolean zzjq;
    private final long zzjr;
    private final long zzjs;

    private FirebaseRemoteConfigSettings(Builder builder) {
        this.zzjq = builder.zzjq;
        this.zzjr = builder.zzjr;
        this.zzjs = builder.zzjs;
    }

    @Deprecated
    public boolean isDeveloperModeEnabled() {
        return this.zzjq;
    }

    public long getFetchTimeoutInSeconds() {
        return this.zzjr;
    }

    public long getMinimumFetchIntervalInSeconds() {
        return this.zzjs;
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.setDeveloperModeEnabled(this.isDeveloperModeEnabled());
        builder.setFetchTimeoutInSeconds(this.getFetchTimeoutInSeconds());
        builder.setMinimumFetchIntervalInSeconds(this.getMinimumFetchIntervalInSeconds());
        return builder;
    }

    /* synthetic */ FirebaseRemoteConfigSettings(Builder builder, zzn zzn2) {
        this(builder);
    }

    public static class Builder {
        private boolean zzjq = false;
        private long zzjr = 5L;
        private long zzjs = zzes.zzla;

        @Deprecated
        public Builder setDeveloperModeEnabled(boolean bl) {
            this.zzjq = bl;
            return this;
        }

        public Builder setFetchTimeoutInSeconds(long l) throws IllegalArgumentException {
            if (l < 0L) {
                throw new IllegalArgumentException(String.format("Fetch connection timeout has to be a non-negative number. %d is an invalid argument", l));
            }
            this.zzjr = l;
            return this;
        }

        public Builder setMinimumFetchIntervalInSeconds(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException(new StringBuilder(109).append("Minimum interval between fetches has to be a non-negative number. ").append(l).append(" is an invalid argument").toString());
            }
            this.zzjs = l;
            return this;
        }

        public FirebaseRemoteConfigSettings build() {
            return new FirebaseRemoteConfigSettings(this, null);
        }
    }
}

