/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.abt.FirebaseABTesting;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.RemoteConfigComponent$$Lambda$1;
import com.google.firebase.remoteconfig.RemoteConfigComponent$$Lambda$4;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient;
import com.google.firebase.remoteconfig.internal.ConfigFetchHandler;
import com.google.firebase.remoteconfig.internal.ConfigFetchHttpClient;
import com.google.firebase.remoteconfig.internal.ConfigGetParameterHandler;
import com.google.firebase.remoteconfig.internal.ConfigMetadataClient;
import com.google.firebase.remoteconfig.internal.ConfigStorageClient;
import com.google.firebase.remoteconfig.internal.LegacyConfigsHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@KeepForSdk
public class RemoteConfigComponent {
    public static final String ACTIVATE_FILE_NAME = "activate";
    public static final String FETCH_FILE_NAME = "fetch";
    public static final String DEFAULTS_FILE_NAME = "defaults";
    public static final long CONNECTION_TIMEOUT_IN_SECONDS = 60L;
    private static final String FIREBASE_REMOTE_CONFIG_FILE_NAME_PREFIX = "frc";
    private static final String PREFERENCES_FILE_NAME = "settings";
    @VisibleForTesting
    public static final String DEFAULT_NAMESPACE = "firebase";
    private static final Clock DEFAULT_CLOCK = DefaultClock.getInstance();
    private static final Random DEFAULT_RANDOM = new Random();
    @GuardedBy(value="this")
    private final Map<String, FirebaseRemoteConfig> frcNamespaceInstances = new HashMap<String, FirebaseRemoteConfig>();
    private final Context context;
    private final ExecutorService executorService;
    private final FirebaseApp firebaseApp;
    private final FirebaseInstanceId firebaseInstanceId;
    private final FirebaseABTesting firebaseAbt;
    @Nullable
    private final AnalyticsConnector analyticsConnector;
    private final String appId;
    @GuardedBy(value="this")
    private Map<String, String> customHeaders = new HashMap<String, String>();

    RemoteConfigComponent(Context context, FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, FirebaseABTesting firebaseAbt, @Nullable AnalyticsConnector analyticsConnector) {
        this(context, Executors.newCachedThreadPool(), firebaseApp, firebaseInstanceId, firebaseAbt, analyticsConnector, new LegacyConfigsHandler(context, firebaseApp.getOptions().getApplicationId()), true);
    }

    @VisibleForTesting
    protected RemoteConfigComponent(Context context, ExecutorService executorService, FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, FirebaseABTesting firebaseAbt, @Nullable AnalyticsConnector analyticsConnector, LegacyConfigsHandler legacyConfigsHandler, boolean loadGetDefault) {
        this.context = context;
        this.executorService = executorService;
        this.firebaseApp = firebaseApp;
        this.firebaseInstanceId = firebaseInstanceId;
        this.firebaseAbt = firebaseAbt;
        this.analyticsConnector = analyticsConnector;
        this.appId = firebaseApp.getOptions().getApplicationId();
        if (loadGetDefault) {
            Tasks.call((Executor)executorService, (Callable)RemoteConfigComponent$$Lambda$1.lambdaFactory$(this));
            LegacyConfigsHandler legacyConfigsHandler2 = legacyConfigsHandler;
            legacyConfigsHandler2.getClass();
            Tasks.call((Executor)executorService, (Callable)RemoteConfigComponent$$Lambda$4.lambdaFactory$(legacyConfigsHandler2));
        }
    }

    FirebaseRemoteConfig getDefault() {
        return this.get(DEFAULT_NAMESPACE);
    }

    @VisibleForTesting
    @KeepForSdk
    public synchronized FirebaseRemoteConfig get(String namespace) {
        ConfigCacheClient fetchedCacheClient = this.getCacheClient(namespace, FETCH_FILE_NAME);
        ConfigCacheClient activatedCacheClient = this.getCacheClient(namespace, ACTIVATE_FILE_NAME);
        ConfigCacheClient defaultsCacheClient = this.getCacheClient(namespace, DEFAULTS_FILE_NAME);
        ConfigMetadataClient metadataClient = RemoteConfigComponent.getMetadataClient(this.context, this.appId, namespace);
        return this.get(this.firebaseApp, namespace, this.firebaseInstanceId, this.firebaseAbt, this.executorService, fetchedCacheClient, activatedCacheClient, defaultsCacheClient, this.getFetchHandler(namespace, fetchedCacheClient, metadataClient), this.getGetHandler(activatedCacheClient, defaultsCacheClient), metadataClient);
    }

    @VisibleForTesting
    synchronized FirebaseRemoteConfig get(FirebaseApp firebaseApp, String namespace, FirebaseInstanceId firebaseInstanceId, FirebaseABTesting firebaseAbt, Executor executor, ConfigCacheClient fetchedClient, ConfigCacheClient activatedClient, ConfigCacheClient defaultsClient, ConfigFetchHandler fetchHandler, ConfigGetParameterHandler getHandler, ConfigMetadataClient metadataClient) {
        if (!this.frcNamespaceInstances.containsKey(namespace)) {
            FirebaseRemoteConfig in = new FirebaseRemoteConfig(this.context, firebaseApp, firebaseInstanceId, (FirebaseABTesting)(RemoteConfigComponent.isAbtSupported(firebaseApp, namespace) ? firebaseAbt : null), executor, fetchedClient, activatedClient, defaultsClient, fetchHandler, getHandler, metadataClient);
            in.startLoadingConfigsFromDisk();
            this.frcNamespaceInstances.put(namespace, in);
        }
        return this.frcNamespaceInstances.get(namespace);
    }

    @VisibleForTesting
    public synchronized void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    private ConfigCacheClient getCacheClient(String namespace, String configStoreType) {
        return RemoteConfigComponent.getCacheClient(this.context, this.appId, namespace, configStoreType);
    }

    public static ConfigCacheClient getCacheClient(Context context, String appId, String namespace, String configStoreType) {
        String fileName = String.format("%s_%s_%s_%s.json", FIREBASE_REMOTE_CONFIG_FILE_NAME_PREFIX, appId, namespace, configStoreType);
        return ConfigCacheClient.getInstance(Executors.newCachedThreadPool(), ConfigStorageClient.getInstance(context, fileName));
    }

    @VisibleForTesting
    ConfigFetchHttpClient getFrcBackendApiClient(String apiKey, String namespace, ConfigMetadataClient metadataClient) {
        String appId = this.firebaseApp.getOptions().getApplicationId();
        return new ConfigFetchHttpClient(this.context, appId, apiKey, namespace, metadataClient.getFetchTimeoutInSeconds(), metadataClient.getFetchTimeoutInSeconds());
    }

    @VisibleForTesting
    synchronized ConfigFetchHandler getFetchHandler(String namespace, ConfigCacheClient fetchedCacheClient, ConfigMetadataClient metadataClient) {
        return new ConfigFetchHandler(this.firebaseInstanceId, RemoteConfigComponent.isPrimaryApp(this.firebaseApp) ? this.analyticsConnector : null, this.executorService, DEFAULT_CLOCK, DEFAULT_RANDOM, fetchedCacheClient, this.getFrcBackendApiClient(this.firebaseApp.getOptions().getApiKey(), namespace, metadataClient), metadataClient, this.customHeaders);
    }

    private ConfigGetParameterHandler getGetHandler(ConfigCacheClient activatedCacheClient, ConfigCacheClient defaultsCacheClient) {
        return new ConfigGetParameterHandler(activatedCacheClient, defaultsCacheClient);
    }

    @VisibleForTesting
    static ConfigMetadataClient getMetadataClient(Context context, String appId, String namespace) {
        String fileName = String.format("%s_%s_%s_%s", FIREBASE_REMOTE_CONFIG_FILE_NAME_PREFIX, appId, namespace, PREFERENCES_FILE_NAME);
        SharedPreferences preferences = context.getSharedPreferences(fileName, 0);
        return new ConfigMetadataClient(preferences);
    }

    private static boolean isAbtSupported(FirebaseApp firebaseApp, String namespace) {
        return namespace.equals(DEFAULT_NAMESPACE) && RemoteConfigComponent.isPrimaryApp(firebaseApp);
    }

    private static boolean isPrimaryApp(FirebaseApp firebaseApp) {
        return firebaseApp.getName().equals("[DEFAULT]");
    }
}

