/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import com.google.firebase.remoteconfig.proto.ConfigPersistence;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import developers.mobile.abt.FirebaseAbt;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LegacyConfigsHandler {
    @VisibleForTesting
    public static final String EXPERIMENT_ID_KEY = "experimentId";
    @VisibleForTesting
    public static final String EXPERIMENT_VARIANT_ID_KEY = "variantId";
    @VisibleForTesting
    public static final String EXPERIMENT_START_TIME_KEY = "experimentStartTime";
    @VisibleForTesting
    public static final String EXPERIMENT_TRIGGER_EVENT_KEY = "triggerEvent";
    @VisibleForTesting
    public static final String EXPERIMENT_TRIGGER_TIMEOUT_KEY = "triggerTimeoutMillis";
    @VisibleForTesting
    public static final String EXPERIMENT_TIME_TO_LIVE_KEY = "timeToLiveMillis";
    @VisibleForTesting
    static final String LEGACY_CONFIGS_FILE_NAME = "persisted_config";
    private static final String LEGACY_SETTINGS_FILE_NAME = "com.google.firebase.remoteconfig_legacy_settings";
    private static final String SAVE_LEGACY_CONFIGS_FLAG_NAME = "save_legacy_configs";
    @VisibleForTesting
    static final String LEGACY_FRC_NAMESPACE_PREFIX = "configns:";
    private static final String FRC_3P_NAMESPACE = "firebase";
    private static final Charset PROTO_BYTE_ARRAY_ENCODING = Charset.forName("UTF-8");
    @VisibleForTesting
    static final String ACTIVATE_FILE_NAME = "activate";
    @VisibleForTesting
    static final String FETCH_FILE_NAME = "fetch";
    @VisibleForTesting
    static final String DEFAULTS_FILE_NAME = "defaults";
    @VisibleForTesting
    static final ThreadLocal<DateFormat> protoTimestampStringParser = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        }
    };
    private final Context context;
    private final String appId;
    private final SharedPreferences legacySettings;

    public LegacyConfigsHandler(Context context, String appId) {
        this.context = context;
        this.appId = appId;
        this.legacySettings = context.getSharedPreferences(LEGACY_SETTINGS_FILE_NAME, 0);
    }

    @WorkerThread
    public boolean saveLegacyConfigsIfNecessary() {
        if (this.legacySettings.getBoolean(SAVE_LEGACY_CONFIGS_FLAG_NAME, true)) {
            this.saveLegacyConfigs(this.getConvertedLegacyConfigs());
            this.legacySettings.edit().putBoolean(SAVE_LEGACY_CONFIGS_FLAG_NAME, false).commit();
            return true;
        }
        return false;
    }

    @WorkerThread
    private void saveLegacyConfigs(Map<String, NamespaceLegacyConfigs> legacyConfigsByNamespace) {
        for (Map.Entry<String, NamespaceLegacyConfigs> legacyConfigsByNamespaceEntry : legacyConfigsByNamespace.entrySet()) {
            String namespace = legacyConfigsByNamespaceEntry.getKey();
            NamespaceLegacyConfigs legacyConfigs = legacyConfigsByNamespaceEntry.getValue();
            ConfigCacheClient fetchedCacheClient = this.getCacheClient(namespace, FETCH_FILE_NAME);
            ConfigCacheClient activatedCacheClient = this.getCacheClient(namespace, ACTIVATE_FILE_NAME);
            ConfigCacheClient defaultsCacheClient = this.getCacheClient(namespace, DEFAULTS_FILE_NAME);
            if (legacyConfigs.getFetchedConfigs() != null) {
                fetchedCacheClient.put(legacyConfigs.getFetchedConfigs());
            }
            if (legacyConfigs.getActivatedConfigs() != null) {
                activatedCacheClient.put(legacyConfigs.getActivatedConfigs());
            }
            if (legacyConfigs.getDefaultsConfigs() == null) continue;
            defaultsCacheClient.put(legacyConfigs.getDefaultsConfigs());
        }
    }

    @WorkerThread
    private Map<String, NamespaceLegacyConfigs> getConvertedLegacyConfigs() {
        ConfigPersistence.PersistedConfig allLegacyConfigs = this.readPersistedConfig();
        HashMap<String, NamespaceLegacyConfigs> allConfigsMap = new HashMap<String, NamespaceLegacyConfigs>();
        if (allLegacyConfigs == null) {
            return allConfigsMap;
        }
        Map<String, ConfigContainer> activatedConfigsByNamespace = this.convertConfigHolder(allLegacyConfigs.getActiveConfigHolder());
        Map<String, ConfigContainer> fetchedConfigsByNamespace = this.convertConfigHolder(allLegacyConfigs.getFetchedConfigHolder());
        Map<String, ConfigContainer> defaultsConfigsByNamespace = this.convertConfigHolder(allLegacyConfigs.getDefaultsConfigHolder());
        HashSet<String> allNamespaces = new HashSet<String>();
        allNamespaces.addAll(activatedConfigsByNamespace.keySet());
        allNamespaces.addAll(fetchedConfigsByNamespace.keySet());
        allNamespaces.addAll(defaultsConfigsByNamespace.keySet());
        for (String namespace : allNamespaces) {
            NamespaceLegacyConfigs namespaceLegacyConfigs = new NamespaceLegacyConfigs();
            if (activatedConfigsByNamespace.containsKey(namespace)) {
                namespaceLegacyConfigs.setActivatedConfigs(activatedConfigsByNamespace.get(namespace));
            }
            if (fetchedConfigsByNamespace.containsKey(namespace)) {
                namespaceLegacyConfigs.setFetchedConfigs(fetchedConfigsByNamespace.get(namespace));
            }
            if (defaultsConfigsByNamespace.containsKey(namespace)) {
                namespaceLegacyConfigs.setDefaultsConfigs(defaultsConfigsByNamespace.get(namespace));
            }
            allConfigsMap.put(namespace, namespaceLegacyConfigs);
        }
        return allConfigsMap;
    }

    private Map<String, ConfigContainer> convertConfigHolder(ConfigPersistence.ConfigHolder allNamespaceLegacyConfigs) {
        HashMap<String, ConfigContainer> convertedLegacyConfigs = new HashMap<String, ConfigContainer>();
        Date fetchTime = new Date(allNamespaceLegacyConfigs.getTimestamp());
        JSONArray abtExperiments = this.convertLegacyAbtExperiments(allNamespaceLegacyConfigs.getExperimentPayloadList());
        List<ConfigPersistence.NamespaceKeyValue> namespaceLegacyConfigsArray = allNamespaceLegacyConfigs.getNamespaceKeyValueList();
        for (ConfigPersistence.NamespaceKeyValue namespaceLegacyConfigs : namespaceLegacyConfigsArray) {
            String namespace = namespaceLegacyConfigs.getNamespace();
            if (namespace.startsWith(LEGACY_FRC_NAMESPACE_PREFIX)) {
                namespace = namespace.substring(LEGACY_FRC_NAMESPACE_PREFIX.length());
            }
            ConfigContainer.Builder configsBuilder = ConfigContainer.newBuilder().replaceConfigsWith(this.convertKeyValueList(namespaceLegacyConfigs.getKeyValueList())).withFetchTime(fetchTime);
            if (namespace.equals(FRC_3P_NAMESPACE)) {
                configsBuilder.withAbtExperiments(abtExperiments);
            }
            try {
                convertedLegacyConfigs.put(namespace, configsBuilder.build());
            }
            catch (JSONException e) {
                Log.d((String)"FirebaseRemoteConfig", (String)"A set of legacy configs could not be converted.");
            }
        }
        return convertedLegacyConfigs;
    }

    private JSONArray convertLegacyAbtExperiments(List<ByteString> legacyExperimentPayloads) {
        JSONArray abtExperiments = new JSONArray();
        for (ByteString legacyExperimentPayload : legacyExperimentPayloads) {
            FirebaseAbt.ExperimentPayload deserializedPayload = this.deserializePayload(legacyExperimentPayload);
            if (deserializedPayload == null) continue;
            try {
                abtExperiments.put((Object)this.convertLegacyAbtExperiment(deserializedPayload));
            }
            catch (JSONException e) {
                Log.d((String)"FirebaseRemoteConfig", (String)"A legacy ABT experiment could not be parsed.", (Throwable)e);
            }
        }
        return abtExperiments;
    }

    @Nullable
    private FirebaseAbt.ExperimentPayload deserializePayload(ByteString legacyExperimentPayload) {
        try {
            ByteString.ByteIterator byteIterator = legacyExperimentPayload.iterator();
            byte[] payloadArray = new byte[legacyExperimentPayload.size()];
            for (int index = 0; index < payloadArray.length; ++index) {
                payloadArray[index] = (Byte)byteIterator.next();
            }
            return FirebaseAbt.ExperimentPayload.parseFrom((byte[])payloadArray);
        }
        catch (InvalidProtocolBufferException e) {
            Log.d((String)"FirebaseRemoteConfig", (String)"Payload was not defined or could not be deserialized.", (Throwable)e);
            return null;
        }
    }

    private JSONObject convertLegacyAbtExperiment(FirebaseAbt.ExperimentPayload deserializedLegacyPayload) throws JSONException {
        JSONObject abtExperiment = new JSONObject();
        abtExperiment.put(EXPERIMENT_ID_KEY, (Object)deserializedLegacyPayload.getExperimentId());
        abtExperiment.put(EXPERIMENT_VARIANT_ID_KEY, (Object)deserializedLegacyPayload.getVariantId());
        abtExperiment.put(EXPERIMENT_START_TIME_KEY, (Object)protoTimestampStringParser.get().format(new Date(deserializedLegacyPayload.getExperimentStartTimeMillis())));
        abtExperiment.put(EXPERIMENT_TRIGGER_EVENT_KEY, (Object)deserializedLegacyPayload.getTriggerEvent());
        abtExperiment.put(EXPERIMENT_TRIGGER_TIMEOUT_KEY, deserializedLegacyPayload.getTriggerTimeoutMillis());
        abtExperiment.put(EXPERIMENT_TIME_TO_LIVE_KEY, deserializedLegacyPayload.getTimeToLiveMillis());
        return abtExperiment;
    }

    private Map<String, String> convertKeyValueList(List<ConfigPersistence.KeyValue> legacyConfigs) {
        HashMap<String, String> legacyConfigsMap = new HashMap<String, String>();
        for (ConfigPersistence.KeyValue legacyConfig : legacyConfigs) {
            legacyConfigsMap.put(legacyConfig.getKey(), legacyConfig.getValue().toString(PROTO_BYTE_ARRAY_ENCODING));
        }
        return legacyConfigsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private ConfigPersistence.PersistedConfig readPersistedConfig() {
        ConfigPersistence.PersistedConfig persistedConfig;
        if (this.context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = this.context.openFileInput(LEGACY_CONFIGS_FILE_NAME);
            persistedConfig = ConfigPersistence.PersistedConfig.parseFrom(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            ConfigPersistence.PersistedConfig persistedConfig2 = null;
            return persistedConfig2;
        }
        catch (IOException ioException) {
            Log.d((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)ioException);
            ConfigPersistence.PersistedConfig persistedConfig3 = null;
            return persistedConfig3;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ioException) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)ioException);
            }
        }
        return persistedConfig;
    }

    ConfigCacheClient getCacheClient(String namespace, String configStoreType) {
        return RemoteConfigComponent.getCacheClient(this.context, this.appId, namespace, configStoreType);
    }

    private static class NamespaceLegacyConfigs {
        private ConfigContainer fetchedConfigs;
        private ConfigContainer activatedConfigs;
        private ConfigContainer defaultsConfigs;

        private NamespaceLegacyConfigs() {
        }

        private void setFetchedConfigs(ConfigContainer fetchedConfigs) {
            this.fetchedConfigs = fetchedConfigs;
        }

        private void setActivatedConfigs(ConfigContainer activatedConfigs) {
            this.activatedConfigs = activatedConfigs;
        }

        private void setDefaultsConfigs(ConfigContainer defaultsConfigs) {
            this.defaultsConfigs = defaultsConfigs;
        }

        private ConfigContainer getFetchedConfigs() {
            return this.fetchedConfigs;
        }

        private ConfigContainer getActivatedConfigs() {
            return this.activatedConfigs;
        }

        private ConfigContainer getDefaultsConfigs() {
            return this.defaultsConfigs;
        }
    }
}

