/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.config.internal.zzb;
import com.google.android.gms.internal.zzajc;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzajg;
import com.google.android.gms.internal.zzajh;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzbTi;
    private zzaje zzbTj;
    private zzaje zzbTk;
    private zzaje zzbTl;
    private zzajh zzbTm;
    private final Context mContext;
    private final ReadWriteLock zzbTn = new ReentrantReadWriteLock(true);

    FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzaje zzaje2, zzaje zzaje3, zzaje zzaje4, zzajh zzajh2) {
        this.mContext = context;
        this.zzbTm = zzajh2 != null ? zzajh2 : new zzajh();
        this.zzbTm.zzaL(this.zzbE(this.mContext));
        if (zzaje2 != null) {
            this.zzbTj = zzaje2;
        }
        if (zzaje3 != null) {
            this.zzbTk = zzaje3;
        }
        if (zzaje4 != null) {
            this.zzbTl = zzaje4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzbTi == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            return FirebaseRemoteConfig.zzbD(context);
        }
        return zzbTi;
    }

    public static FirebaseRemoteConfig zzbD(Context context) {
        if (zzbTi == null) {
            zzaji.zze zze2 = FirebaseRemoteConfig.zzbF(context);
            if (zze2 == null) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                }
                zzbTi = new FirebaseRemoteConfig(context);
            } else {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                }
                zzaje zzaje2 = FirebaseRemoteConfig.zza(zze2.zzbTK);
                zzaje zzaje3 = FirebaseRemoteConfig.zza(zze2.zzbTL);
                zzaje zzaje4 = FirebaseRemoteConfig.zza(zze2.zzbTM);
                zzajh zzajh2 = FirebaseRemoteConfig.zza(zze2.zzbTN);
                zzajh2.zzaD(FirebaseRemoteConfig.zza(zze2.zzbTO));
                zzbTi = new FirebaseRemoteConfig(context, zzaje2, zzaje3, zzaje4, zzajh2);
            }
        }
        return zzbTi;
    }

    private long zzbE(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzaji.zze zzbF(Context context) {
        if (context == null) {
            return null;
        }
        zzaji.zze zze2 = null;
        try {
            FileInputStream fileInputStream = context.openFileInput("persisted_config");
            zzamb zzamb2 = zzamb.zzN((byte[])FirebaseRemoteConfig.zzl(fileInputStream));
            zze2 = new zzaji.zze();
            zzaji.zze cfr_ignored_0 = (zzaji.zze)zze2.mergeFrom(zzamb2);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
        }
        return zze2;
    }

    private static Map<String, zzajc> zza(zzaji.zzf[] zzfArray) {
        HashMap<String, zzajc> hashMap = new HashMap<String, zzajc>();
        for (zzaji.zzf zzf2 : zzfArray) {
            String string = zzf2.zzasB;
            int n = zzf2.resourceId;
            long l = zzf2.zzbTQ;
            hashMap.put(string, new zzajc(n, l));
        }
        return hashMap;
    }

    private static zzajh zza(zzaji.zzc zzc2) {
        zzajh zzajh2 = new zzajh();
        zzajh2.zznJ(zzc2.zzbTG);
        zzajh2.zzaT(zzc2.zzbTH);
        return zzajh2;
    }

    private static zzaje zza(zzaji.zza zza2) {
        zzaji.zzd[] zzdArray;
        if (zza2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        for (zzaji.zzd zzd2 : zzdArray = zza2.zzbTD) {
            String string = zzd2.zzasB;
            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
            for (zzaji.zzb zzb2 : zzd2.zzbTJ) {
                hashMap2.put(zzb2.zzaB, zzb2.zzbTF);
            }
            hashMap.put(string, hashMap2);
        }
        return new zzaje(hashMap, zza2.timestamp);
    }

    private static byte[] zzl(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FirebaseRemoteConfig.zzb(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long zzb(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateFetched() {
        this.zzbTn.writeLock().lock();
        try {
            if (this.zzbTj == null) {
                boolean bl = false;
                return false;
            }
            if (this.zzbTk != null && this.zzbTk.getTimestamp() >= this.zzbTj.getTimestamp()) {
                boolean bl = false;
                return false;
            }
            long l = this.zzbTj.getTimestamp();
            this.zzbTk = this.zzbTj;
            this.zzbTk.setTimestamp(System.currentTimeMillis());
            this.zzbTj = new zzaje(null, l);
            this.zzUy();
            boolean bl = true;
            return true;
        }
        finally {
            this.zzbTn.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzbTn.readLock().lock();
        try {
            if (this.zzbTm != null && this.zzbTm.zzUE() != null && this.zzbTm.zzUE().get(string) != null && n == ((zzajc)(object = this.zzbTm.zzUE().get(string))).zzUz() && this.zzbTm.zzUF() == ((zzajc)object).zzUA()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzbTn.readLock().unlock();
        }
        object = new HashMap();
        try {
            Resources resources = this.mContext.getResources();
            XmlResourceParser xmlResourceParser = resources.getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzajc zzajc2 = new zzajc(n, this.zzbTm.zzUF());
            this.zzbTm.zza(string, zzajc2);
            this.zzc((Map<String, Object>)object, string, false);
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzajg.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzajg.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzajg.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzajg.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzajg.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzajg.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzbTn.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzbTl == null || !this.zzbTl.zziE(string)) {
                    return;
                }
                this.zzbTl.zzk(null, string);
                this.zzbTl.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzbTl == null) {
                    this.zzbTl = new zzaje(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis());
                }
                this.zzbTl.zzk(hashMap, string);
                this.zzbTl.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzbTm.zziF(string);
            }
            this.zzUy();
        }
        finally {
            this.zzbTn.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzbTn.writeLock().lock();
        try {
            boolean bl = this.zzbTm.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzbTm.zzaT(bl2);
            if (bl != bl2) {
                this.zzUy();
            }
        }
        finally {
            this.zzbTn.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzbTn.readLock().lock();
        try {
            if (this.zzbTk != null && this.zzbTk.zzaq(string, string2)) {
                byte[] byArray = this.zzbTk.zzar(string, string2);
                return byArray;
            }
            if (this.zzbTl != null && this.zzbTl.zzaq(string, string2)) {
                byte[] byArray = this.zzbTl.zzar(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzbTn.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_STRING;
        }
        this.zzbTn.readLock().lock();
        try {
            if (this.zzbTk != null && this.zzbTk.zzaq(string, string2)) {
                String string3 = new String(this.zzbTk.zzar(string, string2), zzajg.UTF_8);
                return string3;
            }
            if (this.zzbTl != null && this.zzbTl.zzaq(string, string2)) {
                String string4 = new String(this.zzbTl.zzar(string, string2), zzajg.UTF_8);
                return string4;
            }
            String string5 = DEFAULT_VALUE_FOR_STRING;
            return string5;
        }
        finally {
            this.zzbTn.readLock().unlock();
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzbTn.readLock().lock();
        try {
            String string3;
            if (this.zzbTk != null && this.zzbTk.zzaq(string, string2)) {
                string3 = new String(this.zzbTk.zzar(string, string2), zzajg.UTF_8);
                if (zzajg.zzauD.matcher(string3).matches()) {
                    boolean bl = true;
                    return true;
                }
                if (zzajg.zzauE.matcher(string3).matches()) {
                    boolean bl = false;
                    return false;
                }
            }
            if (this.zzbTl != null && this.zzbTl.zzaq(string, string2)) {
                string3 = new String(this.zzbTl.zzar(string, string2), zzajg.UTF_8);
                if (zzajg.zzauD.matcher(string3).matches()) {
                    boolean bl = true;
                    return true;
                }
                if (zzajg.zzauE.matcher(string3).matches()) {
                    boolean bl = false;
                    return false;
                }
            }
            boolean bl = false;
            return false;
        }
        finally {
            this.zzbTn.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzajg(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzbTn.readLock().lock();
        try {
            if (this.zzbTk != null && this.zzbTk.zzaq(string, string2)) {
                zzajg zzajg2 = new zzajg(this.zzbTk.zzar(string, string2), 2);
                return zzajg2;
            }
            if (this.zzbTl != null && this.zzbTl.zzaq(string, string2)) {
                zzajg zzajg3 = new zzajg(this.zzbTl.zzar(string, string2), 1);
                return zzajg3;
            }
            zzajg zzajg4 = new zzajg(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzajg4;
        }
        finally {
            this.zzbTn.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        zzajf zzajf2 = new zzajf();
        this.zzbTn.readLock().lock();
        try {
            long l = this.zzbTj == null ? -1L : this.zzbTj.getTimestamp();
            zzajf2.zzaK(l);
            zzajf2.zznJ(this.zzbTm.getLastFetchStatus());
            zzajf2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzbTm.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzbTn.readLock().unlock();
        }
        return zzajf2;
    }

    private void zzUy() {
        this.zzbTn.readLock().lock();
        try {
            zzajd zzajd2 = new zzajd(this.mContext, this.zzbTj, this.zzbTk, this.zzbTl, this.zzbTm);
            if (Build.VERSION.SDK_INT >= 11) {
                AsyncTask.SERIAL_EXECUTOR.execute(zzajd2);
            } else {
                new zza().execute(zzajd2);
            }
        }
        finally {
            this.zzbTn.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> fetch(long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzbTn.writeLock().lock();
        try {
            zzpy.zza.zza zza2 = new zzpy.zza.zza();
            zza2.zzF(l);
            if (this.zzbTm.isDeveloperModeEnabled()) {
                zza2.zzF("_rcn_developer", "true");
            }
            PendingResult<zzpy.zzb> pendingResult = new zzb(this.mContext).zza(zza2.zzvs());
            pendingResult.setResultCallback((ResultCallback)new ResultCallback<zzpy.zzb>(){

                public void zza(@NonNull zzpy.zzb zzb2) {
                    FirebaseRemoteConfig.this.zza((TaskCompletionSource<Void>)taskCompletionSource, zzb2);
                }

                public /* synthetic */ void onResult(@NonNull Result result) {
                    this.zza((zzpy.zzb)result);
                }
            });
        }
        finally {
            this.zzbTn.writeLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    void zza(TaskCompletionSource<Void> taskCompletionSource, zzpy.zzb zzb2) {
        if (zzb2 == null || zzb2.getStatus() == null) {
            this.zzbTm.zznJ(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzUy();
            return;
        }
        int n = zzb2.getStatus().getStatusCode();
        switch (n) {
            case 6500: 
            case 6501: 
            case 6503: 
            case 6504: {
                this.zzbTm.zznJ(1);
                taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                this.zzUy();
                break;
            }
            case 6502: 
            case 6507: {
                this.zzbTm.zznJ(2);
                taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzb2.getThrottleEndTimeMillis())));
                this.zzUy();
                break;
            }
            case -6508: 
            case -6506: {
                this.zzbTm.zznJ(-1);
                if (this.zzbTj != null && !this.zzbTj.zzUC()) {
                    Map<String, Set<String>> map = zzb2.zzvt();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                        for (String string2 : map.get(string)) {
                            hashMap2.put(string2, zzb2.zza(string2, null, string));
                        }
                        hashMap.put(string, hashMap2);
                    }
                    this.zzbTj = new zzaje(hashMap, this.zzbTj.getTimestamp());
                }
                taskCompletionSource.setResult(null);
                this.zzUy();
                break;
            }
            case -6505: {
                Map<String, Set<String>> map = zzb2.zzvt();
                HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                for (String string : map.keySet()) {
                    HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                    for (String string3 : map.get(string)) {
                        hashMap3.put(string3, zzb2.zza(string3, null, string));
                    }
                    hashMap.put(string, hashMap3);
                }
                this.zzbTj = new zzaje(hashMap, System.currentTimeMillis());
                this.zzbTm.zznJ(-1);
                taskCompletionSource.setResult(null);
                this.zzUy();
                break;
            }
            default: {
                if (zzb2.getStatus().isSuccess()) {
                    Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                }
                this.zzbTm.zznJ(1);
                taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                this.zzUy();
            }
        }
    }

    static class zza
    implements Executor {
        zza() {
        }

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    }
}

