/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.config.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.config.internal.CustomVariable;
import com.google.android.gms.config.internal.FetchConfigIpcRequest;
import com.google.android.gms.config.internal.FetchConfigIpcResponse;
import com.google.android.gms.config.internal.PackageConfigTable;
import com.google.android.gms.config.internal.zzg;
import com.google.android.gms.config.internal.zzh;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.internal.zzpz;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class zza
implements zzpy {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzauD = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzauE = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public PendingResult<zzpy.zzb> zza(GoogleApiClient googleApiClient, final zzpy.zza zza2) {
        if (googleApiClient == null || zza2 == null) {
            return null;
        }
        return googleApiClient.zzc((zznt.zza)new zzc(googleApiClient){

            @Override
            protected void zza(Context context, zzh zzh2) throws RemoteException {
                String string;
                String string2;
                String string3;
                DataHolder dataHolder;
                block3: {
                    DataHolder.zza zza22 = com.google.android.gms.common.data.zzd.zzsS();
                    for (Map.Entry<String, String> object2 : zza2.zzvr().entrySet()) {
                        com.google.android.gms.common.data.zzd.zza((DataHolder.zza)zza22, (SafeParcelable)new CustomVariable(object2.getKey(), object2.getValue()));
                    }
                    dataHolder = zza22.zzbR(0);
                    string3 = zzom.zzas((Context)context) == Status.zzalw ? zzom.zzsA() : null;
                    string2 = null;
                    string = null;
                    try {
                        string2 = com.google.firebase.iid.zzc.zzUl().getId();
                        string = com.google.firebase.iid.zzc.zzUl().getToken();
                    }
                    catch (IllegalStateException fetchConfigIpcRequest) {
                        if (!Log.isLoggable((String)"ConfigApiImpl", (int)3)) break block3;
                        Log.d((String)"ConfigApiImpl", (String)"Cannot retrieve instanceId or instanceIdToken.", (Throwable)fetchConfigIpcRequest);
                    }
                }
                FetchConfigIpcRequest fetchConfigIpcRequest = new FetchConfigIpcRequest(context.getPackageName(), zza2.zzvq(), dataHolder, string3, string2, string);
                zzh2.zza(this.zzauH, fetchConfigIpcRequest);
            }

            protected zzpy.zzb zzC(Status status) {
                return new zzd(status, new HashMap<String, TreeMap<String, byte[]>>());
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzC(status);
            }
        });
    }

    private static Status zzcA(int n) {
        return new Status(n, zzpz.getStatusCodeString(n));
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(FetchConfigIpcResponse fetchConfigIpcResponse) {
        if (fetchConfigIpcResponse == null) {
            return null;
        }
        DataHolder dataHolder = fetchConfigIpcResponse.zzvA();
        if (dataHolder == null) {
            return null;
        }
        com.google.android.gms.common.data.zzd zzd2 = new com.google.android.gms.common.data.zzd(dataHolder, (Parcelable.Creator)PackageConfigTable.CREATOR);
        PackageConfigTable packageConfigTable = (PackageConfigTable)((Object)zzd2.get(0));
        fetchConfigIpcResponse.zzvB();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : packageConfigTable.zzvC().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = packageConfigTable.zzvC().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    static abstract class zzc
    extends zzb<zzpy.zzb> {
        protected zzg zzauH = new zza(){

            @Override
            public void zza(Status status, FetchConfigIpcResponse fetchConfigIpcResponse) {
                if (fetchConfigIpcResponse.getStatusCode() == 6502 || fetchConfigIpcResponse.getStatusCode() == 6507) {
                    zzc.this.zzb(new zzd(zza.zzcA(fetchConfigIpcResponse.getStatusCode()), zza.zza(fetchConfigIpcResponse), fetchConfigIpcResponse.getThrottleEndTimeMillis()));
                } else {
                    zzc.this.zzb(new zzd(zza.zzcA(fetchConfigIpcResponse.getStatusCode()), zza.zza(fetchConfigIpcResponse)));
                }
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }
    }

    public static class zzd
    implements zzpy.zzb {
        private final Map<String, TreeMap<String, byte[]>> zzauJ;
        private final Status zzaaO;
        private final long zzauK;

        public zzd(Status status, Map<String, TreeMap<String, byte[]>> map) {
            this(status, map, -1L);
        }

        public zzd(Status status, Map<String, TreeMap<String, byte[]>> map, long l) {
            this.zzaaO = status;
            this.zzauJ = map;
            this.zzauK = l;
        }

        @Override
        public long getThrottleEndTimeMillis() {
            return this.zzauK;
        }

        @Override
        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public byte[] zza(String string, byte[] byArray, String string2) {
            if (this.zzG(string, string2)) {
                return this.zzauJ.get(string2).get(string);
            }
            return byArray;
        }

        public boolean zzG(String string, String string2) {
            if (this.zzauJ == null || this.zzauJ.get(string2) == null) {
                return false;
            }
            return this.zzauJ.get(string2).get(string) != null;
        }

        @Override
        public Map<String, Set<String>> zzvt() {
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            if (this.zzauJ != null) {
                for (String string : this.zzauJ.keySet()) {
                    Map map = this.zzauJ.get(string);
                    if (map == null) continue;
                    hashMap.put(string, map.keySet());
                }
            }
            return hashMap;
        }
    }

    static abstract class zzb<R extends Result>
    extends zznt.zza<R, com.google.android.gms.config.internal.zzc> {
        public zzb(GoogleApiClient googleApiClient) {
            super(zzpx.API, googleApiClient);
        }

        protected final void zza(com.google.android.gms.config.internal.zzc zzc2) throws RemoteException {
            this.zza(zzc2.getContext(), (zzh)zzc2.zztm());
        }

        protected abstract void zza(Context var1, zzh var2) throws RemoteException;
    }

    static abstract class zza
    extends zzg.zza {
        zza() {
        }

        @Override
        public void zza(Status status, byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zza(Status status, Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzD(Status status) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zza(Status status, FetchConfigIpcResponse fetchConfigIpcResponse) {
            throw new UnsupportedOperationException();
        }
    }
}

