/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.config.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.config.internal.AnalyticsUserProperty;
import com.google.android.gms.config.internal.CustomVariable;
import com.google.android.gms.config.internal.FetchConfigIpcRequest;
import com.google.android.gms.config.internal.FetchConfigIpcResponse;
import com.google.android.gms.config.internal.PackageConfigTable;
import com.google.android.gms.config.internal.zze;
import com.google.android.gms.config.internal.zzi;
import com.google.android.gms.config.internal.zzj;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.internal.zzta;
import com.google.android.gms.internal.zztb;
import com.google.android.gms.internal.zztc;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class zzc
implements zztb {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern GW = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern GX = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public PendingResult<zztb.zzb> zza(GoogleApiClient googleApiClient, final zztb.zza zza2) {
        if (googleApiClient == null || zza2 == null) {
            return null;
        }
        return googleApiClient.zza((zzqo.zza)new zzc(googleApiClient){

            @Override
            protected void zza(Context context, zzj zzj2) throws RemoteException {
                String string;
                String string2;
                String string3;
                DataHolder dataHolder;
                block3: {
                    DataHolder.zza zza22 = com.google.android.gms.common.data.zzd.zzaum();
                    for (Map.Entry<String, String> object2 : zza2.zzazg().entrySet()) {
                        com.google.android.gms.common.data.zzd.zza((DataHolder.zza)zza22, (SafeParcelable)new CustomVariable(object2.getKey(), object2.getValue()));
                    }
                    dataHolder = zza22.zzgc(0);
                    string3 = zzrk.zzby((Context)context) == Status.xZ ? zzrk.zzatt() : null;
                    string2 = null;
                    string = null;
                    try {
                        string2 = com.google.firebase.iid.zzc.C().getId();
                        string = com.google.firebase.iid.zzc.C().getToken();
                    }
                    catch (IllegalStateException list) {
                        if (!Log.isLoggable((String)"ConfigApiImpl", (int)3)) break block3;
                        Log.d((String)"ConfigApiImpl", (String)"Cannot retrieve instanceId or instanceIdToken.", (Throwable)list);
                    }
                }
                List<AnalyticsUserProperty> list = com.google.android.gms.config.internal.zzb.zzcq(context);
                FetchConfigIpcRequest fetchConfigIpcRequest = new FetchConfigIpcRequest(context.getPackageName(), zza2.zzazf(), dataHolder, string3, string2, string, null, zza2.zzazh(), list);
                zzj2.zza(this.Ha, fetchConfigIpcRequest);
                dataHolder.close();
            }

            protected zztb.zzb zzag(Status status) {
                return new zzd(status, new HashMap<String, TreeMap<String, byte[]>>());
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzag(status);
            }
        });
    }

    private static Status zzhl(int n) {
        return new Status(n, zztc.getStatusCodeString(n));
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(FetchConfigIpcResponse fetchConfigIpcResponse) {
        if (fetchConfigIpcResponse == null) {
            return null;
        }
        DataHolder dataHolder = fetchConfigIpcResponse.zzazr();
        if (dataHolder == null) {
            return null;
        }
        com.google.android.gms.common.data.zzd zzd2 = new com.google.android.gms.common.data.zzd(dataHolder, PackageConfigTable.CREATOR);
        PackageConfigTable packageConfigTable = (PackageConfigTable)((Object)zzd2.get(0));
        fetchConfigIpcResponse.zzazs();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : packageConfigTable.zzazt().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = packageConfigTable.zzazt().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    static abstract class zzc
    extends zzb<zztb.zzb> {
        protected zzi Ha = new zza(){

            @Override
            public void zza(Status status, FetchConfigIpcResponse fetchConfigIpcResponse) {
                if (fetchConfigIpcResponse.getStatusCode() == 6502 || fetchConfigIpcResponse.getStatusCode() == 6507) {
                    zzc.this.zzc(new zzd(zzc.zzhl(fetchConfigIpcResponse.getStatusCode()), zzc.zza(fetchConfigIpcResponse), fetchConfigIpcResponse.getThrottleEndTimeMillis()));
                } else {
                    zzc.this.zzc(new zzd(zzc.zzhl(fetchConfigIpcResponse.getStatusCode()), zzc.zza(fetchConfigIpcResponse)));
                }
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }
    }

    public static class zzd
    implements zztb.zzb {
        private final Map<String, TreeMap<String, byte[]>> Hc;
        private final Status hv;
        private final long Hd;

        public zzd(Status status, Map<String, TreeMap<String, byte[]>> map) {
            this(status, map, -1L);
        }

        public zzd(Status status, Map<String, TreeMap<String, byte[]>> map, long l) {
            this.hv = status;
            this.Hc = map;
            this.Hd = l;
        }

        @Override
        public long getThrottleEndTimeMillis() {
            return this.Hd;
        }

        @Override
        public Status getStatus() {
            return this.hv;
        }

        @Override
        public byte[] zza(String string, byte[] byArray, String string2) {
            if (this.zzah(string, string2)) {
                return this.Hc.get(string2).get(string);
            }
            return byArray;
        }

        public boolean zzah(String string, String string2) {
            if (this.Hc == null || this.Hc.get(string2) == null) {
                return false;
            }
            return this.Hc.get(string2).get(string) != null;
        }

        @Override
        public Map<String, Set<String>> zzazj() {
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            if (this.Hc != null) {
                for (String string : this.Hc.keySet()) {
                    Map map = this.Hc.get(string);
                    if (map == null) continue;
                    hashMap.put(string, map.keySet());
                }
            }
            return hashMap;
        }
    }

    static abstract class zzb<R extends Result>
    extends zzqo.zza<R, zze> {
        public zzb(GoogleApiClient googleApiClient) {
            super(zzta.API, googleApiClient);
        }

        protected final void zza(zze zze2) throws RemoteException {
            this.zza(zze2.getContext(), (zzj)zze2.zzavg());
        }

        protected abstract void zza(Context var1, zzj var2) throws RemoteException;
    }

    static abstract class zza
    extends zzi.zza {
        zza() {
        }

        @Override
        public void zza(Status status, byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zza(Status status, Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzah(Status status) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zza(Status status, FetchConfigIpcResponse fetchConfigIpcResponse) {
            throw new UnsupportedOperationException();
        }
    }
}

