/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzbnl;
import com.google.android.gms.internal.zzbnm;
import com.google.android.gms.internal.zzbnn;
import com.google.android.gms.internal.zzbnp;
import com.google.android.gms.internal.zzbnq;
import com.google.android.gms.internal.zzbnr;
import com.google.android.gms.internal.zzbns;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzc;

public class FirebaseCrash {
    private static final String LOG_TAG = FirebaseCrash.class.getSimpleName();
    private boolean zzbru;
    private zzbnp zzbZh;
    private zzbnl zzbZi;
    private static volatile FirebaseCrash zzbZj;

    FirebaseCrash(FirebaseApp firebaseApp, boolean bl) {
        this.zzbru = bl;
        Context context = firebaseApp.getApplicationContext();
        if (context == null) {
            Log.w((String)LOG_TAG, (String)"Application context is missing, disabling api");
            this.zzbru = false;
        }
        if (this.zzbru) {
            try {
                String string = firebaseApp.getOptions().getApiKey();
                String string2 = firebaseApp.getOptions().getApplicationId();
                zzbnn zzbnn2 = new zzbnn(string2, string);
                zzbnq.zzWF().zzaG(context);
                this.zzbZh = zzbnq.zzWF().zzWG();
                this.zzbZh.zza(zzd.zzA((Object)context), zzbnn2);
                this.zzbZi = new zzbnl(context);
                this.zzWB();
                String string3 = String.valueOf(zzbnq.zzWF().toString());
                Log.i((String)LOG_TAG, (String)(string3.length() != 0 ? "FirebaseCrash reporting initialized ".concat(string3) : new String("FirebaseCrash reporting initialized ")));
            }
            catch (Exception exception) {
                String string = String.valueOf(exception.getMessage());
                Log.e((String)LOG_TAG, (String)(string.length() != 0 ? "Failed to initialize crash reporting: ".concat(string) : new String("Failed to initialize crash reporting: ")));
                this.zzbru = false;
            }
        } else {
            Log.i((String)LOG_TAG, (String)"Crash reporting is disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebaseCrash zzWx() {
        if (zzbZj != null) return zzbZj;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (zzbZj != null) return zzbZj;
            zzbZj = FirebaseCrash.getInstance(FirebaseApp.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzbZj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Keep
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        zzbns.initialize(firebaseApp.getApplicationContext());
        boolean bl = (Boolean)zzbns.zzbZs.get();
        FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, bl);
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (zzbZj == null) {
                zzbZj = firebaseCrash;
                try {
                    zzbZj.zzWy();
                }
                catch (zzbnm zzbnm2) {
                    Log.d((String)LOG_TAG, (String)"Cannot register Firebase Analytics listener since Firebase Crash Reporting is not enabled");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return firebaseCrash;
        }
    }

    private void zzWy() throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        this.zzbZi.zzWD();
    }

    private zzbnp zzWz() {
        return this.zzbZh;
    }

    private boolean isEnabled() {
        return this.zzbru;
    }

    public static void log(String string) {
        try {
            FirebaseCrash.zzWx().zziB(string);
        }
        catch (zzbnm zzbnm2) {
            Log.v((String)LOG_TAG, (String)zzbnm2.getMessage());
        }
    }

    public static void logcat(int n, String string, String string2) {
        try {
            FirebaseCrash.zzWx().zze(n, string, string2);
        }
        catch (zzbnm zzbnm2) {
            Log.v((String)LOG_TAG, (String)zzbnm2.getMessage());
        }
    }

    public static void zza(String string, long l, Bundle bundle) {
        try {
            FirebaseCrash.zzWx().zzb(string, l, bundle);
        }
        catch (zzbnm zzbnm2) {
            Log.v((String)LOG_TAG, (String)zzbnm2.getMessage());
        }
    }

    public static void report(Throwable throwable) {
        try {
            FirebaseCrash.zzWx().zzh(throwable);
        }
        catch (zzbnm zzbnm2) {
            Log.v((String)LOG_TAG, (String)zzbnm2.getMessage());
        }
    }

    public void zze(int n, String string, String string2) throws zzbnm {
        if (string2 != null) {
            if (string == null) {
                string = "";
            }
            Log.println((int)n, (String)string, (String)string2);
            this.zziB(string2);
        }
    }

    public void zziB(String string) throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        zzbnp zzbnp2 = this.zzWz();
        if (zzbnp2 != null && string != null) {
            try {
                zzbnp2.log(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzb(String string, long l, Bundle bundle) throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        zzbnp zzbnp2 = this.zzWz();
        if (zzbnp2 != null && string != null) {
            try {
                zzbnp2.zzb(string, l, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzh(Throwable throwable) throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        zzbnp zzbnp2 = this.zzWz();
        if (zzbnp2 != null && throwable != null) {
            this.zzbZi.zza(false, System.currentTimeMillis());
            try {
                zzbnp2.zziC(this.zzWC());
                zzbnp2.zzN(zzd.zzA((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzi(Throwable throwable) throws zzbnm {
        if (!this.isEnabled()) {
            throw new zzbnm("Firebase Crash Reporting is disabled.");
        }
        zzbnp zzbnp2 = this.zzWz();
        if (zzbnp2 != null && throwable != null) {
            try {
                this.zzbZi.zza(true, System.currentTimeMillis());
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                zzbnp2.zziC(this.zzWC());
                zzbnp2.zzO(zzd.zzA((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    private static boolean zzWA() {
        long l;
        long l2 = Looper.getMainLooper().getThread().getId();
        return l2 == (l = Thread.currentThread().getId());
    }

    private void zzWB() {
        if (!FirebaseCrash.zzWA()) {
            throw new RuntimeException("FirebaseCrash reporting may only be initialized on the main thread (preferably in your app's Application.onCreate)");
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        zzbnr zzbnr2 = new zzbnr(uncaughtExceptionHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(zzbnr2);
    }

    private String zzWC() {
        return zzc.zzabN().getId();
    }
}

