/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.mc;
import com.google.android.gms.internal.md;
import com.google.android.gms.internal.me;
import com.google.android.gms.internal.mf;
import com.google.android.gms.internal.mi;
import com.google.android.gms.internal.mo;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import com.google.firebase.iid.FirebaseInstanceId;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection
public class FirebaseCrash {
    private static volatile FirebaseCrash zzbXQ;
    private final Context mContext;
    private final ExecutorService zzbXR;
    private final FirebaseApp zzbVX;
    private final zzb zzbXS;
    private final CountDownLatch zzbXT = new CountDownLatch(1);
    private mo zzbXU;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzbVX = firebaseApp;
        this.zzbXR = executorService;
        this.mContext = this.zzbVX.getApplicationContext();
        this.zzbXS = new zzb(null);
    }

    final void zza(@Nullable mi mi2) {
        if (mi2 == null) {
            this.zzbXR.shutdownNow();
        } else {
            this.zzbXU = mo.zzbE(this.mContext);
            this.zzbXS.zzb(mi2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzbXU != null && !firebaseCrash.zzFd()) {
                firebaseCrash.zzbXU.zza(firebaseCrash.mContext, firebaseCrash.zzbXR, firebaseCrash.zzbXS);
            }
        }
        this.zzbXT.countDown();
    }

    private final void zzFb() {
        try {
            this.zzbXT.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzFc() {
        if (zzbXQ != null) {
            return zzbXQ;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzbXQ != null) return zzbXQ;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzbXQ != null) return zzbXQ;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, FirebaseInstanceId.getInstance().getId());
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<mi> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzbXR.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzbXQ = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbXQ;
        }
    }

    public final boolean zzFd() {
        return this.zzbXR.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzFc().zzgy(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFc();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzgy(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFc();
        if (throwable2 == null || firebaseCrash.zzFd()) {
            return;
        }
        firebaseCrash.zzbXR.submit(new mc(firebaseCrash.mContext, firebaseCrash.zzbXS, throwable2, firebaseCrash.zzbXU));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzFc();
        if (!firebaseCrash.zzFd()) {
            firebaseCrash.zzbXR.submit(new mf(firebaseCrash.mContext, firebaseCrash.zzbXS, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzFc().zzFe();
    }

    private final boolean zzFe() {
        if (this.zzFd()) {
            return false;
        }
        this.zzFb();
        mi mi2 = this.zzbXS.zzFf();
        if (mi2 != null) {
            try {
                return mi2.zzFe();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzgy(String string) {
        if (string == null || this.zzFd()) {
            return;
        }
        this.zzbXR.submit(new md(this.mContext, this.zzbXS, string));
    }

    @Nullable
    final Future<?> zze(Throwable throwable) {
        if (throwable == null || this.zzFd()) {
            return null;
        }
        return this.zzbXR.submit(new me(this.mContext, this.zzbXS, throwable, this.zzbXU));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzFb();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzbXY;
        private /* synthetic */ FirebaseCrash zzbXV;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzbXV = firebaseCrash;
            this.zzbXY = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzbXV.zzFd()) {
                try {
                    Future<?> future = this.zzbXV.zze(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzbXY != null) {
                this.zzbXY.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzbXW = new Object();
        private mi zzbXX;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final mi zzFf() {
            Object object = this.zzbXW;
            synchronized (object) {
                return this.zzbXX;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable mi mi2) {
            Object object = this.zzbXW;
            synchronized (object) {
                this.zzbXX = mi2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public mi zzFf();
    }
}

