/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.zzdmc;
import com.google.android.gms.internal.zzdmd;
import com.google.android.gms.internal.zzdme;
import com.google.android.gms.internal.zzdmf;
import com.google.android.gms.internal.zzdmi;
import com.google.android.gms.internal.zzdmo;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zzljt;
    private final Context mContext;
    private final ExecutorService zzlju;
    private final FirebaseApp zzlga;
    private final zzb zzljv;
    private final CountDownLatch zzljw = new CountDownLatch(1);
    private zzdmo zzljx;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzlga = firebaseApp;
        this.zzlju = executorService;
        this.mContext = this.zzlga.getApplicationContext();
        this.zzljv = new zzb(null);
    }

    final void zza(@Nullable zzdmi zzdmi2) {
        if (zzdmi2 == null) {
            this.zzlju.shutdownNow();
        } else {
            this.zzljx = zzdmo.zzeh(this.mContext);
            this.zzljv.zzb(zzdmi2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzljx != null && !firebaseCrash.zzboy()) {
                firebaseCrash.zzljx.zza(firebaseCrash.mContext, firebaseCrash.zzlju, firebaseCrash.zzljv);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzljw.countDown();
    }

    private final void zzbow() {
        try {
            this.zzljw.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzbox() {
        if (zzljt != null) {
            return zzljt;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzljt != null) return zzljt;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzljt != null) return zzljt;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<zzdmi> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzlju.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzljt = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzljt;
        }
    }

    public final boolean zzboy() {
        return this.zzlju.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzbox().zzoj(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbox();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzoj(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbox();
        if (throwable2 == null || firebaseCrash.zzboy()) {
            return;
        }
        firebaseCrash.zzlju.submit(new zzdmc(firebaseCrash.mContext, firebaseCrash.zzljv, throwable2, firebaseCrash.zzljx));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbox();
        if (!firebaseCrash.zzboy()) {
            firebaseCrash.zzlju.submit(new zzdmf(firebaseCrash.mContext, firebaseCrash.zzljv, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzbox().zzboz();
    }

    private final boolean zzboz() {
        if (this.zzboy()) {
            return false;
        }
        this.zzbow();
        zzdmi zzdmi2 = this.zzljv.zzbpa();
        if (zzdmi2 != null) {
            try {
                return zzdmi2.zzboz();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzoj(String string) {
        if (string == null || this.zzboy()) {
            return;
        }
        this.zzlju.submit(new zzdmd(this.mContext, this.zzljv, string));
    }

    @Nullable
    final Future<?> zzd(Throwable throwable) {
        if (throwable == null || this.zzboy()) {
            return null;
        }
        return this.zzlju.submit(new zzdme(this.mContext, this.zzljv, throwable, this.zzljx));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzbow();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzlkb;
        private /* synthetic */ FirebaseCrash zzljy;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzljy = firebaseCrash;
            this.zzlkb = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzljy.zzboy()) {
                try {
                    Future<?> future = this.zzljy.zzd(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzlkb != null) {
                this.zzlkb.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzljz = new Object();
        private zzdmi zzlka;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzdmi zzbpa() {
            Object object = this.zzljz;
            synchronized (object) {
                return this.zzlka;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable zzdmi zzdmi2) {
            Object object = this.zzljz;
            synchronized (object) {
                this.zzlka = zzdmi2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public zzdmi zzbpa();
    }
}

