/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.zzdno;
import com.google.android.gms.internal.zzdnp;
import com.google.android.gms.internal.zzdnq;
import com.google.android.gms.internal.zzdnr;
import com.google.android.gms.internal.zzdnu;
import com.google.android.gms.internal.zzdoa;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zzloj;
    private final Context mContext;
    private final ExecutorService zzlok;
    private final FirebaseApp zzlkm;
    private final zzb zzlol;
    private final CountDownLatch zzlom = new CountDownLatch(1);
    private zzdoa zzlon;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzlkm = firebaseApp;
        this.zzlok = executorService;
        this.mContext = this.zzlkm.getApplicationContext();
        this.zzlol = new zzb(null);
    }

    final void zza(@Nullable zzdnu zzdnu2) {
        if (zzdnu2 == null) {
            this.zzlok.shutdownNow();
        } else {
            this.zzlon = zzdoa.zzei(this.mContext);
            this.zzlol.zzb(zzdnu2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzlon != null && !firebaseCrash.zzbpk()) {
                firebaseCrash.zzlon.zza(firebaseCrash.mContext, firebaseCrash.zzlok, firebaseCrash.zzlol);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzlom.countDown();
    }

    private final void zzbpi() {
        try {
            this.zzlom.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzbpj() {
        if (zzloj != null) {
            return zzloj;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzloj != null) return zzloj;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzloj != null) return zzloj;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<zzdnu> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzlok.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzloj = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzloj;
        }
    }

    public final boolean zzbpk() {
        return this.zzlok.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzbpj().zzov(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbpj();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzov(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbpj();
        if (throwable2 == null || firebaseCrash.zzbpk()) {
            return;
        }
        firebaseCrash.zzlok.submit(new zzdno(firebaseCrash.mContext, firebaseCrash.zzlol, throwable2, firebaseCrash.zzlon));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbpj();
        if (!firebaseCrash.zzbpk()) {
            firebaseCrash.zzlok.submit(new zzdnr(firebaseCrash.mContext, firebaseCrash.zzlol, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzbpj().zzbpl();
    }

    private final boolean zzbpl() {
        if (this.zzbpk()) {
            return false;
        }
        this.zzbpi();
        zzdnu zzdnu2 = this.zzlol.zzbpm();
        if (zzdnu2 != null) {
            try {
                return zzdnu2.zzbpl();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzov(String string) {
        if (string == null || this.zzbpk()) {
            return;
        }
        this.zzlok.submit(new zzdnp(this.mContext, this.zzlol, string));
    }

    @Nullable
    final Future<?> zze(Throwable throwable) {
        if (throwable == null || this.zzbpk()) {
            return null;
        }
        return this.zzlok.submit(new zzdnq(this.mContext, this.zzlol, throwable, this.zzlon));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzbpi();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzlor;
        private /* synthetic */ FirebaseCrash zzloo;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzloo = firebaseCrash;
            this.zzlor = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzloo.zzbpk()) {
                try {
                    Future<?> future = this.zzloo.zze(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzlor != null) {
                this.zzlor.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzlop = new Object();
        private zzdnu zzloq;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzdnu zzbpm() {
            Object object = this.zzlop;
            synchronized (object) {
                return this.zzloq;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable zzdnu zzdnu2) {
            Object object = this.zzlop;
            synchronized (object) {
                this.zzloq = zzdnu2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public zzdnu zzbpm();
    }
}

