/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor;

import com.google.common.base.Optional;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWAttribute;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWForm;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRange;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.AttributeProcessor;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.CompilationUnitContext;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.NamedRangesResolver;
import java.util.Collections;
import java.util.List;

public class NamedRangesAttributeProcessor
implements AttributeProcessor<List<NamedRange>> {
    private final long offset;
    private final CompilationUnitContext cuContext;
    private final NamedRangesResolver namedRangesResolver;
    private String name;
    private String linkageName;
    private boolean isDeclaration;
    private boolean isInline;
    private long specification = -1L;
    private long abstractOrigin = -1L;
    private long highPc = -1L;
    private boolean isHighPcAddress;
    private long lowPc = -1L;
    private long rangesOffset = -1L;

    public NamedRangesAttributeProcessor(long offset, CompilationUnitContext cuContext, NamedRangesResolver namedRangesResolver) {
        this.offset = offset;
        this.cuContext = cuContext;
        this.namedRangesResolver = namedRangesResolver;
    }

    @Override
    public void processAttribute(DWAttribute attribute, DWForm form, byte[] value) {
        switch (attribute) {
            case HIGH_PC: {
                this.highPc = this.cuContext.fileContext.referenceBytesConverter.asLongValue(value);
                this.isHighPcAddress = false;
                break;
            }
            case INLINE: {
                this.isInline = true;
                break;
            }
        }
    }

    @Override
    public void processAttribute(DWAttribute attribute, long value) {
        switch (attribute) {
            case DECLARATION: {
                this.isDeclaration = value == 1L;
                break;
            }
            case SPECIFICATION: {
                this.specification = value;
                break;
            }
            case ABSTRACT_ORIGIN: {
                this.abstractOrigin = value;
                break;
            }
            case LOW_PC: {
                this.lowPc = value;
                break;
            }
            case HIGH_PC: {
                this.highPc = value;
                this.isHighPcAddress = true;
                break;
            }
            case RANGES: {
                this.rangesOffset = value;
                break;
            }
        }
    }

    @Override
    public void processAttribute(DWAttribute attribute, String value) {
        switch (attribute) {
            case NAME: {
                this.name = value;
                break;
            }
            case LINKAGE_NAME: {
                this.linkageName = value;
                break;
            }
        }
    }

    @Override
    public List<NamedRange> finishProcessingAttributes() {
        String resolvedName = (String)Optional.fromNullable((Object)this.linkageName).or(Optional.fromNullable((Object)this.name)).orNull();
        if (resolvedName == null) {
            String string = this.specification >= 0L ? this.cuContext.specificationMap.get(this.specification) : (resolvedName = this.abstractOrigin >= 0L ? this.cuContext.abstractOriginMap.get(this.abstractOrigin) : null);
        }
        if (resolvedName != null) {
            if (this.isDeclaration) {
                this.cuContext.specificationMap.put(this.offset, resolvedName);
            }
            if (this.isInline) {
                this.cuContext.abstractOriginMap.put(this.offset, resolvedName);
            }
        } else {
            resolvedName = "<unknown>";
        }
        if (this.lowPc >= 0L && this.highPc >= 0L) {
            if (!this.isHighPcAddress) {
                this.highPc += this.lowPc;
            }
            return Collections.singletonList(new NamedRange(resolvedName, this.lowPc, this.highPc));
        }
        if (this.rangesOffset >= 0L) {
            return this.namedRangesResolver.resolveNamedRanges(this.rangesOffset, resolvedName, this.cuContext.getLowPc());
        }
        return Collections.emptyList();
    }
}

