/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.api;

import com.google.firebase.crashlytics.buildtools.AppBuildInfo;
import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.Obfuscator;
import com.google.firebase.crashlytics.buildtools.api.MappingFileService;
import com.google.firebase.crashlytics.buildtools.api.WebApi;
import com.google.firebase.crashlytics.buildtools.exception.ZeroByteFileException;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class FirebaseMappingFileService
implements MappingFileService {
    private static final String MAPPING_UPLOAD_REQUEST_FORMAT = "%s/v1/project/-/app/%s/upload/java/%s";
    private final WebApi webApi;

    public FirebaseMappingFileService(WebApi webApi) {
        this.webApi = webApi;
    }

    @Override
    public void uploadMappingFile(File mappingFile, String mappingFileId, AppBuildInfo appBuildInfo, Obfuscator obfuscator) throws IOException {
        if (mappingFile.length() == 0L) {
            throw new ZeroByteFileException(String.format("Mapping file '%s' is zero bytes, skipping upload.", mappingFile.getAbsolutePath()));
        }
        File gZippedMappingFile = new File(FirebaseMappingFileService.getMappingBuildDir(appBuildInfo.getBuildDir()), mappingFileId + ".gz");
        Buildtools.logD("Zipping mapping file: " + mappingFile + " -> " + gZippedMappingFile);
        FileUtils.gZipFile(mappingFile, gZippedMappingFile);
        URL url = new URL(String.format(MAPPING_UPLOAD_REQUEST_FORMAT, this.webApi.getCodeMappingApiUrl(), appBuildInfo.getGoogleAppId(), mappingFileId));
        this.webApi.uploadFile(url, gZippedMappingFile);
        gZippedMappingFile.delete();
    }

    private static File getMappingBuildDir(File buildDir) throws IOException {
        File workingDir = new File(buildDir, "mappings");
        FileUtils.verifyDirectory(workingDir);
        return workingDir;
    }
}

